defmodule Faker.Food.Hy do
  import Faker, only: [sampler: 2]

  @moduledoc """
  Functions for food data in Armenian.
  """

  @doc """
  Returns a dish.

  ## Examples

      iex> Faker.Food.Hy.dish()
      "ձու շոտլանդական ձևով"
      iex> Faker.Food.Hy.dish()
      "պիցցա"
      iex> Faker.Food.Hy.dish()
      "խորոված կողիկներ"
      iex> Faker.Food.Hy.dish()
      "սաղմոն նիգիրի"
  """
  @spec dish() :: String.t()
  sampler(:dish, [
    "խորոված կողիկներ",
    "կեսարի աղցան",
    "չիզբուրգեր",
    "հավի ֆահիտա",
    "հավի թևիկներ",
    "ֆետուչինե ալֆրեդո",
    "ձուկ և չիպսեր",
    "ֆրանսիական կարտոֆիլ երշիկով",
    "ֆրանսիական տոստ",
    "հումուս",
    "քյաբաբ",
    "լազանյա",
    "կոլոլակ սոուսով",
    "ռիզոտտո սնկով",
    "մակարոն և լոբի",
    "մակարոն տոմատով և ռեհանով",
    "պիցցա",
    "խոզի կոտլետներ",
    "ռավիոլի",
    "սաղմոն նիգիրի",
    "ձու շոտլանդական ձևով",
    "սուվլակի",
    "սուշի",
    "մեքսիկական տակո",
    "թյուննոս սաշիմի",
    "բուսական ապուր",
    "ավելուկի ապուր",
    "պասուց տոլմա",
    "լոբով ապուր",
    "քռչիկ",
    "բոզբաշ",
    "հաճարով և սնկով փլավ",
    "ղափամա",
    "հարիսա",
    "խաշ"
  ])

  @doc """
  Returns a description.

  ## Examples

      iex> Faker.Food.Hy.description()
      "Տապակած հավ վաֆլիների հետ: Մատուցվում է թխկիի օշարակով:"
      iex> Faker.Food.Hy.description()
      "Երեք ձվի օմլետ ռոքֆոր պանրով, մանր սոխ և խոզապուխտ: Կողքը ավելացրեք խորոված կարտոֆիլ և ֆրանսիական տոստ:"
      iex> Faker.Food.Hy.description()
      "Ապխտած սաղմոն, խոզապուխտով ձու, կարմիր սոխ և լոլիկի սոուս բուլկիի վրա: Կողքը ավելացրեք խորոված կարտոֆիլ:"
      iex> Faker.Food.Hy.description()
      "Երեք ձու, համեմ, լոլիկ, սոխ, ավոկադո և հալած պանիր: Կողքը ավելացրեք խորոված կարտոֆիլ և ֆրանսիական տոստ:"
  """
  @spec description() :: String.t()
  sampler(:description, [
    "Երեք ձու, համեմ, լոլիկ, սոխ, ավոկադո և հալած պանիր: Կողքը ավելացրեք խորոված կարտոֆիլ և ֆրանսիական տոստ:",
    "Երեք ձվի օմլետ ռոքֆոր պանրով, մանր սոխ և խոզապուխտ: Կողքը ավելացրեք խորոված կարտոֆիլ և ֆրանսիական տոստ:",
    "Երեք ձվի սպիտակուց, սպանախ, սունկ, կարամելացված սոխ, լոլիկ և ցածր յուղայնությամբ ֆետա պանիր: Կողքը ավելացրեք սև հաց կամ ֆրանսիական տոստ:",
    "Ապխտած սաղմոն, խոզապուխտով ձու, կարմիր սոխ և լոլիկի սոուս բուլկիի վրա: Կողքը ավելացրեք խորոված կարտոֆիլ:",
    "Թարմ մաղադանոս, իտալական երշիկ, կեռաս, սխտոր, լոլիկ և մոցարելլա պանիր: Կողքը ավելացրեք մրգեր:",
    "Ֆրանսիական տոստ, շաքարավազ, կաթ, վանիլին և շաքարի փոշի: Ավելացրեք ցանկացած ձևով պատրաստված երկու ձու, խոզապուխտի հետ:",
    "Տապակած հավ վաֆլիների հետ: Մատուցվում է թխկիի օշարակով:",
    "Թարմ նորվեգական սաղմոն, թեթևորեն խառնված մանանեխի սոուսով: Մատուցվում է բրնձի և խաշած բանջարեղենի հետ:"
  ])

  @doc """
  Returns an ingredient.

  ## Examples

      iex> Faker.Food.Hy.ingredient()
      "ոսպ"
      iex> Faker.Food.Hy.ingredient()
      "մշկընկույզ"
      iex> Faker.Food.Hy.ingredient()
      "ընկույզ"
      iex> Faker.Food.Hy.ingredient()
      "սամիթ"
  """
  @spec ingredient() :: String.t()
  sampler(:ingredient, [
    "առվույտ",
    "նշի յուղ",
    "նուշ",
    "անձրուկ",
    "խնձորի քացախ",
    "խնձոր",
    "ծիրան",
    "կանկար",
    "ասիական արիշտա",
    "ծնեբեկ",
    "սմբուկ",
    "ավոկադո",
    "ավոկադոյի յուղ",
    "բեկոն",
    "խմորի սոդա",
    "բանան",
    "ծորենի",
    "գարի",
    "բրինձ",
    "լոբի",
    "կանաչ լոբի",
    "տավարի միս",
    "ճակնդեղ",
    "մոշ",
    "հապալաս",
    "հաց",
    "տարեկանի հաց",
    "սպիտակ հաց",
    "բրի պանիր",
    "բրոկոլի",
    "բրյուսելյան կաղամբ",
    "հնդկաձավար",
    "բուլղուր",
    "կարագ",
    "թան",
    "կաղամբ",
    "կակաո",
    "երիցուկ",
    "կանոլայի յուղ",
    "հիլ",
    "գազար",
    "ծաղկակաղամբ",
    "կարմիր պատիճապղպեղ",
    "նեխուր",
    "նեխուրի սերմ",
    "չեդեր պանիր",
    "կեռաս",
    "բալ",
    "շագանակ",
    "հավ",
    "կիտրոն",
    "չիլի պղպեղ",
    "մանր սոխ",
    "շոկոլադ",
    "դարչին",
    "մեխակ",
    "կակաոյի փոշի",
    "կոկոս",
    "կոկոսի յուղ",
    "սուրճ",
    "եգիպտացորենի ձեթ",
    "կաթնաշոռ",
    "ծովախեցգետին",
    "լոռամիրգ",
    "սեր",
    "կրեմ",
    "վարունգ",
    "չաման",
    "հաղարջ",
    "կարրիի փոշի",
    "խտուտիկ",
    "խուրմա",
    "սամիթ",
    "ծիրանաչիր",
    "բադ",
    "սմբուկ",
    "բադրիջան",
    "ձու",
    "ֆեյխոա",
    "ֆենխել",
    "ֆետա պանիր",
    "թուզ",
    "ալյուր",
    "գալանգալ",
    "սխտոր",
    "այծի պանիր",
    "այծի կաթ",
    "խաղողի սերմի յուղ",
    "գրեյպֆրուտ",
    "խաղող",
    "կանաչ բիբար",
    "կանաչ թեյ",
    "խոզապուխտ",
    "պնդուկ",
    "կաղին",
    "մեղր",
    "ծովաբողկ",
    "հումուս",
    "դոնդող",
    "կիվի",
    "գառան միս",
    "կիտրոն",
    "ոսպ",
    "կաթնուկ",
    "օմար",
    "մշկընկույզ",
    "սկումբրիա",
    "մանդարին",
    "մանգո",
    "մարգարին",
    "սեխ",
    "կաթ",
    "անանուխ",
    "մոցառելլա",
    "սունկ",
    "մանանեխ",
    "նեկտարին",
    "վարսակ",
    "ութոտնուկ",
    "ձիթապտղի ձեթ",
    "ձիթապտուղ",
    "սոխ",
    "նարինջ",
    "օրեգոնո",
    "ոստրե",
    "տանձ",
    "պապայա",
    "պարմեզան պանիր",
    "մաղադանոս",
    "մակարոն",
    "դեղձ",
    "գետնանուշ",
    "սիսեռ",
    "անանուխ",
    "արքայախնձոր",
    "պիստակ",
    "սալոր",
    "նուռ",
    "խոզի միս",
    "կարտոֆիլ",
    "պրովոլոն պանիր",
    "դդում",
    "բողկ",
    "չամիչ",
    "ազնվամորի",
    "կարմիր կաղամբ",
    "բրինձ",
    "խնկունի",
    "աշորա",
    "սաղմոն",
    "սարդինաձուկ",
    "երշիկ",
    "նրբերշիկ",
    "ծովի աղ",
    "իշխան",
    "սիգ",
    "սոյա",
    "գանգրակաղամբ",
    "սպանախ",
    "դդմիկ",
    "ելակ",
    "շաքար",
    "արեւածաղկի ձեթ",
    "արեւածաղկի սերմ",
    "թրաձուկ",
    "թարխուն",
    "թեյ",
    "լոլիկ",
    "թյուննոս",
    "հնդկահավ",
    "քացախ",
    "ընկույզ",
    "ձմերուկ",
    "ցորեն",
    "յոգուրտ",
    "ցուկկինի"
  ])

  @doc """
  Returns a type of measurement.

  ## Examples

      iex> Faker.Food.Hy.measurement()
      "թեյի գդալ"
      iex> Faker.Food.Hy.measurement()
      "գալոն"
      iex> Faker.Food.Hy.measurement()
      "պինտա"
      iex> Faker.Food.Hy.measurement()
      "բաժակ"
  """
  @spec measurement() :: String.t()
  sampler(:measurement, ["թեյի գդալ", "ճաշի գդալ", "բաժակ", "պինտա", "կվարտա", "գալոն"])

  @doc """
  Returns a measurement size.

  ## Examples

      iex> Faker.Food.Hy.measurement_size()
      "1/4"
      iex> Faker.Food.Hy.measurement_size()
      "3"
      iex> Faker.Food.Hy.measurement_size()
      "1"
      iex> Faker.Food.Hy.measurement_size()
      "1/2"
  """
  @spec measurement_size() :: String.t()
  sampler(:measurement_size, ["1/4", "1/3", "1/2", "1", "2", "3"])

  @doc """
  Returns a metric measurement.

  ## Examples

      iex> Faker.Food.Hy.metric_measurement()
      "սանտիլիտր"
      iex> Faker.Food.Hy.metric_measurement()
      "դեցիլիտր"
      iex> Faker.Food.Hy.metric_measurement()
      "լիտր"
      iex> Faker.Food.Hy.metric_measurement()
      "միլիլիտր"
  """
  @spec metric_measurement() :: String.t()
  sampler(:metric_measurement, ["միլիլիտր", "դեցիլիտր", "սանտիլիտր", "լիտր"])

  @doc """
  Returns a spicy ingredient.

  ## Examples

      iex> Faker.Food.Hy.spice()
      "կայնեյան պղպեղ"
      iex> Faker.Food.Hy.spice()
      "պիրի պիրի համեմունք"
      iex> Faker.Food.Hy.spice()
      "կարամ մասալա"
      iex> Faker.Food.Hy.spice()
      "մանանեխ"
  """
  @spec spice() :: String.t()
  sampler(:spice, [
    "պղպեղ հոտավետ",
    "անիսոն",
    "հետոոտիկ",
    "ասաֆոեթիդա",
    "ռեհան",
    "կաժունի համեմունք",
    "քարդամոմ",
    "կայնեյան պղպեղ",
    "նեխուր",
    "նեխուրի սերմ",
    "երիցուկ",
    "կերբելուկ",
    "չիլի պղպեղ",
    "մանր սոխ",
    "դարչին",
    "մեխակ",
    "գինձ",
    "համեմ",
    "չաման",
    "մաղադանոս",
    "սուսամբար",
    "մանանեխ",
    "հազրեվարդ",
    "բահար",
    "անանուխ",
    "խնկունի",
    "կարամ մասալա",
    "սամիթ",
    "կոճապղպեղ",
    "քրքում",
    "բերբերին",
    "ծորենի",
    "մշկընկույզ",
    "դափնու տերև",
    "կարրի",
    "գալանգալ",
    "սխտոր",
    "լավանդ",
    "պղպեղ",
    "պղպեղահատ",
    "պիրի պիրի համեմունք",
    "զաֆրան",
    "քնջութ",
    "թարխուն",
    "ուրց",
    "քրքում",
    "վանիլ"
  ])
end
