/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class MParse
extends Task {
    private Path classpath = null;
    private Path sourcepath = null;
    private File metahome = null;
    private File target = null;
    private boolean verbose = false;
    private boolean debugparser = false;
    private boolean debugscanner = false;
    private boolean cleanup = false;
    private CommandlineJava cmdl = new CommandlineJava();
    private File optionsFile = null;

    public void setMetamatahome(File file) {
        this.metahome = file;
    }

    public void setTarget(File file) {
        this.target = file;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath;
    }

    public Path createSourcepath() {
        if (this.sourcepath == null) {
            this.sourcepath = new Path(this.project);
        }
        return this.sourcepath;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setDebugscanner(boolean bl) {
        this.debugscanner = bl;
    }

    public void setDebugparser(boolean bl) {
        this.debugparser = bl;
    }

    public void setCleanup(boolean bl) {
        this.cleanup = bl;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public void setMaxmemory(String string) {
        if (Project.getJavaVersion().startsWith("1.1")) {
            this.createJvmarg().setValue("-mx" + string);
        } else {
            this.createJvmarg().setValue("-Xmx" + string);
        }
    }

    public MParse() {
        this.cmdl.setVm("java");
        this.cmdl.setClassname("com.metamata.jj.MParse");
    }

    public void execute() throws BuildException {
        try {
            this.setUp();
            ExecuteStreamHandler executeStreamHandler = this.createStreamHandler();
            this._execute(executeStreamHandler);
            Object var3_2 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    protected ExecuteStreamHandler createStreamHandler() {
        return new LogStreamHandler((Task)this, 2, 2);
    }

    protected void setUp() throws BuildException {
        this.checkOptions();
        File[] fileArray = this.getMetamataLibs();
        Path path = this.cmdl.createClasspath(this.project);
        int n = 0;
        while (n < fileArray.length) {
            path.createPathElement().setLocation(fileArray[n]);
            ++n;
        }
        Commandline.Argument argument = this.cmdl.createVmArgument();
        argument.setValue("-Dmetamata.home=" + this.metahome.getAbsolutePath());
        String[] stringArray = this.getOptions();
        this.optionsFile = MParse.createTmpFile();
        this.generateOptionsFile(this.optionsFile, stringArray);
        Commandline.Argument argument2 = this.cmdl.createArgument();
        argument2.setLine("-arguments " + this.optionsFile.getAbsolutePath());
    }

    protected void _execute(ExecuteStreamHandler executeStreamHandler) throws BuildException {
        String string = this.target.getAbsolutePath();
        int n = string.length() - ".jj".length();
        File file = new File(string = string.substring(0, n) + ".java");
        if (file.exists() && this.target.lastModified() < file.lastModified()) {
            this.project.log("Target is already build - skipping (" + this.target + ")");
            return;
        }
        Execute execute = new Execute(executeStreamHandler);
        this.log(this.cmdl.toString(), 3);
        execute.setCommandline(this.cmdl.getCommandline());
        try {
            if (execute.execute() != 0) {
                throw new BuildException("Metamata task failed.");
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to launch Metamata task: " + iOException);
        }
    }

    protected void cleanUp() {
        if (this.optionsFile != null) {
            this.optionsFile.delete();
            this.optionsFile = null;
        }
        if (this.cleanup) {
            String string = this.target.getName();
            int n = string.length() - ".jj".length();
            string = "__jj" + string.substring(0, n) + ".sunjj";
            File file = new File(this.target.getParent(), string);
            if (file.exists()) {
                this.project.log("Removing stale file: " + file.getName());
                file.delete();
            }
        }
    }

    protected File[] getMetamataLibs() {
        Vector<File> vector = new Vector<File>();
        vector.addElement(new File(this.metahome, "lib/metamata.jar"));
        vector.addElement(new File(this.metahome, "bin/lib/JavaCC.zip"));
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void checkOptions() throws BuildException {
        if (this.metahome == null || !this.metahome.exists()) {
            throw new BuildException("'metamatahome' must point to Metamata home directory.");
        }
        this.metahome = this.project.resolveFile(this.metahome.getPath());
        File[] fileArray = this.getMetamataLibs();
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].exists()) {
                throw new BuildException(fileArray[n] + " does not exist. Check your metamata installation.");
            }
            ++n;
        }
        if (this.target == null || !this.target.isFile() || !this.target.getName().endsWith(".jj")) {
            throw new BuildException("Invalid target: " + this.target);
        }
        this.target = this.project.resolveFile(this.target.getPath());
    }

    protected String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.verbose) {
            vector.addElement("-verbose");
        }
        if (this.debugscanner) {
            vector.addElement("-ds");
        }
        if (this.debugparser) {
            vector.addElement("-dp");
        }
        if (this.classpath != null) {
            vector.addElement("-classpath");
            vector.addElement(this.classpath.toString());
        }
        if (this.sourcepath != null) {
            vector.addElement("-sourcepath");
            vector.addElement(this.sourcepath.toString());
        }
        vector.addElement(this.target.getAbsolutePath());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateOptionsFile(File file, String[] stringArray) throws BuildException {
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(file);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                int n = 0;
                while (true) {
                    if (n >= stringArray.length) {
                        printWriter.flush();
                        break;
                    }
                    printWriter.println(stringArray[n]);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while writing options file " + file, (Throwable)iOException);
            }
            Object var7_7 = null;
            if (fileWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileWriter.close();
        return;
    }

    protected static final File createTmpFile() {
        long l = new Random(System.currentTimeMillis()).nextLong();
        File file = new File("metamata" + l + ".tmp");
        return file;
    }
}

