/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class JUnitTask
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;

    public void setHaltonerror(boolean bl) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest baseTest = (BaseTest)enumeration.nextElement();
            baseTest.setHaltonerror(bl);
        }
    }

    public void setHaltonfailure(boolean bl) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest baseTest = (BaseTest)enumeration.nextElement();
            baseTest.setHaltonfailure(bl);
        }
    }

    public void setFork(boolean bl) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest baseTest = (BaseTest)enumeration.nextElement();
            baseTest.setFork(bl);
        }
    }

    public void setPrintsummary(boolean bl) {
        this.summary = bl;
    }

    public void setTimeout(Integer n) {
        this.timeout = n;
    }

    public void setMaxmemory(String string) {
        if (Project.getJavaVersion().startsWith("1.1")) {
            this.createJvmarg().setValue("-mx" + string);
        } else {
            this.createJvmarg().setValue("-Xmx" + string);
        }
    }

    public void setJvm(String string) {
        this.commandline.setVm(string);
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void addSysproperty(Environment.Variable variable) {
        this.commandline.addSysproperty(variable);
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.project).createPath();
    }

    public void addTest(JUnitTest jUnitTest) {
        this.tests.addElement(jUnitTest);
    }

    public BatchTest createBatchTest() {
        BatchTest batchTest = new BatchTest(this.project);
        this.batchTests.addElement(batchTest);
        return batchTest;
    }

    public void addFormatter(FormatterElement formatterElement) {
        this.formatters.addElement(formatterElement);
    }

    public JUnitTask() throws Exception {
        this.commandline.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
    }

    public void execute() throws BuildException {
        Enumeration enumeration = this.getIndividualTests();
        while (enumeration.hasMoreElements()) {
            JUnitTest jUnitTest = (JUnitTest)enumeration.nextElement();
            if (!jUnitTest.shouldRun(this.project)) continue;
            this.execute(jUnitTest);
        }
    }

    protected void execute(JUnitTest jUnitTest) throws BuildException {
        boolean bl;
        if (jUnitTest.getTodir() == null) {
            jUnitTest.setTodir(this.project.resolveFile("."));
        }
        if (jUnitTest.getOutfile() == null) {
            jUnitTest.setOutfile("TEST-" + jUnitTest.getName());
        }
        int n = 2;
        boolean bl2 = false;
        if (!jUnitTest.getFork()) {
            n = this.executeInVM(jUnitTest);
        } else {
            ExecuteWatchdog executeWatchdog = this.createWatchdog();
            n = this.executeAsForked(jUnitTest, executeWatchdog);
            if (executeWatchdog != null) {
                // empty if block
            }
        }
        boolean bl3 = n == 2;
        boolean bl4 = bl = n != 0;
        if (bl3 && jUnitTest.getHaltonerror() || bl && jUnitTest.getHaltonfailure()) {
            throw new BuildException("Test " + jUnitTest.getName() + " failed", this.location);
        }
        if (bl3 || bl) {
            this.log("TEST " + jUnitTest.getName() + " FAILED", 0);
        }
    }

    private int executeAsForked(JUnitTest jUnitTest, ExecuteWatchdog executeWatchdog) throws BuildException {
        FormatterElement formatterElement;
        CommandlineJava commandlineJava = (CommandlineJava)this.commandline.clone();
        commandlineJava.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
        commandlineJava.createArgument().setValue(jUnitTest.getName());
        commandlineJava.createArgument().setValue("haltOnError=" + jUnitTest.getHaltonerror());
        commandlineJava.createArgument().setValue("haltOnFailure=" + jUnitTest.getHaltonfailure());
        if (this.summary) {
            this.log("Running " + jUnitTest.getName(), 2);
            commandlineJava.createArgument().setValue("formatter=org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        FormatterElement[] formatterElementArray = this.mergeFormatters(jUnitTest);
        int n = 0;
        while (n < formatterElementArray.length) {
            formatterElement = formatterElementArray[n];
            stringBuffer.append("formatter=");
            stringBuffer.append(formatterElement.getClassname());
            File file = this.getOutput(formatterElement, jUnitTest);
            if (file != null) {
                stringBuffer.append(",");
                stringBuffer.append(file);
            }
            commandlineJava.createArgument().setValue(stringBuffer.toString());
            stringBuffer.setLength(0);
            ++n;
        }
        formatterElement = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), executeWatchdog);
        formatterElement.setCommandline(commandlineJava.getCommandline());
        if (this.dir != null) {
            formatterElement.setWorkingDirectory(this.dir);
            formatterElement.setAntRun(this.project);
        }
        this.log("Executing: " + commandlineJava.toString(), 3);
        try {
            return formatterElement.execute();
        }
        catch (IOException iOException) {
            throw new BuildException("Process fork failed.", (Throwable)iOException, this.location);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int executeInVM(JUnitTest jUnitTest) throws BuildException {
        int n;
        CommandlineJava.SysProperties sysProperties;
        if (this.dir != null) {
            this.log("dir attribute ignored if running in the same VM", 1);
        }
        if ((sysProperties = this.commandline.getSystemProperties()) != null) {
            sysProperties.setSystem();
        }
        try {
            Object object;
            this.log("Using System properties " + System.getProperties(), 3);
            AntClassLoader antClassLoader = null;
            Path path = this.commandline.getClasspath();
            if (path != null) {
                this.log("Using CLASSPATH " + path, 3);
                antClassLoader = new AntClassLoader(this.project, path, false);
                antClassLoader.addSystemPackageRoot("junit");
                antClassLoader.addSystemPackageRoot("org.apache.tools.ant");
            }
            JUnitTestRunner jUnitTestRunner = new JUnitTestRunner(jUnitTest, jUnitTest.getHaltonerror(), jUnitTest.getHaltonfailure(), (ClassLoader)antClassLoader);
            if (this.summary) {
                this.log("Running " + jUnitTest.getName(), 2);
                object = new SummaryJUnitResultFormatter();
                ((SummaryJUnitResultFormatter)object).setOutput(this.getDefaultOutput());
                jUnitTestRunner.addFormatter((JUnitResultFormatter)object);
            }
            object = this.mergeFormatters(jUnitTest);
            int n2 = 0;
            while (n2 < ((FormatterElement[])object).length) {
                FormatterElement formatterElement = object[n2];
                File file = this.getOutput(formatterElement, jUnitTest);
                if (file != null) {
                    formatterElement.setOutfile(file);
                } else {
                    formatterElement.setOutput(this.getDefaultOutput());
                }
                jUnitTestRunner.addFormatter(formatterElement.createFormatter());
                ++n2;
            }
            jUnitTestRunner.run();
            n = jUnitTestRunner.getRetCode();
            Object var11_11 = null;
            if (sysProperties == null) return n;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (sysProperties == null) throw throwable;
            sysProperties.restoreSystem();
            throw throwable;
        }
        sysProperties.restoreSystem();
        return n;
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout.intValue());
    }

    protected OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    protected Enumeration getIndividualTests() {
        Enumeration[] enumerationArray = new Enumeration[this.batchTests.size() + 1];
        int n = 0;
        while (n < this.batchTests.size()) {
            BatchTest batchTest = (BatchTest)this.batchTests.elementAt(n);
            enumerationArray[n] = batchTest.elements();
            ++n;
        }
        enumerationArray[enumerationArray.length - 1] = this.tests.elements();
        return Enumerations.fromCompound(enumerationArray);
    }

    protected Enumeration allTests() {
        Enumeration[] enumerationArray = new Enumeration[]{this.tests.elements(), this.batchTests.elements()};
        return Enumerations.fromCompound(enumerationArray);
    }

    private FormatterElement[] mergeFormatters(JUnitTest jUnitTest) {
        Vector vector = (Vector)this.formatters.clone();
        jUnitTest.addFormattersTo(vector);
        Object[] objectArray = new FormatterElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected File getOutput(FormatterElement formatterElement, JUnitTest jUnitTest) {
        if (formatterElement.getUseFile()) {
            String string = jUnitTest.getOutfile() + formatterElement.getExtension();
            File file = new File(jUnitTest.getTodir(), string);
            String string2 = file.getAbsolutePath();
            return this.project.resolveFile(string2);
        }
        return null;
    }
}

