/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Package;
import com.ibm.ivj.util.base.Project;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;

public class VAJWorkspaceScanner
extends DirectoryScanner {
    private static final String[] DEFAULTEXCLUDES = new String[]{"IBM*/**", "Java class libraries/**", "Sun class libraries*/**", "JSP Page Compile Generated Code/**", "VisualAge*/**"};
    private Vector packagesIncluded = new Vector();

    public void addDefaultExcludes() {
        int n = this.excludes == null ? 0 : this.excludes.length;
        String[] stringArray = new String[n + DEFAULTEXCLUDES.length];
        if (n > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n);
        }
        int n2 = 0;
        while (n2 < DEFAULTEXCLUDES.length) {
            stringArray[n2 + n] = DEFAULTEXCLUDES[n2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++n2;
        }
        this.excludes = stringArray;
    }

    public Vector findMatchingProjects() {
        Project[] projectArray = VAJUtil.getWorkspace().getProjects();
        Vector<Project> vector = new Vector<Project>();
        boolean bl = false;
        int n = 0;
        while (n < projectArray.length) {
            Project project = projectArray[n];
            int n2 = 0;
            while (n2 < this.includes.length && !bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.includes[n2], File.separator);
                String string = stringTokenizer.nextToken();
                if (string.equals("**")) {
                    bl = true;
                } else if (VAJWorkspaceScanner.match(string, project.getName())) {
                    vector.addElement(project);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            vector = new Vector();
            int n3 = 0;
            while (n3 < projectArray.length) {
                vector.addElement(projectArray[n3]);
                ++n3;
            }
        }
        return vector;
    }

    public Package[] getIncludedPackages() {
        int n = this.packagesIncluded.size();
        Package[] packageArray = new Package[n];
        int n2 = 0;
        while (n2 < n) {
            packageArray[n2] = (Package)this.packagesIncluded.elementAt(n2);
            ++n2;
        }
        return packageArray;
    }

    protected static boolean match(String string, String string2) {
        return DirectoryScanner.match((String)string, (String)string2);
    }

    public void scan() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        Vector vector = this.findMatchingProjects();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Project project = (Project)enumeration.nextElement();
            this.scanProject(project);
        }
    }

    public void scanProject(Project project) {
        try {
            Package[] packageArray = project.getPackages();
            if (packageArray != null) {
                int n = 0;
                while (n < packageArray.length) {
                    Package package_ = packageArray[n];
                    String string = String.valueOf(project.getName()) + File.separator + package_.getName().replace('.', File.separatorChar);
                    if (this.isIncluded(string) && !this.isExcluded(string)) {
                        this.packagesIncluded.addElement(package_);
                    }
                    ++n;
                }
            }
        }
        catch (IvjException ivjException) {
            throw VAJUtil.createBuildException("VA Exception occured: ", ivjException);
        }
    }
}

