/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCCheckout
extends ClearCase {
    private boolean m_Reserved = true;
    private String m_Out = null;
    private boolean m_Ndata = false;
    private String m_Branch = null;
    private boolean m_Version = false;
    private boolean m_Nwarn = false;
    private String m_Comment = null;
    private String m_Cfile = null;
    public static final String FLAG_RESERVED = "-reserved";
    public static final String FLAG_UNRESERVED = "-unreserved";
    public static final String FLAG_OUT = "-out";
    public static final String FLAG_NODATA = "-ndata";
    public static final String FLAG_BRANCH = "-branch";
    public static final String FLAG_VERSION = "-version";
    public static final String FLAG_NOWARN = "-nwarn";
    public static final String FLAG_COMMENT = "-c";
    public static final String FLAG_COMMENTFILE = "-cfile";
    public static final String FLAG_NOCOMMENT = "-nc";

    public void execute() throws BuildException {
        Commandline commandline = new Commandline();
        Project project = this.getProject();
        int n = 0;
        if (this.getViewPath() == null) {
            this.setViewPath(project.getBaseDir().getPath());
        }
        commandline.setExecutable(this.getClearToolCommand());
        commandline.createArgument().setValue("checkout");
        this.checkOptions(commandline);
        n = this.run(commandline);
        if (n != 0) {
            String string = "Failed executing: " + commandline.toString();
            throw new BuildException(string, this.location);
        }
    }

    private void checkOptions(Commandline commandline) {
        if (this.getReserved()) {
            commandline.createArgument().setValue(FLAG_RESERVED);
        } else {
            commandline.createArgument().setValue(FLAG_UNRESERVED);
        }
        if (this.getOut() != null) {
            this.getOutCommand(commandline);
        } else if (this.getNoData()) {
            commandline.createArgument().setValue(FLAG_NODATA);
        }
        if (this.getBranch() != null) {
            this.getBranchCommand(commandline);
        } else if (this.getVersion()) {
            commandline.createArgument().setValue(FLAG_VERSION);
        }
        if (this.getNoWarn()) {
            commandline.createArgument().setValue(FLAG_NOWARN);
        }
        if (this.getComment() != null) {
            this.getCommentCommand(commandline);
        } else if (this.getCommentFile() != null) {
            this.getCommentFileCommand(commandline);
        } else {
            commandline.createArgument().setValue(FLAG_NOCOMMENT);
        }
        commandline.createArgument().setValue(this.getViewPath());
    }

    public void setReserved(boolean bl) {
        this.m_Reserved = bl;
    }

    public boolean getReserved() {
        return this.m_Reserved;
    }

    public void setOut(String string) {
        this.m_Out = string;
    }

    public String getOut() {
        return this.m_Out;
    }

    public void setNoData(boolean bl) {
        this.m_Ndata = bl;
    }

    public boolean getNoData() {
        return this.m_Ndata;
    }

    public void setBranch(String string) {
        this.m_Branch = string;
    }

    public String getBranch() {
        return this.m_Branch;
    }

    public void setVersion(boolean bl) {
        this.m_Version = bl;
    }

    public boolean getVersion() {
        return this.m_Version;
    }

    public void setNoWarn(boolean bl) {
        this.m_Nwarn = bl;
    }

    public boolean getNoWarn() {
        return this.m_Nwarn;
    }

    public void setComment(String string) {
        this.m_Comment = string;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setCommentFile(String string) {
        this.m_Cfile = string;
    }

    public String getCommentFile() {
        return this.m_Cfile;
    }

    private void getOutCommand(Commandline commandline) {
        if (this.getOut() != null) {
            commandline.createArgument().setValue(FLAG_OUT);
            commandline.createArgument().setValue(this.getOut());
        }
    }

    private void getBranchCommand(Commandline commandline) {
        if (this.getBranch() != null) {
            commandline.createArgument().setValue(FLAG_BRANCH);
            commandline.createArgument().setValue(this.getBranch());
        }
    }

    private void getCommentCommand(Commandline commandline) {
        if (this.getComment() != null) {
            commandline.createArgument().setValue(FLAG_COMMENT);
            commandline.createArgument().setValue(this.getComment());
        }
    }

    private void getCommentFileCommand(Commandline commandline) {
        if (this.getCommentFile() != null) {
            commandline.createArgument().setValue(FLAG_COMMENTFILE);
            commandline.createArgument().setValue(this.getCommentFile());
        }
    }
}

