/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLiaison;

public class XSLTProcess
extends MatchingTask {
    private File destDir = null;
    private File baseDir = null;
    private File xslFile = null;
    private String targetExtension = ".html";
    private Vector params = new Vector();
    private File inFile = null;
    private File outFile = null;
    private XSLTLiaison liaison;

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            this.baseDir = this.project.resolveFile(".");
        }
        if (this.destDir == null) {
            String string = "destdir attributes must be set!";
            throw new BuildException(string);
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
        this.log("Transforming into " + this.destDir, 2);
        if (this.liaison == null) {
            try {
                this.setProcessor("trax");
            }
            catch (Throwable throwable) {
                try {
                    this.setProcessor("xslp");
                }
                catch (Throwable throwable2) {
                    try {
                        this.setProcessor("xalan");
                    }
                    catch (Throwable throwable3) {
                        throw new BuildException(throwable);
                    }
                }
            }
        }
        this.log("Using " + this.liaison.getClass().toString(), 3);
        long l = 0L;
        if (this.xslFile != null) {
            try {
                File file = new File(this.baseDir, this.xslFile.toString());
                l = file.lastModified();
                this.log("Loading stylesheet " + file, 2);
                this.liaison.setStylesheet(file.toString());
                Enumeration enumeration = this.params.elements();
                while (enumeration.hasMoreElements()) {
                    Param param = (Param)enumeration.nextElement();
                    this.liaison.addParam(param.getName(), param.getExpression());
                }
            }
            catch (Exception exception) {
                this.log("Failed to read stylesheet " + this.xslFile, 2);
                throw new BuildException(exception);
            }
        }
        if (this.inFile != null && this.outFile != null) {
            this.process(this.inFile, this.outFile, l);
            return;
        }
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            this.process(this.baseDir, stringArray[n], this.destDir, l);
            ++n;
        }
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray = new File(this.baseDir, stringArray2[n2]).list();
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.process(this.baseDir, stringArray[n3], this.destDir, l);
                ++n3;
            }
            ++n2;
        }
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setExtension(String string) {
        this.targetExtension = string;
    }

    public void setStyle(String string) {
        this.xslFile = new File(string);
    }

    public void setProcessor(String string) throws Exception {
        if (string.equals("trax")) {
            Class<?> clazz = Class.forName("org.apache.tools.ant.taskdefs.optional.TraXLiaison");
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (string.equals("xslp")) {
            Class<?> clazz = Class.forName("org.apache.tools.ant.taskdefs.optional.XslpLiaison");
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (string.equals("xalan")) {
            Class<?> clazz = Class.forName("org.apache.tools.ant.taskdefs.optional.XalanLiaison");
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else {
            this.liaison = (XSLTLiaison)Class.forName(string).newInstance();
        }
    }

    public void setOut(File file) {
        this.outFile = file;
    }

    public void setIn(File file) {
        this.inFile = file;
    }

    private void process(File file, String string, File file2, long l) throws BuildException {
        String string2 = this.targetExtension;
        File file3 = null;
        File file4 = null;
        try {
            file4 = new File(file, string);
            int n = string.lastIndexOf(46);
            file3 = n > 0 ? new File(file2, string.substring(0, string.lastIndexOf(46)) + string2) : new File(file2, string + string2);
            if (file4.lastModified() > file3.lastModified() || l > file3.lastModified()) {
                this.ensureDirectoryFor(file3);
                this.log("Transforming into " + file2);
                this.liaison.transform(file4.toString(), file3.toString());
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + file4, 2);
            if (file3 != null) {
                file3.delete();
            }
            throw new BuildException(exception);
        }
    }

    private void process(File file, File file2, long l) throws BuildException {
        try {
            this.log("In file " + file + " time: " + file.lastModified(), 4);
            this.log("Out file " + file2 + " time: " + file2.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + l, 4);
            if (file.lastModified() > file2.lastModified() || l > file2.lastModified()) {
                this.ensureDirectoryFor(file2);
                this.log("Processing " + file + " to " + file2, 2);
                this.liaison.transform(file.toString(), file2.toString());
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + file, 2);
            if (file2 != null) {
                file2.delete();
            }
            throw new BuildException(exception);
        }
    }

    private void ensureDirectoryFor(File file) throws BuildException {
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new BuildException("Unable to create directory: " + file2.getAbsolutePath());
        }
    }

    public Param createParam() {
        Param param = new Param();
        this.params.addElement(param);
        return param;
    }

    public class Param {
        private String name = null;
        private String expression = null;

        public void setName(String string) {
            this.name = string;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }
    }
}

