# Copyright 2020 Jack Grigg
#
# Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
# http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
# <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
# option. This file may not be copied, modified, or distributed
# except according to those terms.

### Localization for strings in the rage CLI tools

## Terms (not to be localized)

-age = age
-age-plugin- = age-plugin-
-rage = rage
-rage-keygen = rage-keygen
-stdin = "-"
-recipient-prefix = age1
-identity-prefix = AGE-SECRET-KEY-1
-armor-pem-type = AGE ENCRYPTED FILE

-rage-mount = rage-mount

-ssh-rsa = ssh-rsa
-ssh-ed25519 = ssh-ed25519
-ssh-authorized-keys = authorized_keys
-dot-keys = .keys
-ssh = ssh(1)
-authorized-keys-file-format = AUTHORIZED_KEYS FILE FORMAT
-sshd = sshd(8)
-ssh-agent = ssh-agent(1)

-example = example
-example-r = age1example1
-example-i = AGE-PLUGIN-EXAMPLE-1

-yubikey = yubikey

## CLI flags (not to be localized)

-flag-armor = -a/--armor
-flag-decrypt = -d/--decrypt
-flag-encrypt = -e/--encrypt
-flag-identity = -i/--identity
-flag-output = -o/--output
-flag-recipient = -r/--recipient
-flag-recipients-file = -R/--recipients-file
-flag-passphrase = -p/--passphrase
-flag-plugin-name = -j
-flag-max-work-factor = --max-work-factor
-flag-unstable = --features unstable

-flag-convert = -y

-flag-mnt-types = -t/--types

## Usage

usage-header = Usage

recipient = RECIPIENT
recipients-file = PATH
identity = IDENTITY
plugin-name = PLUGIN-NAME
input = INPUT
output = OUTPUT

args-header = Arguments

help-arg-input = Path to a file to read from.

flags-header = Options

help-flag-help = Print this help message and exit.
help-flag-version = Print version info and exit.
help-flag-encrypt = Encrypt the input (the default).
help-flag-decrypt = Decrypt the input.
help-flag-passphrase = Encrypt with a passphrase instead of recipients.
help-flag-max-work-factor = Maximum work factor to allow for passphrase decryption.
help-flag-armor = Encrypt to a PEM encoded format.
help-flag-recipient = Encrypt to the specified {recipient}. May be repeated.
help-flag-recipients-file = Encrypt to the recipients listed at {recipients-file}. May be repeated.
help-flag-identity = Use the identity file at {identity}. May be repeated.
help-flag-plugin-name = Use {-age-plugin-}{plugin-name} in its default mode as an identity.
help-flag-output = Write the result to the file at path {output}.

rage-after-help-content =
    {input} defaults to standard input, and {output} defaults to standard output.
    If {output} exists, it will be overwritten.

    {recipient} can be:
    - An {-age} public key, as generated by {$keygen_name} ({$example_age_pubkey}).
    - An SSH public key ({$example_ssh_pubkey}).

    {recipients-file} is a path to a file containing {-age} recipients, one per line
    (ignoring "#" prefixed comments and empty lines). {-stdin} may be used to
    read recipients from standard input.

    {identity} is a path to a file with {-age} identities, one per line
    (ignoring "#" prefixed comments and empty lines), or to an SSH key file.
    Passphrase-encrypted {-age} identity files can be used as identity files.
    Multiple identities may be provided, and any unused ones will be ignored.
    {-stdin} may be used to read identities from standard input.

rage-after-help-example =
    Example:
    {"  "}{$example_a}
    {"  "}{tty-pubkey}: {$example_a_output}
    {"  "}{$example_b}
    {"  "}{$example_c}

keygen-help-flag-output = {help-flag-output} Defaults to standard output.
keygen-help-flag-convert = Convert an identity file to a recipients file.

## Formatting

warning-msg = Warning: {$warning}

## Keygen messages

tty-pubkey = Public key
identity-file-created = created
identity-file-pubkey = public key

## Encryption messages

autogenerated-passphrase = Using an autogenerated passphrase:
type-passphrase = Type passphrase
prompt-passphrase = Passphrase

warn-double-encrypting = Encrypting an already-encrypted file

## General errors

err-failed-to-open-input = Failed to open input: {$err}
err-failed-to-open-output = Failed to open output: {$err}
err-failed-to-read-input = Failed to read from input: {$err}
err-failed-to-write-output = Failed to write to output: {$err}
err-identity-ambiguous = {-flag-identity} requires either {-flag-encrypt} or {-flag-decrypt}.
err-mixed-encrypt-decrypt = {-flag-encrypt} can't be used with {-flag-decrypt}.
err-passphrase-timed-out = Timed out waiting for passphrase input.
err-same-input-and-output = Input and output are the same file '{$filename}'.

err-ux-A = Did {-rage} not do what you expected? Could an error be more useful?
err-ux-B = Tell us
# Put (len(A) - len(B) - 32) spaces here.
err-ux-C = {"                          "}

## Encryption errors

err-enc-broken-stdout = Could not write to stdout: {$err}
rec-enc-broken-stdout = Are you piping to a program that isn't reading from stdin?

err-enc-broken-file = Could not write to file: {$err}

rec-enc-missing-recipients = Did you forget to specify {-flag-recipient}?

err-enc-mixed-identity-passphrase = {-flag-identity} can't be used with {-flag-passphrase}.
err-enc-mixed-recipient-passphrase = {-flag-recipient} can't be used with {-flag-passphrase}.
err-enc-mixed-recipients-file-passphrase = {-flag-recipients-file} can't be used with {-flag-passphrase}.
err-enc-passphrase-without-file = File to encrypt must be passed as an argument when using {-flag-passphrase}.

err-enc-plugin-name-flag = {-flag-plugin-name} can't be used with {-flag-encrypt}.

## Decryption errors

err-detected-powershell-corruption = It looks like this file was corrupted by PowerShell redirection.
rec-detected-powershell-corruption = Consider using {-flag-output} or {-flag-armor} to encrypt files in PowerShell.

rec-dec-excessive-work = To decrypt, retry with {-flag-max-work-factor} {$wf}

err-dec-armor-flag = {-flag-armor} can't be used with {-flag-decrypt}.
rec-dec-armor-flag = Note that armored files are detected automatically.

err-dec-missing-identities = Missing identities.
rec-dec-missing-identities = Did you forget to specify {-flag-identity}?
rec-dec-missing-identities-stdin = Did you forget to provide the identity over standard input?

err-dec-mixed-identity-passphrase = {-flag-identity} can't be used with passphrase-encrypted files.

err-mixed-identity-and-plugin-name = {-flag-identity} can't be used with {-flag-plugin-name}.

err-dec-passphrase-flag = {-flag-passphrase} can't be used with {-flag-decrypt}.
rec-dec-passphrase-flag = Note that passphrase-encrypted files are detected automatically.

err-dec-passphrase-without-file-win =
    This file requires a passphrase, and on Windows the
    file to decrypt must be passed as a positional argument
    when decrypting with a passphrase.

err-dec-recipient-flag = {-flag-recipient} can't be used with {-flag-decrypt}.
err-dec-recipients-file-flag = {-flag-recipients-file} can't be used with {-flag-decrypt}.
rec-dec-recipient-flag = Did you mean to use {-flag-identity} to specify a private key?

## rage-mount strings

mnt-filename = FILENAME
mnt-mountpoint = MOUNTPOINT
mnt-types = TYPES

help-arg-mnt-filename = The encrypted filesystem to mount.
help-arg-mnt-mountpoint = The directory to mount the filesystem at.
help-arg-mnt-types = Indicates the filesystem type (one of {$types}).

info-decrypting = Decrypting {$filename}
info-mounting-as-fuse = Mounting as FUSE filesystem

err-mnt-missing-filename = Missing filename.
err-mnt-missing-mountpoint = Missing mountpoint.
err-mnt-missing-types = Missing {-flag-mnt-types}.
err-mnt-unknown-type = Unknown filesystem type "{$fs_type}"

## Unstable features

test-unstable = To test this, build {-rage} with {-flag-unstable}.

## rage manpage

recipients = RECIPIENTS
identities = IDENTITIES

man-rage-about = A simple, secure, and modern encryption tool

man-rage-description =
    {-rage} encrypts or decrypts {input} to {output}. The {input} argument is
    optional and defaults to standard input. Only a single {input} file may be
    specified. If {-flag-output} is not specified, {output} defaults to standard
    output.

    If {-flag-passphrase} is specified, the file is encrypted with a passphrase
    requested interactively. Otherwise, it's encrypted to one or more
    {recipients} specified with {-flag-recipient} or
    {-flag-recipients-file}. Every recipient can decrypt the file.

    In {-flag-decrypt} mode, passphrase-encrypted files are detected automatically
    and the passphrase is requested interactively. Otherwise, one or more
    {identities} specified with {-flag-identity} are used to decrypt the file.

    {-age} encrypted files are binary and not malleable, with around 200 bytes of
    overhead per recipient, plus 16 bytes every 64KiB of plaintext.

man-rage-flag-output =
    Write encrypted or decrypted file to {output} instead of standard output.
    If {output} already exists it will be overwritten.

    If encrypting without {-flag-armor}, {-rage} will refuse to output binary to a
    TTY. This can be forced by specifying {-stdin} as {output}.

man-rage-encryption-options = Encryption options

man-rage-flag-encrypt =
    Encrypt {input} to {output}. This is the default.

man-rage-flag-recipient =
    Encrypt to the explicitly specified {recipient}. See the
    {man-rage-recipients-and-identities-heading} section for possible recipient
    formats.

    This option can be repeated and combined with other recipient flags,
    and the file can be decrypted by all provided recipients independently.

man-rage-flag-recipients-file =
    Encrypt to the {recipients} listed in the file at {recipients-file}, one per
    line. Empty lines and lines starting with "#" are ignored as comments.

    If {recipients-file} is {-stdin}, the recipients are read from standard
    input. In this case, the {input} argument must be specified.

    This option can be repeated and combined with other recipient flags,
    and the file can be decrypted by all provided recipients independently.

man-rage-flag-passphrase =
    Encrypt with a passphrase, requested interactively from the terminal.
    {-rage} will offer to auto-generate a secure passphrase.

    This option can't be used with other recipient flags.

man-rage-flag-armor =
    Encrypt to an ASCII-only "armored" encoding.

    {-age} armor is a strict version of PEM with type "{-armor-pem-type}",
    canonical "strict" Base64, no headers, and no support for leading and
    trailing extra data.

    Decryption transparently detects and decodes ASCII armoring.

man-rage-flag-identity-encrypt =
    Encrypt to the {recipients} corresponding to the {identities} listed in the
    file at {identity}. This is equivalent to converting the file at {identity}
    to a recipients file with '{-rage-keygen} {-flag-convert}' and then passing that to
    {-flag-recipients-file}.

    For the format of {identity}, see the definition of {-flag-identity} in the
    {man-rage-decryption-options} section.

    {-flag-encrypt} must be explicitly specified when using {-flag-identity}
    in encryption mode to avoid confusion.

man-rage-flag-plugin-encrypt =
    Encrypt using the data-less plugin {plugin-name}.

    This is equivalent to using {-flag-identity} with a file that contains a
    single plugin {identity} that encodes no plugin-specific data.

    {-flag-encrypt} must be explicitly specified when using {-flag-plugin-name}
    in encryption mode to avoid confusion.

man-rage-decryption-options = Decryption options

man-rage-flag-decrypt =
    Decrypt {input} to {output}.

    If {input} is passphrase encrypted, it will be automatically detected
    and the passphrase will be requested interactively. Otherwise, the
    {identities} specified with {-flag-identity} are used.

    ASCII armoring is transparently detected and decoded.

man-rage-flag-identity-decrypt =
    Decrypt using the {identities} at {identity}.

    {identity} may be one of the following:

    a. A file listing {identities} one per line. Empty lines and lines starting
    with "#" are ignored as comments.

    b. A passphrase encrypted age file, containing {identities} one per
    line like above. The passphrase is requested interactively. Note that
    passphrase-protected identity files are not necessary for most use cases,
    where access to the encrypted identity file implies access to the whole
    system.

    c. An SSH private key file, in PKCS#1, PKCS#8, or OpenSSH format.
    If the private key is password-protected, the password is requested
    interactively only if the SSH identity matches the file. See the
    {man-rage-ssh-keys-heading} section for more information, including
    supported key types.

    d. {-stdin}, causing one of the options above to be read from standard input.
    In this case, the {input} argument must be specified.

    This option can be repeated. Identities are tried in the order in which are
    provided, and the first one matching one of the file's recipients is used.
    Unused identities are ignored, but it is an error if the {input} file is
    passphrase-encrypted and {-flag-identity} is specified.

man-rage-flag-plugin-decrypt =
    Decrypt using the data-less plugin {plugin-name}.

    This is equivalent to using {-flag-identity} with a file that contains a
    single plugin {identity} that encodes no plugin-specific data.

man-rage-recipients-and-identities-heading = RECIPIENTS AND IDENTITIES
man-rage-recipients-and-identities =
    {recipients} are public values, like a public key, that a file can be encrypted
    to. {identities} are private values, like a private key, that allow decrypting
    a file encrypted to the corresponding {recipient}.

man-rage-native-x25519-keys-heading = Native X25519 keys
man-rage-native-x25519-keys =
    Native {-age} key pairs are generated with {-rage-keygen}(1), and provide small
    encodings and strong encryption based on X25519. They are the recommended
    recipient type for most applications.

    A {recipient} encoding begins with "{-recipient-prefix}" and looks like the
    following:

    {"    "}{$example_age_recipient}

    An {identity} encoding begins with "{-identity-prefix}" and looks like the
    following:

    {"    "}{$example_age_identity}

    An encrypted file can't be linked to the native recipient it's encrypted to
    without access to the corresponding identity.

man-rage-ssh-keys-heading = SSH keys
man-rage-ssh-keys =
    As a convenience feature, {-rage} also supports encrypting to RSA or Ed25519
    {-ssh} keys. RSA keys must be at least 2048 bits. This feature employs more
    complex cryptography, and should only be used when a native key is not available
    for the recipient. Note that SSH keys might not be protected long-term by the
    recipient, since they are revokable when used only for authentication.

    A {recipient} encoding is an SSH public key in "{-ssh-authorized-keys}" format
    (see the "{-authorized-keys-file-format}" section of {-sshd}), starting with
    "{-ssh-rsa}" or "{-ssh-ed25519}", like the following:

    {"    "}{$example_ssh_rsa}
    {"    "}{$example_ssh_ed25519}

    The comment at the end of the line, if present, is ignored.

    In recipient files passed to {-flag-recipients-file}, unsupported but valid
    SSH public keys are ignored with a warning, to facilitate using
    "{-ssh-authorized-keys}" or GitHub "{-dot-keys}" files. (See {man-examples-heading}.)

    An {identity} is an SSH private key _file_ passed individually to
    {-flag-identity}. Note that keys held on hardware tokens such as YubiKeys
    or accessed via {-ssh-agent} are not supported.

    An encrypted file _can_ be linked to the SSH public key it was encrypted to.
    This is so that {-rage} can identify the correct SSH private key before
    requesting its password, if any.

man-rage-plugins-heading = Plugins
man-rage-plugins =
    {-rage} can be extended through plugins. A plugin is only loaded if a corresponding
    {recipient} or {identity} is specified. (Simply decrypting a file encrypted with
    a plugin will not cause it to load, for security reasons among others.)

    A {recipient} for a plugin named "{-example}" starts with "{-example-r}", while an
    {identity} starts with "{-example-i}". They both encode arbitrary plugin-specific
    data, and are generated by the plugin.

    When either is specified, {-rage} searches for {-age-plugin-}{-example} in the PATH
    and executes it to perform the file header encryption or decryption. The plugin
    may request input from the user through {-rage} to complete the operation.

    Plugins can be freely mixed with other plugins or natively supported keys.

    A plugin is not bound to only encrypt or decrypt files meant for or generated by
    the plugin. For example, a plugin can be used to decrypt files encrypted to a
    native X25519 {recipient} or even with a passphrase. Similarly, a plugin can
    encrypt a file such that it can be decrypted without the use of any plugin.

    Plugins for which the {identity}/{recipient} distinction doesn't make sense
    (such as a symmetric encryption plugin) may generate only an {identity} and
    instruct the user to perform encryption with the {-flag-encrypt} and
    {-flag-identity} flags. Plugins for which the concept of separate identities
    doesn't make sense (such as a password-encryption plugin) may instruct the user
    to use the {-flag-plugin-name} flag.

man-examples-heading = EXAMPLES

man-rage-example-single = Generate a new identity, encrypt data, and decrypt
man-rage-example-enc-multiple = Encrypt {$input} to multiple recipients and output to {$output}
man-rage-example-enc-list = Encrypt to a list of recipients
man-rage-example-password = Encrypt and decrypt a file using a passphrase
man-rage-example-identity-passphrase = Encrypt and decrypt with a passphrase-protected identity file
man-rage-example-ssh = Encrypt and decrypt with an SSH public key
man-rage-example-yubikey = Encrypt and decrypt with {-age-plugin-}{-yubikey}
man-rage-example-yubikey-setup = Run interactive setup, generate identity file and obtain recipient.
man-rage-example-enc-github = Encrypt to the SSH keys of a GitHub user

man-see-also-heading = SEE ALSO

## rage-keygen manpage

man-keygen-about = Generate age-compatible encryption key pairs

man-keygen-description =
    {-rage-keygen} generates a new native {-age} key pair, and outputs the identity to
    standard output or to the {output} file. The output includes the public key and
    the current time as comments.

    If the output is not going to a terminal, {-rage-keygen} prints the public key to
    standard error.

man-keygen-flag-output =
    Write the identity to {output} instead of standard output.

    If {output} already exists, it is not overwritten.

man-keygen-flag-convert =
    Read an identity file from {input} or from standard input and output the
    corresponding recipient(s), one per line, with no comments.

man-keygen-example-stdout = Generate a new identity
man-keygen-example-file = Write a new identity to "{$filename}"
man-keygen-example-convert = Convert an identity to a recipient

## rage-mount manpage

man-mount-about = Mount an {-age} encrypted filesystem

man-mount-description =
    {-rage-mount} decrypts the {-age} encrypted filesystem at {mnt-filename} on the
    fly, and mounts it as a directory on the local filesystem at {mnt-mountpoint}.

    Passphrase-encrypted files are detected automatically and the passphrase is
    requested interactively. Otherwise, one or more {identities} specified with
    {-flag-identity} are used to decrypt the file.

    The previous contents (if any) and owner and mode of {mnt-mountpoint} become
    invisible, and as long as this filesystem remains mounted, the pathname
    {mnt-mountpoint} refers to the root of the filesystem on {mnt-filename}.

man-mount-flag-types =
    Set the filesystem type. The following types are currently supported: {$types}.

    This option is required. {-rage-mount} does not attempt to guess the filesystem
    format.

    In theory, any efficiently-seekable filesystem format can be supported. At
    present, {-rage-mount} only supports seekable archive formats.

man-mount-example-identity = Mounting an archive encrypted to a recipient
man-mount-example-passphrase = Mounting an archive encrypted with a passphrase
