RabbitMQ `3.9.3` is a maintenance release in the `3.9.x` release series that addresses a regression introduced in `3.9.0`.
All users are recommended to upgrade to this release.

[This is what changed since v3.9.2](https://github.com/rabbitmq/rabbitmq-server/compare/v3.9.3...v3.9.3).

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if you are upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.0.5 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.

### Core Server

#### Bug Fixes

 * Queues that had messages with per-message TTL in them could fail to recover their indices after a restart.

   GitHub issues: [#3284](https://github.com/rabbitmq/rabbitmq-server/pull/3284), [#3272](https://github.com/rabbitmq/rabbitmq-server/discussions/3272)

 * JSON logging could fail with an exception when a logged event included epoch-based timestamp value.

   GitHub issue: [#3281](https://github.com/rabbitmq/rabbitmq-server/pull/3281)

 * JSON logging now uses integers (as opposed to floats) to represent epoch-based timestamps

   GitHub issue: [#3282](https://github.com/rabbitmq/rabbitmq-server/pull/3282)

### Enhancements

 * RabbitMQ application no longer reports the `stopping` event to systemd. This was counterproductive when the application was stopped but the runtime (Erlang VM) was kept running,
   e.g. via `rabbitmqctl stop_app` or by the pause minority partition handling strategy.

   Now systemd service monitoring will recognize a node as stopped only when the runtime is stopped, which is usually the behavior operators expect.

   GitHub issues: [#3289](https://github.com/rabbitmq/rabbitmq-server/issues/3289), [#3280](https://github.com/rabbitmq/rabbitmq-server/pull/3280)



## Dependency Upgrades

No dependency changes in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.3.tar.xz` instead of the source tarball produced by GitHub.
