## RabbitMQ 3.7.3

RabbitMQ `3.7.3` is a patch release with some bug fixes and enhancements.

### Upgrades and Compatibility

This release has no known incompatibilities with earlier 3.7.x versions.
See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades.

See [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Logging to `amq.rabbitmq.log` exchange is available again as a logging mechanism. Note that
   the user must opt-in by setting `log.exchange = true` in the [config file](http://rabbitmq.com/configure.html).
 
   GitHub issue: [rabbitmq-server#1456](https://github.com/rabbitmq/rabbitmq-server/issues/1456)

 * During node boot, the logger will temporarily accept a much higher maximum rate so that no messages are dropped.
 
   GitHub issue: [rabbitmq-server#1471](https://github.com/rabbitmq/rabbitmq-server/issues/1471)

 * Plugin activation could hang if a plugin's channel interceptor failed to activate with an exception.
 
   GitHub issue: [rabbitmq-server#1477](https://github.com/rabbitmq/rabbitmq-server/pull/1477)

 * During node boot, virtual host that are not yet initialised could be queried for status, which
   resulted in log noise.
   
   GitHub issue: [rabbitmq-server#1472](https://github.com/rabbitmq/rabbitmq-server/pull/1482)

#### Enhancements

 * [Internal authN backend](https://www.rabbitmq.com/access-control.html) will now prohibit logins with blank passwords. Such attempts
   are usually made by mistake because a passwordless user that was meant to authenticate
   using [x509 (TLS) certificates](https://github.com/rabbitmq/rabbitmq-auth-mechanism-ssl/) was not configured to use the correct [authentication
   mechanism](https://www.rabbitmq.com/authentication.html).

   Note that the same behavior can already be achieved using a [credential validator](https://www.rabbitmq.com/passwords.html), so this is
   just an extra safety measure.
   
   GitHub issue: [rabbitmq-server#1465](https://github.com/rabbitmq/rabbitmq-server/pull/1465)


### Management Plugin

#### Bug Fixes

 * Definition import now stores global parameters in a way that the MQTT plugin expects.
 
   GitHub issue: [rabbitmq-management#528](https://github.com/rabbitmq/rabbitmq-management/issues/528)

 * User update form now successfully updates tags for passwordless users (or if the password is cleared at the same time).
  
   GitHub issue: [rabbitmq-management#533](https://github.com/rabbitmq/rabbitmq-management/issues/533)

#### Enhancements

 * Requeue is now the default option in the Get Messages section.
 
   Contributed by @dparkinson.
 
   GitHub issue: [rabbitmq-management#542](https://github.com/rabbitmq/rabbitmq-management/pull/542)

 * For [passwordless users](https://www.rabbitmq.com/passwords.html), the "no password" option on the user editing form is now preselected.
 
   GitHub issue: [rabbitmq-management#537](https://github.com/rabbitmq/rabbitmq-management/issues/537)


### LDAP AuthN/AuthZ Backend Plugin

#### Bug Fixes

 * More config keys are now supported via [new style config format](https://www.rabbitmq.com/configure.html).
 
   GitHub issue: [rabbitmq-auth-backend-ldap#78](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/78)


### Peer Discovery Consul Plugin

 * When a node registers with Consul it will now set its initial health check status to `passing`.
   Previously the node would be in the `critical` state until it first reported its health for the
   first time (in 15 seconds with default settings), which could prevent its peers from discovering it.
 
   Kudos to @andersenleo for investigating this issue and recommending a solution.
 
   GitHub issue: [rabbitmq-peer-discovery-consul#8](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/issues/8)


### CLI Tools

#### Bug Fixes

 * CLI tools honor `RABBITMQ_CTL_ERL_ARGS` again.
  
   GitHub issue: [rabbitmq-server#1461](https://github.com/rabbitmq/rabbitmq-server/issues/1461) 



## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.3.tar.gz`.
