[![Test](https://github.com/rabbitmq/rabbitmq-server/actions/workflows/test.yaml/badge.svg)](https://github.com/rabbitmq/rabbitmq-server/actions/workflows/test.yaml)

# RabbitMQ Server

[RabbitMQ](https://rabbitmq.com) is a [feature rich](https://www.rabbitmq.com/docs),
multi-protocol messaging and streaming broker. It supports:

 * AMQP 0-9-1
 * AMQP 1.0
 * [RabbitMQ Stream Protocol](https://www.rabbitmq.com/docs/streams)
 * MQTT 3.1, 3.1.1, and 5.0
 * STOMP 1.0 through 1.2
 * [MQTT over WebSockets](https://www.rabbitmq.com/docs/web-mqtt)
 * [STOMP over WebSockets](https://www.rabbitmq.com/docs/web-stomp)


## Installation

 * [Currently supported](https://www.rabbitmq.com/release-information) released series
 * [Installation guides](https://www.rabbitmq.com/docs/download) for various platforms
 * [Kubernetes Cluster Operator](https://www.rabbitmq.com/kubernetes/operator/operator-overview)
 * [Changelog](https://www.rabbitmq.com/release-information)
 * [Releases](https://github.com/rabbitmq/rabbitmq-server/releases) on GitHub
 * [Community Support Eligibility Policy](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md)
 * [Supported Erlang versions](https://www.rabbitmq.com/docs/which-erlang)


## Tutorials and Documentation

 * [RabbitMQ tutorials](https://www.rabbitmq.com/tutorials) and their [executable versions on GitHub](https://github.com/rabbitmq/rabbitmq-tutorials)
 * [Documentation guides](https://rabbitmq.com/docs/)
 * [RabbitMQ blog](https://blog.rabbitmq.com/)

Some key doc guides include

 * [CLI tools guide](https://www.rabbitmq.com/docs/cli)
 * [Clustering](https://www.rabbitmq.com/docs/clustering) and [Cluster Formation](https://www.rabbitmq.com/docs/cluster-formation)
 * [Configuration guide](https://www.rabbitmq.com/docs/configure)
 * [Client libraries and tools](https://www.rabbitmq.com/client-libraries/devtools)
 * [Monitoring](https://www.rabbitmq.com/docs/monitoring) and [Prometheus/Grafana](https://www.rabbitmq.com/docs/prometheus)
 * [Upgrading](https://www.rabbitmq.com/docs/upgrade)
 * [Kubernetes Cluster Operator](https://www.rabbitmq.com/kubernetes/operator/operator-overview)
 * [Production checklist](https://www.rabbitmq.com/docs/production-checklist)
 * [Quorum queues](https://www.rabbitmq.com/docs/quorum-queues): a replicated, data safety- and consistency-oriented queue type
 * [Streams](https://www.rabbitmq.com/docs/streams): a persistent and replicated append-only log with non-destructive consumer semantics
 * [Runtime Parameters and Policies](https://www.rabbitmq.com/docs/parameters)
 * [Runnable tutorials](https://github.com/rabbitmq/rabbitmq-tutorials/)

RabbitMQ documentation is also [developed on GitHub](https://github.com/rabbitmq/rabbitmq-website/).

## Commercial Features and Support

 * [Commercial editions of RabbitMQ](https://tanzu.vmware.com/rabbitmq)
 * [Commercial edition for Kubernetes](https://docs.vmware.com/en/VMware-RabbitMQ-for-Kubernetes/1/rmq/installation.html)
 * [Commercial support](https://tanzu.vmware.com/rabbitmq/oss) from [Broadcom](https://vmware.com) for open source RabbitMQ

## Getting Help from the Community

Please read the [Community Support Eligibility Policy](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) document
first.

The recommended community forums are

 * [GitHub Discussions](https://github.com/rabbitmq/rabbitmq-server/discussions/)
 * [Community Discord server](https://rabbitmq.com/discord/)
 * `#rabbitmq` on [Libera Chat](https://libera.chat/)


## Contributing

See [CONTRIBUTING.md](./CONTRIBUTING.md) and our [development process overview](https://www.rabbitmq.com/github).

Questions about contributing, internals and so on are very welcome in [GitHub Discussions](https://github.com/rabbitmq/rabbitmq-server/discussions)
or [community Discord server](https://www.rabbitmq.com/discord/) in the `core-and-plugin-dev` channel.


## Licensing

RabbitMQ server is [licensed under the MPL 2.0](LICENSE-MPL-RabbitMQ).

[Community Support Eligibility Policy](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md)
document explains the open source RabbitMQ support policy adopted by the RabbitMQ Core Team.


## Building From Source and Packaging

 * [Contributor resources](https://github.com/rabbitmq/contribute)
 * [Building RabbitMQ from Source](https://www.rabbitmq.com/docs/build-server)
 * [Building RabbitMQ Distribution Packages](https://www.rabbitmq.com/docs/build-server)


## Copyright

(c) 2007-2024 Broadcom. All Rights Reserved. The term “Broadcom” refers to Broadcom Inc. and/or its subsidiaries.
