; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=arm -passes=typepromotion,verify  -S %s -o - | FileCheck %s

define i16 @dsp_trunc(i32 %arg0, i32 %arg1, ptr %gep0, ptr %gep1) {
; CHECK-LABEL: @dsp_trunc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD0:%.*]] = add i32 [[ARG0:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    [[CONV0:%.*]] = trunc i32 [[ADD0]] to i16
; CHECK-NEXT:    [[SUB0:%.*]] = sub i16 0, [[CONV0]]
; CHECK-NEXT:    [[LOAD0:%.*]] = load i16, ptr [[GEP0:%.*]], align 2
; CHECK-NEXT:    [[LOAD1:%.*]] = load i16, ptr [[GEP1:%.*]], align 2
; CHECK-NEXT:    [[SUB1:%.*]] = sub i16 [[LOAD0]], [[SUB0]]
; CHECK-NEXT:    [[ADD1:%.*]] = add i16 [[LOAD1]], [[SUB0]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[SUB1]], [[ADD1]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i16 [[ADD1]], i16 [[SUB1]]
; CHECK-NEXT:    ret i16 [[RES]]
;
entry:
  %add0 = add i32 %arg0, %arg1
  %conv0 = trunc i32 %add0 to i16
  %sub0 = sub i16 0, %conv0
  %load0 = load i16, ptr %gep0, align 2
  %load1 = load i16, ptr %gep1, align 2
  %sub1 = sub i16 %load0, %sub0
  %add1 = add i16 %load1, %sub0
  %cmp = icmp ult i16 %sub1, %add1
  %res = select i1 %cmp, i16 %add1, i16 %sub1
  ret i16 %res
}

define i8 @trunc_i16_i8(ptr %ptr, i16 zeroext %arg0, i8 zeroext %arg1) {
; CHECK-LABEL: @trunc_i16_i8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[ARG1:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr [[PTR:%.*]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = add i16 [[TMP1]], [[ARG0:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i16 [[TMP2]] to i8
; CHECK-NEXT:    [[TMP4:%.*]] = zext i8 [[TMP3]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ugt i32 [[TMP4]], [[TMP0]]
; CHECK-NEXT:    [[TMP6:%.*]] = select i1 [[TMP5]], i32 [[TMP4]], i32 [[TMP0]]
; CHECK-NEXT:    [[TMP7:%.*]] = trunc i32 [[TMP6]] to i8
; CHECK-NEXT:    ret i8 [[TMP7]]
;
entry:
  %0 = load i16, ptr %ptr
  %1 = add i16 %0, %arg0
  %2 = trunc i16 %1 to i8
  %3 = icmp ugt i8 %2, %arg1
  %4 = select i1 %3, i8 %2, i8 %arg1
  ret i8 %4
}

; The pass perform the transform.
define i8 @icmp_i32_zext(ptr %ptr) {
; CHECK-LABEL: @icmp_i32_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = sub nuw nsw i32 [[TMP1]], 1
; CHECK-NEXT:    [[CONV44:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    br label [[PREHEADER:%.*]]
; CHECK:       preheader:
; CHECK-NEXT:    br label [[BODY:%.*]]
; CHECK:       body:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP2]], [[PREHEADER]] ], [ [[TMP5:%.*]], [[IF_END:%.*]] ]
; CHECK-NEXT:    [[SI_0274:%.*]] = phi i32 [ [[CONV44]], [[PREHEADER]] ], [ [[INC:%.*]], [[IF_END]] ]
; CHECK-NEXT:    [[CMP52267:%.*]] = icmp eq i32 [[SI_0274]], [[TMP3]]
; CHECK-NEXT:    br i1 [[CMP52267]], label [[IF_END]], label [[EXIT:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[INC]] = add i32 [[SI_0274]], 1
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i32 [[INC]]
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[GEP1]], align 1
; CHECK-NEXT:    [[TMP5]] = zext i8 [[TMP4]] to i32
; CHECK-NEXT:    br label [[BODY]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP6:%.*]] = trunc i32 [[TMP3]] to i8
; CHECK-NEXT:    ret i8 [[TMP6]]
;
entry:
  %0 = load i8, ptr %ptr, align 1
  %1 = sub nuw nsw i8 %0, 1
  %conv44 = zext i8 %0 to i32
  br label %preheader

preheader:
  br label %body

body:
  %2 = phi i8 [ %1, %preheader ], [ %3, %if.end ]
  %si.0274 = phi i32 [ %conv44, %preheader ], [ %inc, %if.end ]
  %conv51266 = zext i8 %2 to i32
  %cmp52267 = icmp eq i32 %si.0274, %conv51266
  br i1 %cmp52267, label %if.end, label %exit

if.end:
  %inc = add i32 %si.0274, 1
  %gep1 = getelementptr inbounds i8, ptr %ptr, i32 %inc
  %3 = load i8, ptr %gep1, align 1
  br label %body

exit:
  ret i8 %2
}

; Won't don't handle sext
define i32 @icmp_sext_zext_store_i8_i16() {
; CHECK-LABEL: @icmp_sext_zext_store_i8_i16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr getelementptr inbounds ([16 x i8], ptr @d_uch, i32 0, i32 2), align 1
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TMP0]] to i16
; CHECK-NEXT:    store i16 [[CONV]], ptr @sh1, align 2
; CHECK-NEXT:    [[CONV1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr getelementptr inbounds ([16 x i16], ptr @d_sh, i32 0, i32 2), align 2
; CHECK-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP1]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[CONV1]], [[CONV2]]
; CHECK-NEXT:    [[CONV3:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[CONV3]]
;
entry:
  %0 = load i8, ptr getelementptr inbounds ([16 x i8], ptr @d_uch, i32 0, i32 2), align 1
  %conv = zext i8 %0 to i16
  store i16 %conv, ptr @sh1, align 2
  %conv1 = zext i8 %0 to i32
  %1 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @d_sh, i32 0, i32 2), align 2
  %conv2 = sext i16 %1 to i32
  %cmp = icmp eq i32 %conv1, %conv2
  %conv3 = zext i1 %cmp to i32
  ret i32 %conv3
}

define i1 @or_icmp_ugt(i32 %arg, ptr %ptr) {
; CHECK-LABEL: @or_icmp_ugt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    [[MUL:%.*]] = shl nuw nsw i32 [[TMP2]], 1
; CHECK-NEXT:    [[ADD0:%.*]] = add nuw nsw i32 [[MUL]], 6
; CHECK-NEXT:    [[CMP0:%.*]] = icmp ne i32 [[ARG:%.*]], [[ADD0]]
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[TMP1]], -1
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 [[ADD1]], 3
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[CMP0]], [[CMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
entry:
  %0 = load i8, ptr %ptr
  %1 = zext i8 %0 to i32
  %mul = shl nuw nsw i32 %1, 1
  %add0 = add nuw nsw i32 %mul, 6
  %cmp0 = icmp ne i32 %arg, %add0
  %add1 = add i8 %0, -1
  %cmp1 = icmp ugt i8 %add1, 3
  %or = or i1 %cmp0, %cmp1
  ret i1 %or
}

; We currently only handle truncs as sinks, so a uxt will still be needed for
; the icmp ugt instruction.
define void @urem_trunc_icmps(ptr %in, ptr %g, ptr %k) {
; CHECK-LABEL: @urem_trunc_icmps(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = load ptr, ptr [[IN:%.*]], align 4
; CHECK-NEXT:    [[LD:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    [[CMP_I:%.*]] = icmp eq i16 [[LD]], 0
; CHECK-NEXT:    br i1 [[CMP_I]], label [[EXIT:%.*]], label [[COND_FALSE_I:%.*]]
; CHECK:       cond.false.i:
; CHECK-NEXT:    [[REM:%.*]] = urem i16 5, [[LD]]
; CHECK-NEXT:    [[EXTRACT_T:%.*]] = trunc i16 [[REM]] to i8
; CHECK-NEXT:    br label [[BODY:%.*]]
; CHECK:       body:
; CHECK-NEXT:    [[COND_IN_I_OFF0:%.*]] = phi i8 [ [[EXTRACT_T]], [[COND_FALSE_I]] ], [ [[ADD:%.*]], [[FOR_INC:%.*]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[COND_IN_I_OFF0]], 7
; CHECK-NEXT:    [[CONV5:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    store i32 [[CONV5]], ptr [[G:%.*]], align 4
; CHECK-NEXT:    [[DOTPR:%.*]] = load i32, ptr [[K:%.*]], align 4
; CHECK-NEXT:    [[TOBOOL13150:%.*]] = icmp eq i32 [[DOTPR]], 0
; CHECK-NEXT:    br i1 [[TOBOOL13150]], label [[FOR_INC]], label [[EXIT]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[ADD]] = add nuw i8 [[COND_IN_I_OFF0]], 1
; CHECK-NEXT:    br label [[BODY]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %ptr = load ptr, ptr %in, align 4
  %ld = load i16, ptr %ptr, align 2
  %cmp.i = icmp eq i16 %ld, 0
  br i1 %cmp.i, label %exit, label %cond.false.i

cond.false.i:
  %rem = urem i16 5, %ld
  %extract.t = trunc i16 %rem to i8
  br label %body

body:
  %cond.in.i.off0 = phi i8 [ %extract.t, %cond.false.i ], [ %add, %for.inc ]
  %cmp = icmp ugt i8 %cond.in.i.off0, 7
  %conv5 = zext i1 %cmp to i32
  store i32 %conv5, ptr %g, align 4
  %.pr = load i32, ptr %k, align 4
  %tobool13150 = icmp eq i32 %.pr, 0
  br i1 %tobool13150, label %for.inc, label %exit

for.inc:
  %add = add nuw i8 %cond.in.i.off0, 1
  br label %body

exit:
  ret void
}

; Check that %exp requires uxth in all cases, and will also be required to
; promote %1 for the call - unless we can generate a uadd16.
define i32 @zext_load_sink_call(ptr %ptr, i16 %exp) {
; CHECK-LABEL: @zext_load_sink_call(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = add i16 [[EXP:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i16 [[TMP0]], [[EXP]]
; CHECK-NEXT:    br i1 [[CMP]], label [[EXIT:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[CONV0:%.*]] = zext i16 [[TMP0]] to i32
; CHECK-NEXT:    [[CONV1:%.*]] = zext i16 [[TMP1]] to i32
; CHECK-NEXT:    [[CALL:%.*]] = tail call arm_aapcs_vfpcc i32 @dummy(i32 [[CONV0]], i32 [[CONV1]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[EXITVAL:%.*]] = phi i32 [ [[CALL]], [[IF_THEN]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[EXITVAL]]
;
entry:
  %0 = load i16, ptr %ptr, align 4
  %1 = add i16 %exp, 3
  %cmp = icmp eq i16 %0, %exp
  br i1 %cmp, label %exit, label %if.then

if.then:
  %conv0 = zext i16 %0 to i32
  %conv1 = zext i16 %1 to i32
  %call = tail call arm_aapcs_vfpcc i32 @dummy(i32 %conv0, i32 %conv1)
  br label %exit

exit:
  %exitval = phi i32 [ %call, %if.then ], [ 0, %entry  ]
  ret i32 %exitval
}

define i16 @bitcast_i16(i16 zeroext %arg0, i16 zeroext %arg1) {
; CHECK-LABEL: @bitcast_i16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[ARG0:%.*]] to i32
; CHECK-NEXT:    [[CAST:%.*]] = bitcast i32 12345 to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[TMP0]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[ADD]], [[CAST]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i16 [[ARG1:%.*]], i16 32657
; CHECK-NEXT:    ret i16 [[RES]]
;
entry:
  %cast = bitcast i16 12345 to i16
  %add = add nuw i16 %arg0, 1
  %cmp = icmp ule i16 %add, %cast
  %res = select i1 %cmp, i16 %arg1, i16 32657
  ret i16 %res
}

define i8 @bitcast_i8(i8 zeroext %arg0, i8 zeroext %arg1) {
; CHECK-LABEL: @bitcast_i8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[ARG0:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[ARG1:%.*]] to i32
; CHECK-NEXT:    [[CAST:%.*]] = bitcast i8 127 to i8
; CHECK-NEXT:    [[MUL:%.*]] = shl nuw i32 [[TMP0]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i32 [[MUL]], [[TMP1]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i8 [[CAST]], i8 -128
; CHECK-NEXT:    ret i8 [[RES]]
;
entry:
  %cast = bitcast i8 127 to i8
  %mul = shl nuw i8 %arg0, 1
  %cmp = icmp uge i8 %mul, %arg1
  %res = select i1 %cmp, i8 %cast, i8 128
  ret i8 %res
}

define i16 @bitcast_i16_minus(i16 zeroext %arg0, i16 zeroext %arg1) {
; CHECK-LABEL: @bitcast_i16_minus(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[ARG0:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[ARG1:%.*]] to i32
; CHECK-NEXT:    [[CAST:%.*]] = bitcast i16 -12345 to i16
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[TMP0]], 7
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[XOR]], [[TMP1]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i16 [[CAST]], i16 32657
; CHECK-NEXT:    ret i16 [[RES]]
;
entry:
  %cast = bitcast i16 -12345 to i16
  %xor = xor i16 %arg0, 7
  %cmp = icmp eq i16 %xor, %arg1
  %res = select i1 %cmp, i16 %cast, i16 32657
  ret i16 %res
}

define i8 @bitcast_i8_minus(i8 zeroext %arg0, i8 zeroext %arg1) {
; CHECK-LABEL: @bitcast_i8_minus(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[ARG0:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[ARG1:%.*]] to i32
; CHECK-NEXT:    [[CAST:%.*]] = bitcast i8 -127 to i8
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[TMP0]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[AND]], [[TMP1]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i8 [[CAST]], i8 -128
; CHECK-NEXT:    ret i8 [[RES]]
;
entry:
  %cast = bitcast i8 -127 to i8
  %and = and i8 %arg0, 3
  %cmp = icmp ne i8 %and, %arg1
  %res = select i1 %cmp, i8 %cast, i8 128
  ret i8 %res
}

declare i32 @dummy(i32, i32)

@d_uch = hidden local_unnamed_addr global [16 x i8] zeroinitializer, align 1
@sh1 = hidden local_unnamed_addr global i16 0, align 2
@d_sh = hidden local_unnamed_addr global [16 x i16] zeroinitializer, align 2

define ptr @two_stage_zext_trunc_mix(ptr %this, i32 %__pos1, i32 %__n1, ptr %__str, i32 %__pos2, i32 %__n2) {
; CHECK-LABEL: @two_stage_zext_trunc_mix(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[__STR:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 1
; CHECK-NEXT:    [[TOBOOL_I_I_I_I:%.*]] = icmp eq i32 [[TMP2]], 0
; CHECK-NEXT:    [[__SIZE__I5_I_I:%.*]] = getelementptr inbounds ptr, ptr [[__STR]], i32 [[__N1:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[__SIZE__I5_I_I]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 1
; CHECK-NEXT:    [[COND_I_I:%.*]] = select i1 [[TOBOOL_I_I_I_I]], i32 [[TMP4]], i32 [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr [[THIS:%.*]], align 4
; CHECK-NEXT:    [[TMP6:%.*]] = zext i8 [[TMP5]] to i32
; CHECK-NEXT:    [[TMP7:%.*]] = and i32 [[TMP6]], 1
; CHECK-NEXT:    [[TOBOOL_I_I_I_I_I:%.*]] = icmp eq i32 [[TMP7]], 0
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i8, ptr [[__STR]], i32 [[__POS1:%.*]]
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i8, ptr [[__STR]], i32 [[__POS2:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[TOBOOL_I_I_I_I_I]], ptr [[TMP8]], ptr [[TMP9]]
; CHECK-NEXT:    ret ptr [[RES]]
;
entry:
  %0 = load i8, ptr %__str, align 4
  %1 = and i8 %0, 1
  %tobool.i.i.i.i = icmp eq i8 %1, 0
  %__size_.i5.i.i = getelementptr inbounds ptr, ptr %__str, i32 %__n1
  %2 = load i32, ptr %__size_.i5.i.i, align 4
  %3 = lshr i8 %0, 1
  %4 = zext i8 %3 to i32
  %cond.i.i = select i1 %tobool.i.i.i.i, i32 %4, i32 %2
  %5 = load i8, ptr %this, align 4
  %6 = and i8 %5, 1
  %tobool.i.i.i.i.i = icmp eq i8 %6, 0
  %7 = getelementptr inbounds i8, ptr %__str, i32 %__pos1
  %8 = getelementptr inbounds i8, ptr %__str, i32 %__pos2
  %res = select i1 %tobool.i.i.i.i.i,  ptr %7, ptr %8
  ret ptr %res
}

define i8 @search_through_zext_1(i8 zeroext %a, i8 zeroext %b, i16 zeroext %c) {
; CHECK-LABEL: @search_through_zext_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[B:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = zext i16 [[C:%.*]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[TMP1]], [[TMP0]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], [[TMP2]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i32 [[SUB]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP2]], i32 [[TMP1]], i32 [[TMP0]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[RETVAL]] to i8
; CHECK-NEXT:    ret i8 [[TMP3]]
;
entry:
  %add = add nuw i8 %a, %b
  %conv = zext i8 %add to i16
  %cmp = icmp ult i16 %conv, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %sub = sub nuw i8 %b, %a
  %conv2 = zext i8 %sub to i16
  %cmp2 = icmp ugt i16 %conv2, %c
  %res = select i1 %cmp2, i8 %a, i8 %b
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %res, %if.then ]
  ret i8 %retval
}

; TODO: We should be able to remove the uxtb here. The transform fails because
; the icmp ugt uses an i32, which is too large... but this doesn't matter
; because it won't be writing a large value to a register as a result.
define i8 @search_through_zext_2(i8 zeroext %a, i8 zeroext %b, i16 zeroext %c, i32 %d) {
; CHECK-LABEL: @search_through_zext_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[ADD]] to i16
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[CONV]], [[C:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i8 [[B]], [[A]]
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[SUB]] to i32
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i32 [[CONV2]], [[D:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP2]], i8 [[A]], i8 [[B]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i8 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    ret i8 [[RETVAL]]
;
entry:
  %add = add nuw i8 %a, %b
  %conv = zext i8 %add to i16
  %cmp = icmp ult i16 %conv, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %sub = sub nuw i8 %b, %a
  %conv2 = zext i8 %sub to i32
  %cmp2 = icmp ugt i32 %conv2, %d
  %res = select i1 %cmp2, i8 %a, i8 %b
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %res, %if.then ]
  ret i8 %retval
}

; TODO: We should be able to remove the uxtb here as all the calculations are
; performed on i8s. The promotion of i8 to i16 and then the later truncation
; results in the uxtb.
define i8 @search_through_zext_3(i8 zeroext %a, i8 zeroext %b, i16 zeroext %c, i32 %d) {
; CHECK-LABEL: @search_through_zext_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[ADD]] to i16
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[CONV]], [[C:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i16 [[CONV]] to i8
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i8 [[B]], [[TRUNC]]
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[SUB]] to i32
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i32 [[CONV2]], [[D:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP2]], i8 [[A]], i8 [[B]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i8 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    ret i8 [[RETVAL]]
;
entry:
  %add = add nuw i8 %a, %b
  %conv = zext i8 %add to i16
  %cmp = icmp ult i16 %conv, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %trunc = trunc i16 %conv to i8
  %sub = sub nuw i8 %b, %trunc
  %conv2 = zext i8 %sub to i32
  %cmp2 = icmp ugt i32 %conv2, %d
  %res = select i1 %cmp2, i8 %a, i8 %b
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %res, %if.then ]
  ret i8 %retval
}

define i8 @search_through_zext_4(i8 zeroext %a, i8 zeroext %b, i16 zeroext %c, i32 %d) {
; CHECK-LABEL: @search_through_zext_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV_0:%.*]] = zext i8 [[A:%.*]] to i16
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i16 [[CONV_0]], [[C:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[ADD]], [[C]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i16 [[ADD]] to i8
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i8 [[B:%.*]], [[TRUNC]]
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[SUB]] to i32
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i32 [[CONV2]], [[D:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP2]], i8 [[A]], i8 [[B]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i8 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    ret i8 [[RETVAL]]
;
entry:
  %conv.0 = zext i8 %a to i16
  %add = add nuw i16 %conv.0, %c
  %cmp = icmp ult i16 %add, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %trunc = trunc i16 %add to i8
  %sub = sub nuw i8 %b, %trunc
  %conv2 = zext i8 %sub to i32
  %cmp2 = icmp ugt i32 %conv2, %d
  %res = select i1 %cmp2, i8 %a, i8 %b
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %res, %if.then ]
  ret i8 %retval
}

; TODO: We should be able to remove the uxt that gets introduced for %conv2
define i8 @search_through_zext_cmp(i8 zeroext %a, i8 zeroext %b, i16 zeroext %c) {
; CHECK-LABEL: @search_through_zext_cmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i16
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i16 [[CONV]], [[C:%.*]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i8 [[B]], [[A]]
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[SUB]] to i16
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ugt i16 [[CONV2]], [[C]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP3]], i8 [[A]], i8 [[B]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i8 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    ret i8 [[RETVAL]]
;
entry:
  %cmp = icmp ne i8 %a, %b
  %conv = zext i1 %cmp to i16
  %cmp1 = icmp ult i16 %conv, %c
  br i1 %cmp1, label %if.then, label %if.end

if.then:
  %sub = sub nuw i8 %b, %a
  %conv2 = zext i8 %sub to i16
  %cmp3 = icmp ugt i16 %conv2, %c
  %res = select i1 %cmp3, i8 %a, i8 %b
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %res, %if.then ]
  ret i8 %retval
}

define i8 @search_through_zext_load(ptr %a, i8 zeroext %b, i16 zeroext %c) {
; CHECK-LABEL: @search_through_zext_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[B:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[C:%.*]] to i32
; CHECK-NEXT:    [[LOAD:%.*]] = load i8, ptr [[A:%.*]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[LOAD]] to i32
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i32 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i32 [[TMP0]], [[TMP2]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ugt i32 [[SUB]], [[TMP1]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP3]], i32 [[TMP2]], i32 [[TMP0]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[RETVAL]] to i8
; CHECK-NEXT:    ret i8 [[TMP3]]
;
entry:
  %load = load i8, ptr %a
  %conv = zext i8 %load to i16
  %cmp1 = icmp ult i16 %conv, %c
  br i1 %cmp1, label %if.then, label %if.end

if.then:
  %sub = sub nuw i8 %b, %load
  %conv2 = zext i8 %sub to i16
  %cmp3 = icmp ugt i16 %conv2, %c
  %res = select i1 %cmp3, i8 %load, i8 %b
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %res, %if.then ]
  ret i8 %retval
}

define i16 @trunc_sink_less_than_cmp(i16 zeroext %a, i16 zeroext %b, i16 zeroext %c, i8 zeroext %d) {
; CHECK-LABEL: @trunc_sink_less_than_cmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i16 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[SUB]], [[C:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i16 [[SUB]] to i8
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[D:%.*]], 1
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i8 [[TRUNC]], [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP2]], i16 [[A]], i16 [[B]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i16 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    ret i16 [[RETVAL]]
;
entry:
  %sub = sub nuw i16 %b, %a
  %cmp = icmp ult i16 %sub, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %trunc = trunc i16 %sub to i8
  %add = add nuw i8 %d, 1
  %cmp2 = icmp ugt i8 %trunc, %add
  %res = select i1 %cmp2, i16 %a, i16 %b
  br label %if.end

if.end:
  %retval = phi i16 [ 0, %entry ], [ %res, %if.then ]
  ret i16 %retval
}

; TODO: We should be able to remove the uxth introduced to handle %sub
define i16 @trunc_sink_less_than_arith(i16 zeroext %a, i16 zeroext %b, i16 zeroext %c, i8 zeroext %d, i8 zeroext %e) {
; CHECK-LABEL: @trunc_sink_less_than_arith(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i16 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[SUB]], [[C:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i16 [[SUB]] to i8
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[D:%.*]], [[TRUNC]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i8 [[E:%.*]], [[ADD]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP2]], i16 [[A]], i16 [[B]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i16 [ 0, [[ENTRY:%.*]] ], [ [[RES]], [[IF_THEN]] ]
; CHECK-NEXT:    ret i16 [[RETVAL]]
;
entry:
  %sub = sub nuw i16 %b, %a
  %cmp = icmp ult i16 %sub, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %trunc = trunc i16 %sub to i8
  %add = add nuw i8 %d, %trunc
  %cmp2 = icmp ugt i8 %e, %add
  %res = select i1 %cmp2, i16 %a, i16 %b
  br label %if.end

if.end:
  %retval = phi i16 [ 0, %entry ], [ %res, %if.then ]
  ret i16 %retval
}

define i16 @trunc_sink_less_than_store(i16 zeroext %a, i16 zeroext %b, i16 zeroext %c, i8 zeroext %d, ptr %e) {
; CHECK-LABEL: @trunc_sink_less_than_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[B:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[D:%.*]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i16 [[C:%.*]] to i32
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[SUB]], [[TMP3]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[SUB]], 255
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[ADD]] to i8
; CHECK-NEXT:    store i8 [[TMP5]], ptr [[E:%.*]], align 1
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[SUB]], [[IF_THEN]] ]
; CHECK-NEXT:    [[TMP6:%.*]] = trunc i32 [[RETVAL]] to i16
; CHECK-NEXT:    ret i16 [[TMP6]]
;
entry:
  %sub = sub nuw i16 %b, %a
  %cmp = icmp ult i16 %sub, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %trunc = trunc i16 %sub to i8
  %add = add nuw i8 %d, %trunc
  store i8 %add, ptr %e
  br label %if.end

if.end:
  %retval = phi i16 [ 0, %entry ], [ %sub, %if.then ]
  ret i16 %retval
}

define i8 @trunc_sink_less_than_ret(i16 zeroext %a, i16 zeroext %b, i16 zeroext %c, i8 zeroext %d, i8 zeroext %e) {
; CHECK-LABEL: @trunc_sink_less_than_ret(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[B:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[D:%.*]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i16 [[C:%.*]] to i32
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[SUB]], [[TMP3]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[SUB]], 255
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[TMP2]], [[TMP4]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[ADD]], [[IF_THEN]] ]
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[RETVAL]] to i8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
entry:
  %sub = sub nuw i16 %b, %a
  %cmp = icmp ult i16 %sub, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %trunc = trunc i16 %sub to i8
  %add = add nuw i8 %d, %trunc
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %add, %if.then ]
  ret i8 %retval
}

define zeroext i8 @trunc_sink_less_than_zext_ret(i16 zeroext %a, i16 zeroext %b, i16 zeroext %c, i8 zeroext %d, i8 zeroext %e) {
; CHECK-LABEL: @trunc_sink_less_than_zext_ret(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[B:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = zext i8 [[D:%.*]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i16 [[C:%.*]] to i32
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[SUB]], [[TMP3]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[SUB]], 255
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[TMP2]], [[TMP4]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[ADD]], [[IF_THEN]] ]
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[RETVAL]] to i8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
entry:
  %sub = sub nuw i16 %b, %a
  %cmp = icmp ult i16 %sub, %c
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %trunc = trunc i16 %sub to i8
  %add = add nuw i8 %d, %trunc
  br label %if.end

if.end:
  %retval = phi i8 [ 0, %entry ], [ %add, %if.then ]
  ret i8 %retval
}

define i32 @bitcast_i1(i16 zeroext %a, i32 %b, i32 %c) {
; CHECK-LABEL: @bitcast_i1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i1 true to i1
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i16 [[A:%.*]] to i1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i1 [[TMP1]], [[TMP0]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[TMP0]] to i16
; CHECK-NEXT:    [[CONV1:%.*]] = zext i1 [[TMP1]] to i16
; CHECK-NEXT:    [[CMP1:%.*]] = icmp uge i16 [[CONV]], [[CONV1]]
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP1]], i32 [[B:%.*]], i32 [[C:%.*]]
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ [[SELECT]], [[IF_THEN]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %0 = bitcast i1 1 to i1
  %1 = trunc i16 %a to i1
  %cmp = icmp eq i1 %1, %0
  br i1 %cmp, label %if.then, label %exit

if.then:
  %conv = zext i1 %0 to i16
  %conv1 = zext i1 %1 to i16
  %cmp1 = icmp uge i16 %conv, %conv1
  %select = select i1 %cmp1, i32 %b, i32 %c
  br label %exit

exit:
  %retval = phi i32 [ %select, %if.then ], [ 0, %entry ]
  ret i32 %retval
}

define void @search_back_through_trunc(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) {
; CHECK-LABEL: @search_back_through_trunc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl nuw i32 [[TMP1]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr [[B:%.*]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = zext i8 [[TMP2]] to i32
; CHECK-NEXT:    [[OR109:%.*]] = or i32 [[SHL]], [[TMP3]]
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[C:%.*]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = zext i8 [[TMP4]] to i32
; CHECK-NEXT:    [[SHL120:%.*]] = shl nuw i32 [[TMP5]], 8
; CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[D:%.*]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = zext i8 [[TMP6]] to i32
; CHECK-NEXT:    [[OR123:%.*]] = or i32 [[SHL120]], [[TMP7]]
; CHECK-NEXT:    [[CMP133:%.*]] = icmp eq i32 [[OR109]], [[OR123]]
; CHECK-NEXT:    br i1 [[CMP133]], label [[IF_END183:%.*]], label [[IF_ELSE136:%.*]]
; CHECK:       if.else136:
; CHECK-NEXT:    [[TMP8:%.*]] = load i16, ptr [[E:%.*]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = zext i16 [[TMP8]] to i32
; CHECK-NEXT:    [[TMP10:%.*]] = and i32 [[TMP9]], 255
; CHECK-NEXT:    [[EXTRACT856:%.*]] = lshr i32 [[TMP9]], 8
; CHECK-NEXT:    [[TMP11:%.*]] = and i32 [[EXTRACT856]], 255
; CHECK-NEXT:    br label [[IF_END183]]
; CHECK:       if.end183:
; CHECK-NEXT:    [[W_0_OFF0:%.*]] = phi i32 [ [[TMP10]], [[IF_ELSE136]] ], [ [[TMP3]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[W_0_OFF8:%.*]] = phi i32 [ [[TMP11]], [[IF_ELSE136]] ], [ [[TMP5]], [[ENTRY]] ]
; CHECK-NEXT:    [[TMP12:%.*]] = trunc i32 [[W_0_OFF8]] to i8
; CHECK-NEXT:    store i8 [[TMP12]], ptr [[C]], align 1
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[W_0_OFF0]] to i8
; CHECK-NEXT:    store i8 [[TMP13]], ptr [[D]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %0 = load i8, ptr %a, align 1
  %conv106 = zext i8 %0 to i16
  %shl = shl nuw i16 %conv106, 8
  %1 = load i8, ptr %b, align 1
  %conv108 = zext i8 %1 to i16
  %or109 = or i16 %shl, %conv108
  %2 = load i8, ptr %c, align 1
  %conv119 = zext i8 %2 to i16
  %shl120 = shl nuw i16 %conv119, 8
  %3 = load i8, ptr %d, align 1
  %conv122 = zext i8 %3 to i16
  %or123 = or i16 %shl120, %conv122
  %cmp133 = icmp eq i16 %or109, %or123
  br i1 %cmp133, label %if.end183, label %if.else136

if.else136:
  %4 = load i16, ptr %e, align 2
  %extract.t854 = trunc i16 %4 to i8
  %extract856 = lshr i16 %4, 8
  %extract.t857 = trunc i16 %extract856 to i8
  br label %if.end183

if.end183:
  %w.0.off0 = phi i8 [ %extract.t854, %if.else136 ], [ %1, %entry ]
  %w.0.off8 = phi i8 [ %extract.t857, %if.else136 ], [ %2, %entry ]
  store i8 %w.0.off8, ptr %c, align 1
  store i8 %w.0.off0, ptr %d, align 1
  ret void
}

@c = common dso_local local_unnamed_addr global i16 0, align 2
@b = common dso_local local_unnamed_addr global i16 0, align 2
@f = common dso_local local_unnamed_addr global i32 0, align 4
@e = common dso_local local_unnamed_addr global i8 0, align 1
@a = common dso_local local_unnamed_addr global i8 0, align 1
@d = common dso_local local_unnamed_addr global i32 0, align 4

define void @and_trunc_two_zext() {
; CHECK-LABEL: @and_trunc_two_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr @c, align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr @b, align 2
; CHECK-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
; CHECK-NEXT:    store i32 [[CONV]], ptr @f, align 4
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i16 [[TMP1]] to i8
; CHECK-NEXT:    [[CONV1:%.*]] = and i8 [[TMP2]], 1
; CHECK-NEXT:    store i8 [[CONV1]], ptr @e, align 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr @a, align 1
; CHECK-NEXT:    [[NARROW:%.*]] = mul nuw i8 [[TMP3]], [[CONV1]]
; CHECK-NEXT:    [[MUL:%.*]] = zext i8 [[NARROW]] to i32
; CHECK-NEXT:    store i32 [[MUL]], ptr @d, align 4
; CHECK-NEXT:    [[TMP4:%.*]] = zext i8 [[NARROW]] to i16
; CHECK-NEXT:    [[CONV5:%.*]] = or i16 [[TMP0]], [[TMP4]]
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i16 [[CONV5]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %0 = load i16, ptr @c, align 2
  %1 = load i16, ptr @b, align 2
  %conv = sext i16 %1 to i32
  store i32 %conv, ptr @f, align 4
  %2 = trunc i16 %1 to i8
  %conv1 = and i8 %2, 1
  store i8 %conv1, ptr @e, align 1
  %3 = load i8, ptr @a, align 1
  %narrow = mul nuw i8 %3, %conv1
  %mul = zext i8 %narrow to i32
  store i32 %mul, ptr @d, align 4
  %4 = zext i8 %narrow to i16
  %conv5 = or i16 %0, %4
  %tobool = icmp eq i16 %conv5, 0
  br i1 %tobool, label %if.end, label %for.cond

for.cond:
  br label %for.cond

if.end:
  ret void
}

define void @zext_urem_trunc() {
; CHECK-LABEL: @zext_urem_trunc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr @c, align 2
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[TMP0]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr @e, align 1
; CHECK-NEXT:    [[TMP3:%.*]] = zext i8 [[TMP2]] to i32
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[REM7:%.*]] = urem i32 [[TMP3]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[REM7]], 255
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP4]], [[COND_FALSE]] ], [ [[TMP3]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[COND]] to i8
; CHECK-NEXT:    store i8 [[TMP5]], ptr @a, align 1
; CHECK-NEXT:    ret void
;
entry:
  %0 = load i16, ptr @c, align 2
  %cmp = icmp eq i16 %0, 0
  %1 = load i8, ptr @e, align 1
  br i1 %cmp, label %cond.end, label %cond.false

cond.false:
  %rem.lhs.trunc = zext i8 %1 to i16
  %rem7 = urem i16 %rem.lhs.trunc, %0
  %rem.zext = trunc i16 %rem7 to i8
  br label %cond.end

cond.end:
  %cond = phi i8 [ %rem.zext, %cond.false ], [ %1, %entry ]
  store i8 %cond, ptr @a, align 1
  ret void
}

define i1 @dont_replace_trunc_1(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e, ptr %f) {
; CHECK-LABEL: @dont_replace_trunc_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[C:%.*]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
; CHECK-NEXT:    store i32 [[CONV]], ptr [[F:%.*]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i16 [[TMP1]] to i8
; CHECK-NEXT:    [[CONV1:%.*]] = and i8 [[TMP2]], 1
; CHECK-NEXT:    store i8 [[CONV1]], ptr [[E:%.*]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr [[A:%.*]], align 1
; CHECK-NEXT:    [[NARROW:%.*]] = mul nuw i8 [[TMP3]], [[CONV1]]
; CHECK-NEXT:    [[MUL:%.*]] = zext i8 [[NARROW]] to i32
; CHECK-NEXT:    store i32 [[MUL]], ptr [[D:%.*]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = zext i8 [[NARROW]] to i16
; CHECK-NEXT:    [[CONV5:%.*]] = or i16 [[TMP0]], [[TMP4]]
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i16 [[CONV5]], 0
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
entry:
  %0 = load i16, ptr %c, align 2
  %1 = load i16, ptr %b, align 2
  %conv = sext i16 %1 to i32
  store i32 %conv, ptr %f, align 4
  %2 = trunc i16 %1 to i8
  %conv1 = and i8 %2, 1
  store i8 %conv1, ptr %e, align 1
  %3 = load i8, ptr %a, align 1
  %narrow = mul nuw i8 %3, %conv1
  %mul = zext i8 %narrow to i32
  store i32 %mul, ptr %d, align 4
  %4 = zext i8 %narrow to i16
  %conv5 = or i16 %0, %4
  %tobool = icmp eq i16 %conv5, 0
  ret i1 %tobool
}

define i32 @dont_return_inserted_trunc(ptr %a, ptr %b) {
; CHECK-LABEL: @dont_return_inserted_trunc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[TMP0]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP1]], 8
; CHECK-NEXT:    [[NARROW:%.*]] = select i1 [[CMP]], i32 [[TMP1]], i32 0
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[NARROW]], 255
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr [[B:%.*]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = zext i8 [[TMP3]] to i32
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[TMP4]], [[TMP2]]
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[OR]] to i8
; CHECK-NEXT:    store i8 [[TMP5]], ptr [[B]], align 1
; CHECK-NEXT:    ret i32 [[OR]]
;
entry:
  %0 = load i16, ptr %a, align 2
  %cmp = icmp ugt i16 %0, 8
  %narrow = select i1 %cmp, i16 %0, i16 0
  %cond = trunc i16 %narrow to i8
  %1 = load i8, ptr %b, align 1
  %or = or i8 %1, %cond
  store i8 %or, ptr %b, align 1
  %conv5 = zext i8 %or to i32
  ret i32 %conv5
}

define i32 @replace_trunk_with_mask(ptr %a) {
; CHECK-LABEL: @replace_trunk_with_mask(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = zext i16 [[TMP0]] to i32
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP2:%.*]] = urem i32 535, [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = and i32 [[TMP2]], 255
; CHECK-NEXT:    [[TMP4:%.*]] = udiv i32 [[TMP3]], 3
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP4]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %0 = load i16, ptr %a
  %cmp = icmp eq i16 %0, 0
  br i1 %cmp, label %cond.end, label %cond.false

cond.false:
  %1 = urem i16 535, %0
  %.lhs.trunc = trunc i16 %1 to i8
  %2 = udiv i8 %.lhs.trunc, 3
  %phitmp = zext i8 %2 to i32
  br label %cond.end

cond.end:
  %cond = phi i32 [ %phitmp, %cond.false ], [ 0, %entry ]
  ret i32 %cond
}

define float @test_i8_sitofp(ptr %ptr, i8 %arg) {
; CHECK-LABEL: @test_i8_sitofp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP0]], [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[EXIT:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[CONV:%.*]] = sitofp i8 [[ARG]] to float
; CHECK-NEXT:    [[DIV:%.*]] = fdiv float [[CONV]], 2.000000e+01
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi float [ 0.000000e+00, [[ENTRY:%.*]] ], [ [[DIV]], [[IF_END]] ]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %0 = load i8, ptr %ptr, align 1
  %cmp = icmp eq i8 %0, %arg
  br i1 %cmp, label %exit, label %if.end

if.end:
  %conv = sitofp i8 %arg to float
  %div = fdiv float %conv, 2.000000e+01
  br label %exit

exit:
  %res = phi float [ 0.0, %entry ], [ %div, %if.end ]
  ret float %res
}

define float @test_i16_sitofp(ptr %ptr, i16 %arg) {
; CHECK-LABEL: @test_i16_sitofp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i16 [[TMP0]], [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[EXIT:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[CONV:%.*]] = sitofp i16 [[ARG]] to float
; CHECK-NEXT:    [[DIV:%.*]] = fdiv float [[CONV]], 2.000000e+01
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi float [ 0.000000e+00, [[ENTRY:%.*]] ], [ [[DIV]], [[IF_END]] ]
; CHECK-NEXT:    ret float [[RES]]
;
entry:
  %0 = load i16, ptr %ptr, align 1
  %cmp = icmp eq i16 %0, %arg
  br i1 %cmp, label %exit, label %if.end

if.end:
  %conv = sitofp i16 %arg to float
  %div = fdiv float %conv, 2.000000e+01
  br label %exit

exit:
  %res = phi float [ 0.0, %entry ], [ %div, %if.end ]
  ret float %res
}

define i32 @bitcasted() {
; CHECK-LABEL: @bitcasted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[T157_PH:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[T145_OLD:%.*]], [[LATCH:%.*]] ]
; CHECK-NEXT:    [[EXT:%.*]] = zext i32 [[T157_PH]] to i64
; CHECK-NEXT:    br label [[LATCH]]
; CHECK:       latch:
; CHECK-NEXT:    [[T145_OLD]] = bitcast i32 8 to i32
; CHECK-NEXT:    [[T146_OLD:%.*]] = bitcast i32 [[T145_OLD]] to i32
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:
  %t157.ph = phi i32 [ 0, %entry ], [ %t145.old, %latch ]
  %ext = zext i32 %t157.ph to i64
  br label %latch

latch:
  %t145.old = bitcast i32 8 to i32
  %t146.old = bitcast i32 %t145.old to i32
  br label %loop
}
