; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; FMA
;

define <4 x half> @fma_v4f16(<4 x half> %op1, <4 x half> %op2, <4 x half> %op3) {
; CHECK-LABEL: fma_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %mul = fmul contract <4 x half> %op1, %op2
  %res = fadd contract <4 x half> %mul, %op3
  ret <4 x half> %res
}

define <8 x half> @fma_v8f16(<8 x half> %op1, <8 x half> %op2, <8 x half> %op3) {
; CHECK-LABEL: fma_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q2 killed $q2 def $z2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %mul = fmul contract <8 x half> %op1, %op2
  %res = fadd contract <8 x half> %mul, %op3
  ret <8 x half> %res
}

define void @fma_v16f16(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fma_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    ldp q4, q5, [x2]
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z4.h
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fmla z1.h, p0/m, z2.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %op3 = load <16 x half>, ptr %c
  %mul = fmul contract <16 x half> %op1, %op2
  %res = fadd contract <16 x half> %mul, %op3
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fma_v2f32(<2 x float> %op1, <2 x float> %op2, <2 x float> %op3) {
; CHECK-LABEL: fma_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %mul = fmul contract <2 x float> %op1, %op2
  %res = fadd contract <2 x float> %mul, %op3
  ret <2 x float> %res
}

define <4 x float> @fma_v4f32(<4 x float> %op1, <4 x float> %op2, <4 x float> %op3) {
; CHECK-LABEL: fma_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q2 killed $q2 def $z2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %mul = fmul contract <4 x float> %op1, %op2
  %res = fadd contract <4 x float> %mul, %op3
  ret <4 x float> %res
}

define void @fma_v8f32(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fma_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    ldp q4, q5, [x2]
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z4.s
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fmla z1.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %op3 = load <8 x float>, ptr %c
  %mul = fmul contract <8 x float> %op1, %op2
  %res = fadd contract <8 x float> %mul, %op3
  store <8 x float> %res, ptr %a
  ret void
}

define <1 x double> @fma_v1f64(<1 x double> %op1, <1 x double> %op2, <1 x double> %op3) {
; CHECK-LABEL: fma_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmadd d0, d0, d1, d2
; CHECK-NEXT:    ret
  %mul = fmul contract <1 x double> %op1, %op2
  %res = fadd contract <1 x double> %mul, %op3
  ret <1 x double> %res
}

define <2 x double> @fma_v2f64(<2 x double> %op1, <2 x double> %op2, <2 x double> %op3) {
; CHECK-LABEL: fma_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q2 killed $q2 def $z2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmad z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %mul = fmul contract <2 x double> %op1, %op2
  %res = fadd contract <2 x double> %mul, %op3
  ret <2 x double> %res
}

define void @fma_v4f64(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fma_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    ldp q4, q5, [x2]
; CHECK-NEXT:    fmad z0.d, p0/m, z1.d, z4.d
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fmla z1.d, p0/m, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %op3 = load <4 x double>, ptr %c
  %mul = fmul contract <4 x double> %op1, %op2
  %res = fadd contract <4 x double> %mul, %op3
  store <4 x double> %res, ptr %a
  ret void
}
