// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_room.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CreateRoomRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the room
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// number of seconds to keep the room open if no one joins
	EmptyTimeout uint32 `protobuf:"varint,2,opt,name=empty_timeout,json=emptyTimeout,proto3" json:"empty_timeout,omitempty"`
	// limit number of participants that can be in a room
	MaxParticipants uint32 `protobuf:"varint,3,opt,name=max_participants,json=maxParticipants,proto3" json:"max_participants,omitempty"`
	// override the node room is allocated to, for debugging
	NodeId string `protobuf:"bytes,4,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// metadata of room
	Metadata string `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// egress
	Egress *RoomEgress `protobuf:"bytes,6,opt,name=egress,proto3" json:"egress,omitempty"`
	// playout delay of subscriber
	MinPlayoutDelay uint32 `protobuf:"varint,7,opt,name=min_playout_delay,json=minPlayoutDelay,proto3" json:"min_playout_delay,omitempty"`
	MaxPlayoutDelay uint32 `protobuf:"varint,8,opt,name=max_playout_delay,json=maxPlayoutDelay,proto3" json:"max_playout_delay,omitempty"`
	// improves A/V sync when playout_delay set to a value larger than 200ms. It will disables transceiver re-use
	// so not recommended for rooms with frequent subscription changes
	SyncStreams bool `protobuf:"varint,9,opt,name=sync_streams,json=syncStreams,proto3" json:"sync_streams,omitempty"`
}

func (x *CreateRoomRequest) Reset() {
	*x = CreateRoomRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRoomRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRoomRequest) ProtoMessage() {}

func (x *CreateRoomRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRoomRequest.ProtoReflect.Descriptor instead.
func (*CreateRoomRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{0}
}

func (x *CreateRoomRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateRoomRequest) GetEmptyTimeout() uint32 {
	if x != nil {
		return x.EmptyTimeout
	}
	return 0
}

func (x *CreateRoomRequest) GetMaxParticipants() uint32 {
	if x != nil {
		return x.MaxParticipants
	}
	return 0
}

func (x *CreateRoomRequest) GetNodeId() string {
	if x != nil {
		return x.NodeId
	}
	return ""
}

func (x *CreateRoomRequest) GetMetadata() string {
	if x != nil {
		return x.Metadata
	}
	return ""
}

func (x *CreateRoomRequest) GetEgress() *RoomEgress {
	if x != nil {
		return x.Egress
	}
	return nil
}

func (x *CreateRoomRequest) GetMinPlayoutDelay() uint32 {
	if x != nil {
		return x.MinPlayoutDelay
	}
	return 0
}

func (x *CreateRoomRequest) GetMaxPlayoutDelay() uint32 {
	if x != nil {
		return x.MaxPlayoutDelay
	}
	return 0
}

func (x *CreateRoomRequest) GetSyncStreams() bool {
	if x != nil {
		return x.SyncStreams
	}
	return false
}

type RoomEgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Room        *RoomCompositeEgressRequest `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	Participant *AutoParticipantEgress      `protobuf:"bytes,3,opt,name=participant,proto3" json:"participant,omitempty"`
	Tracks      *AutoTrackEgress            `protobuf:"bytes,2,opt,name=tracks,proto3" json:"tracks,omitempty"`
}

func (x *RoomEgress) Reset() {
	*x = RoomEgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoomEgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoomEgress) ProtoMessage() {}

func (x *RoomEgress) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoomEgress.ProtoReflect.Descriptor instead.
func (*RoomEgress) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{1}
}

func (x *RoomEgress) GetRoom() *RoomCompositeEgressRequest {
	if x != nil {
		return x.Room
	}
	return nil
}

func (x *RoomEgress) GetParticipant() *AutoParticipantEgress {
	if x != nil {
		return x.Participant
	}
	return nil
}

func (x *RoomEgress) GetTracks() *AutoTrackEgress {
	if x != nil {
		return x.Tracks
	}
	return nil
}

type ListRoomsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// when set, will only return rooms with name match
	Names []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *ListRoomsRequest) Reset() {
	*x = ListRoomsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRoomsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRoomsRequest) ProtoMessage() {}

func (x *ListRoomsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRoomsRequest.ProtoReflect.Descriptor instead.
func (*ListRoomsRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{2}
}

func (x *ListRoomsRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

type ListRoomsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rooms []*Room `protobuf:"bytes,1,rep,name=rooms,proto3" json:"rooms,omitempty"`
}

func (x *ListRoomsResponse) Reset() {
	*x = ListRoomsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRoomsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRoomsResponse) ProtoMessage() {}

func (x *ListRoomsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRoomsResponse.ProtoReflect.Descriptor instead.
func (*ListRoomsResponse) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{3}
}

func (x *ListRoomsResponse) GetRooms() []*Room {
	if x != nil {
		return x.Rooms
	}
	return nil
}

type DeleteRoomRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the room
	Room string `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
}

func (x *DeleteRoomRequest) Reset() {
	*x = DeleteRoomRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRoomRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRoomRequest) ProtoMessage() {}

func (x *DeleteRoomRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRoomRequest.ProtoReflect.Descriptor instead.
func (*DeleteRoomRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteRoomRequest) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

type DeleteRoomResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteRoomResponse) Reset() {
	*x = DeleteRoomResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRoomResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRoomResponse) ProtoMessage() {}

func (x *DeleteRoomResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRoomResponse.ProtoReflect.Descriptor instead.
func (*DeleteRoomResponse) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{5}
}

type ListParticipantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the room
	Room string `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
}

func (x *ListParticipantsRequest) Reset() {
	*x = ListParticipantsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListParticipantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsRequest) ProtoMessage() {}

func (x *ListParticipantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsRequest.ProtoReflect.Descriptor instead.
func (*ListParticipantsRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{6}
}

func (x *ListParticipantsRequest) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

type ListParticipantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Participants []*ParticipantInfo `protobuf:"bytes,1,rep,name=participants,proto3" json:"participants,omitempty"`
}

func (x *ListParticipantsResponse) Reset() {
	*x = ListParticipantsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListParticipantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsResponse) ProtoMessage() {}

func (x *ListParticipantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsResponse.ProtoReflect.Descriptor instead.
func (*ListParticipantsResponse) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{7}
}

func (x *ListParticipantsResponse) GetParticipants() []*ParticipantInfo {
	if x != nil {
		return x.Participants
	}
	return nil
}

type RoomParticipantIdentity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the room
	Room string `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	// identity of the participant
	Identity string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *RoomParticipantIdentity) Reset() {
	*x = RoomParticipantIdentity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoomParticipantIdentity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoomParticipantIdentity) ProtoMessage() {}

func (x *RoomParticipantIdentity) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoomParticipantIdentity.ProtoReflect.Descriptor instead.
func (*RoomParticipantIdentity) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{8}
}

func (x *RoomParticipantIdentity) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

func (x *RoomParticipantIdentity) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

type RemoveParticipantResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveParticipantResponse) Reset() {
	*x = RemoveParticipantResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveParticipantResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveParticipantResponse) ProtoMessage() {}

func (x *RemoveParticipantResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveParticipantResponse.ProtoReflect.Descriptor instead.
func (*RemoveParticipantResponse) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{9}
}

type MuteRoomTrackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the room
	Room     string `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	Identity string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	// sid of the track to mute
	TrackSid string `protobuf:"bytes,3,opt,name=track_sid,json=trackSid,proto3" json:"track_sid,omitempty"`
	// set to true to mute, false to unmute
	Muted bool `protobuf:"varint,4,opt,name=muted,proto3" json:"muted,omitempty"`
}

func (x *MuteRoomTrackRequest) Reset() {
	*x = MuteRoomTrackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuteRoomTrackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuteRoomTrackRequest) ProtoMessage() {}

func (x *MuteRoomTrackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuteRoomTrackRequest.ProtoReflect.Descriptor instead.
func (*MuteRoomTrackRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{10}
}

func (x *MuteRoomTrackRequest) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

func (x *MuteRoomTrackRequest) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *MuteRoomTrackRequest) GetTrackSid() string {
	if x != nil {
		return x.TrackSid
	}
	return ""
}

func (x *MuteRoomTrackRequest) GetMuted() bool {
	if x != nil {
		return x.Muted
	}
	return false
}

type MuteRoomTrackResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Track *TrackInfo `protobuf:"bytes,1,opt,name=track,proto3" json:"track,omitempty"`
}

func (x *MuteRoomTrackResponse) Reset() {
	*x = MuteRoomTrackResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuteRoomTrackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuteRoomTrackResponse) ProtoMessage() {}

func (x *MuteRoomTrackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuteRoomTrackResponse.ProtoReflect.Descriptor instead.
func (*MuteRoomTrackResponse) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{11}
}

func (x *MuteRoomTrackResponse) GetTrack() *TrackInfo {
	if x != nil {
		return x.Track
	}
	return nil
}

type UpdateParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Room     string `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	Identity string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	// metadata to update. skipping updates if left empty
	Metadata string `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// set to update the participant's permissions
	Permission *ParticipantPermission `protobuf:"bytes,4,opt,name=permission,proto3" json:"permission,omitempty"`
	// display name to update
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UpdateParticipantRequest) Reset() {
	*x = UpdateParticipantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateParticipantRequest) ProtoMessage() {}

func (x *UpdateParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateParticipantRequest.ProtoReflect.Descriptor instead.
func (*UpdateParticipantRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateParticipantRequest) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

func (x *UpdateParticipantRequest) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *UpdateParticipantRequest) GetMetadata() string {
	if x != nil {
		return x.Metadata
	}
	return ""
}

func (x *UpdateParticipantRequest) GetPermission() *ParticipantPermission {
	if x != nil {
		return x.Permission
	}
	return nil
}

func (x *UpdateParticipantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type UpdateSubscriptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Room     string `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	Identity string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	// list of sids of tracks
	TrackSids []string `protobuf:"bytes,3,rep,name=track_sids,json=trackSids,proto3" json:"track_sids,omitempty"`
	// set to true to subscribe, false to unsubscribe from tracks
	Subscribe bool `protobuf:"varint,4,opt,name=subscribe,proto3" json:"subscribe,omitempty"`
	// list of participants and their tracks
	ParticipantTracks []*ParticipantTracks `protobuf:"bytes,5,rep,name=participant_tracks,json=participantTracks,proto3" json:"participant_tracks,omitempty"`
}

func (x *UpdateSubscriptionsRequest) Reset() {
	*x = UpdateSubscriptionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSubscriptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSubscriptionsRequest) ProtoMessage() {}

func (x *UpdateSubscriptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSubscriptionsRequest.ProtoReflect.Descriptor instead.
func (*UpdateSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateSubscriptionsRequest) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

func (x *UpdateSubscriptionsRequest) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *UpdateSubscriptionsRequest) GetTrackSids() []string {
	if x != nil {
		return x.TrackSids
	}
	return nil
}

func (x *UpdateSubscriptionsRequest) GetSubscribe() bool {
	if x != nil {
		return x.Subscribe
	}
	return false
}

func (x *UpdateSubscriptionsRequest) GetParticipantTracks() []*ParticipantTracks {
	if x != nil {
		return x.ParticipantTracks
	}
	return nil
}

type UpdateSubscriptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateSubscriptionsResponse) Reset() {
	*x = UpdateSubscriptionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSubscriptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSubscriptionsResponse) ProtoMessage() {}

func (x *UpdateSubscriptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSubscriptionsResponse.ProtoReflect.Descriptor instead.
func (*UpdateSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{14}
}

type SendDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Room string          `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	Data []byte          `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	Kind DataPacket_Kind `protobuf:"varint,3,opt,name=kind,proto3,enum=livekit.DataPacket_Kind" json:"kind,omitempty"`
	// mark deprecated
	//
	// Deprecated: Marked as deprecated in livekit_room.proto.
	DestinationSids []string `protobuf:"bytes,4,rep,name=destination_sids,json=destinationSids,proto3" json:"destination_sids,omitempty"`
	// when set, only forward to these identities
	DestinationIdentities []string `protobuf:"bytes,6,rep,name=destination_identities,json=destinationIdentities,proto3" json:"destination_identities,omitempty"`
	Topic                 *string  `protobuf:"bytes,5,opt,name=topic,proto3,oneof" json:"topic,omitempty"`
}

func (x *SendDataRequest) Reset() {
	*x = SendDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendDataRequest) ProtoMessage() {}

func (x *SendDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendDataRequest.ProtoReflect.Descriptor instead.
func (*SendDataRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{15}
}

func (x *SendDataRequest) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

func (x *SendDataRequest) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *SendDataRequest) GetKind() DataPacket_Kind {
	if x != nil {
		return x.Kind
	}
	return DataPacket_RELIABLE
}

// Deprecated: Marked as deprecated in livekit_room.proto.
func (x *SendDataRequest) GetDestinationSids() []string {
	if x != nil {
		return x.DestinationSids
	}
	return nil
}

func (x *SendDataRequest) GetDestinationIdentities() []string {
	if x != nil {
		return x.DestinationIdentities
	}
	return nil
}

func (x *SendDataRequest) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

type SendDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SendDataResponse) Reset() {
	*x = SendDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendDataResponse) ProtoMessage() {}

func (x *SendDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendDataResponse.ProtoReflect.Descriptor instead.
func (*SendDataResponse) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{16}
}

type UpdateRoomMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Room string `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	// metadata to update. skipping updates if left empty
	Metadata string `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *UpdateRoomMetadataRequest) Reset() {
	*x = UpdateRoomMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_room_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRoomMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRoomMetadataRequest) ProtoMessage() {}

func (x *UpdateRoomMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_room_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRoomMetadataRequest.ProtoReflect.Descriptor instead.
func (*UpdateRoomMetadataRequest) Descriptor() ([]byte, []int) {
	return file_livekit_room_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateRoomMetadataRequest) GetRoom() string {
	if x != nil {
		return x.Room
	}
	return ""
}

func (x *UpdateRoomMetadataRequest) GetMetadata() string {
	if x != nil {
		return x.Metadata
	}
	return ""
}

var File_livekit_room_proto protoreflect.FileDescriptor

var file_livekit_room_proto_rawDesc = []byte{
	0x0a, 0x12, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x72, 0x6f, 0x6f, 0x6d, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x1a, 0x14, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x65, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x02, 0x0a, 0x11, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x06, 0x65, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x06, 0x65,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x6c, 0x61,
	0x79, 0x6f, 0x75, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x50, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x44, 0x65, 0x6c, 0x61,
	0x79, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x6d, 0x61,
	0x78, 0x50, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x21, 0x0a,
	0x0c, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x22, 0xb9, 0x01, 0x0a, 0x0a, 0x52, 0x6f, 0x6f, 0x6d, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x37, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x65, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12, 0x40, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0b, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x22, 0x28, 0x0a, 0x10,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x38, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x6f, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x05, 0x72,
	0x6f, 0x6f, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x05, 0x72, 0x6f, 0x6f, 0x6d, 0x73,
	0x22, 0x27, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x22, 0x14, 0x0a, 0x12, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x2d, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f,
	0x6f, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x22, 0x58,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x0c, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x22, 0x49, 0x0a, 0x17, 0x52, 0x6f, 0x6f, 0x6d,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x22, 0x1b, 0x0a, 0x19, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x79, 0x0a, 0x14, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x54, 0x72, 0x61, 0x63,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x53, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x22, 0x41, 0x0a, 0x15, 0x4d,
	0x75, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x22, 0xba,
	0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72,
	0x6f, 0x6f, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x1a,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f,
	0x6f, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12, 0x1a,
	0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x49, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x52,
	0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x63,
	0x6b, 0x73, 0x22, 0x1d, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xf2, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x2d, 0x0a, 0x10, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x64, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x16, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x12, 0x0a, 0x10, 0x53, 0x65, 0x6e, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x0a, 0x19, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0xe6, 0x06, 0x0a, 0x0b, 0x52, 0x6f, 0x6f, 0x6d,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x12, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x0d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d,
	0x12, 0x42, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x12, 0x19, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f,
	0x6f, 0x6d, 0x12, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x6f, 0x6f, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12,
	0x20, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x21, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x20, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x1a, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x59, 0x0a, 0x11, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x20, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x1a, 0x22, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a,
	0x12, 0x4d, 0x75, 0x74, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x12, 0x1d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4d, 0x75,
	0x74, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4d, 0x75, 0x74,
	0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x50, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x21, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x60, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x24, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x53, 0x65, 0x6e, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x6e,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x22, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x0d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d,
	0x42, 0x46, 0x5a, 0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69,
	0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69,
	0x74, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_room_proto_rawDescOnce sync.Once
	file_livekit_room_proto_rawDescData = file_livekit_room_proto_rawDesc
)

func file_livekit_room_proto_rawDescGZIP() []byte {
	file_livekit_room_proto_rawDescOnce.Do(func() {
		file_livekit_room_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_room_proto_rawDescData)
	})
	return file_livekit_room_proto_rawDescData
}

var file_livekit_room_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_livekit_room_proto_goTypes = []interface{}{
	(*CreateRoomRequest)(nil),           // 0: livekit.CreateRoomRequest
	(*RoomEgress)(nil),                  // 1: livekit.RoomEgress
	(*ListRoomsRequest)(nil),            // 2: livekit.ListRoomsRequest
	(*ListRoomsResponse)(nil),           // 3: livekit.ListRoomsResponse
	(*DeleteRoomRequest)(nil),           // 4: livekit.DeleteRoomRequest
	(*DeleteRoomResponse)(nil),          // 5: livekit.DeleteRoomResponse
	(*ListParticipantsRequest)(nil),     // 6: livekit.ListParticipantsRequest
	(*ListParticipantsResponse)(nil),    // 7: livekit.ListParticipantsResponse
	(*RoomParticipantIdentity)(nil),     // 8: livekit.RoomParticipantIdentity
	(*RemoveParticipantResponse)(nil),   // 9: livekit.RemoveParticipantResponse
	(*MuteRoomTrackRequest)(nil),        // 10: livekit.MuteRoomTrackRequest
	(*MuteRoomTrackResponse)(nil),       // 11: livekit.MuteRoomTrackResponse
	(*UpdateParticipantRequest)(nil),    // 12: livekit.UpdateParticipantRequest
	(*UpdateSubscriptionsRequest)(nil),  // 13: livekit.UpdateSubscriptionsRequest
	(*UpdateSubscriptionsResponse)(nil), // 14: livekit.UpdateSubscriptionsResponse
	(*SendDataRequest)(nil),             // 15: livekit.SendDataRequest
	(*SendDataResponse)(nil),            // 16: livekit.SendDataResponse
	(*UpdateRoomMetadataRequest)(nil),   // 17: livekit.UpdateRoomMetadataRequest
	(*RoomCompositeEgressRequest)(nil),  // 18: livekit.RoomCompositeEgressRequest
	(*AutoParticipantEgress)(nil),       // 19: livekit.AutoParticipantEgress
	(*AutoTrackEgress)(nil),             // 20: livekit.AutoTrackEgress
	(*Room)(nil),                        // 21: livekit.Room
	(*ParticipantInfo)(nil),             // 22: livekit.ParticipantInfo
	(*TrackInfo)(nil),                   // 23: livekit.TrackInfo
	(*ParticipantPermission)(nil),       // 24: livekit.ParticipantPermission
	(*ParticipantTracks)(nil),           // 25: livekit.ParticipantTracks
	(DataPacket_Kind)(0),                // 26: livekit.DataPacket.Kind
}
var file_livekit_room_proto_depIdxs = []int32{
	1,  // 0: livekit.CreateRoomRequest.egress:type_name -> livekit.RoomEgress
	18, // 1: livekit.RoomEgress.room:type_name -> livekit.RoomCompositeEgressRequest
	19, // 2: livekit.RoomEgress.participant:type_name -> livekit.AutoParticipantEgress
	20, // 3: livekit.RoomEgress.tracks:type_name -> livekit.AutoTrackEgress
	21, // 4: livekit.ListRoomsResponse.rooms:type_name -> livekit.Room
	22, // 5: livekit.ListParticipantsResponse.participants:type_name -> livekit.ParticipantInfo
	23, // 6: livekit.MuteRoomTrackResponse.track:type_name -> livekit.TrackInfo
	24, // 7: livekit.UpdateParticipantRequest.permission:type_name -> livekit.ParticipantPermission
	25, // 8: livekit.UpdateSubscriptionsRequest.participant_tracks:type_name -> livekit.ParticipantTracks
	26, // 9: livekit.SendDataRequest.kind:type_name -> livekit.DataPacket.Kind
	0,  // 10: livekit.RoomService.CreateRoom:input_type -> livekit.CreateRoomRequest
	2,  // 11: livekit.RoomService.ListRooms:input_type -> livekit.ListRoomsRequest
	4,  // 12: livekit.RoomService.DeleteRoom:input_type -> livekit.DeleteRoomRequest
	6,  // 13: livekit.RoomService.ListParticipants:input_type -> livekit.ListParticipantsRequest
	8,  // 14: livekit.RoomService.GetParticipant:input_type -> livekit.RoomParticipantIdentity
	8,  // 15: livekit.RoomService.RemoveParticipant:input_type -> livekit.RoomParticipantIdentity
	10, // 16: livekit.RoomService.MutePublishedTrack:input_type -> livekit.MuteRoomTrackRequest
	12, // 17: livekit.RoomService.UpdateParticipant:input_type -> livekit.UpdateParticipantRequest
	13, // 18: livekit.RoomService.UpdateSubscriptions:input_type -> livekit.UpdateSubscriptionsRequest
	15, // 19: livekit.RoomService.SendData:input_type -> livekit.SendDataRequest
	17, // 20: livekit.RoomService.UpdateRoomMetadata:input_type -> livekit.UpdateRoomMetadataRequest
	21, // 21: livekit.RoomService.CreateRoom:output_type -> livekit.Room
	3,  // 22: livekit.RoomService.ListRooms:output_type -> livekit.ListRoomsResponse
	5,  // 23: livekit.RoomService.DeleteRoom:output_type -> livekit.DeleteRoomResponse
	7,  // 24: livekit.RoomService.ListParticipants:output_type -> livekit.ListParticipantsResponse
	22, // 25: livekit.RoomService.GetParticipant:output_type -> livekit.ParticipantInfo
	9,  // 26: livekit.RoomService.RemoveParticipant:output_type -> livekit.RemoveParticipantResponse
	11, // 27: livekit.RoomService.MutePublishedTrack:output_type -> livekit.MuteRoomTrackResponse
	22, // 28: livekit.RoomService.UpdateParticipant:output_type -> livekit.ParticipantInfo
	14, // 29: livekit.RoomService.UpdateSubscriptions:output_type -> livekit.UpdateSubscriptionsResponse
	16, // 30: livekit.RoomService.SendData:output_type -> livekit.SendDataResponse
	21, // 31: livekit.RoomService.UpdateRoomMetadata:output_type -> livekit.Room
	21, // [21:32] is the sub-list for method output_type
	10, // [10:21] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_livekit_room_proto_init() }
func file_livekit_room_proto_init() {
	if File_livekit_room_proto != nil {
		return
	}
	file_livekit_models_proto_init()
	file_livekit_egress_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_livekit_room_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRoomRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoomEgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRoomsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRoomsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRoomRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRoomResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListParticipantsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListParticipantsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoomParticipantIdentity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveParticipantResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuteRoomTrackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuteRoomTrackResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateParticipantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSubscriptionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSubscriptionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_room_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRoomMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_livekit_room_proto_msgTypes[15].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_room_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_livekit_room_proto_goTypes,
		DependencyIndexes: file_livekit_room_proto_depIdxs,
		MessageInfos:      file_livekit_room_proto_msgTypes,
	}.Build()
	File_livekit_room_proto = out.File
	file_livekit_room_proto_rawDesc = nil
	file_livekit_room_proto_goTypes = nil
	file_livekit_room_proto_depIdxs = nil
}
