// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use glib_sys as glib;
use gstreamer_sys as gst;

mod manual;

pub use manual::*;

#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use libc::{intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Aliases
pub type GstAnalyticsMtdType = uintptr_t;

// Enums
pub type GstSegmentationType = c_int;
pub const GST_SEGMENTATION_TYPE_SEMANTIC: GstSegmentationType = 0;
pub const GST_SEGMENTATION_TYPE_INSTANCE: GstSegmentationType = 1;

pub type GstTensorDataType = c_int;
pub const GST_TENSOR_DATA_TYPE_INT4: GstTensorDataType = 0;
pub const GST_TENSOR_DATA_TYPE_INT8: GstTensorDataType = 1;
pub const GST_TENSOR_DATA_TYPE_INT16: GstTensorDataType = 2;
pub const GST_TENSOR_DATA_TYPE_INT32: GstTensorDataType = 3;
pub const GST_TENSOR_DATA_TYPE_INT64: GstTensorDataType = 4;
pub const GST_TENSOR_DATA_TYPE_UINT4: GstTensorDataType = 5;
pub const GST_TENSOR_DATA_TYPE_UINT8: GstTensorDataType = 6;
pub const GST_TENSOR_DATA_TYPE_UINT16: GstTensorDataType = 7;
pub const GST_TENSOR_DATA_TYPE_UINT32: GstTensorDataType = 8;
pub const GST_TENSOR_DATA_TYPE_UINT64: GstTensorDataType = 9;
pub const GST_TENSOR_DATA_TYPE_FLOAT16: GstTensorDataType = 10;
pub const GST_TENSOR_DATA_TYPE_FLOAT32: GstTensorDataType = 11;
pub const GST_TENSOR_DATA_TYPE_FLOAT64: GstTensorDataType = 12;
pub const GST_TENSOR_DATA_TYPE_BFLOAT16: GstTensorDataType = 13;

pub type GstTensorDimOrder = c_int;
pub const GST_TENSOR_DIM_ORDER_ROW_MAJOR: GstTensorDimOrder = 0;
pub const GST_TENSOR_DIM_ORDER_COL_MAJOR: GstTensorDimOrder = 1;

pub type GstTensorLayout = c_int;
pub const GST_TENSOR_LAYOUT_CONTIGUOUS: GstTensorLayout = 0;

// Constants
pub const GST_INF_RELATION_SPAN: c_int = -1;
pub const GST_ANALYTICS_MTD_TYPE_ANY: c_int = 0;

// Flags
pub type GstAnalyticsRelTypes = c_uint;
pub const GST_ANALYTICS_REL_TYPE_NONE: GstAnalyticsRelTypes = 0;
pub const GST_ANALYTICS_REL_TYPE_IS_PART_OF: GstAnalyticsRelTypes = 2;
pub const GST_ANALYTICS_REL_TYPE_CONTAIN: GstAnalyticsRelTypes = 4;
pub const GST_ANALYTICS_REL_TYPE_RELATE_TO: GstAnalyticsRelTypes = 8;
#[cfg(feature = "v1_26")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
pub const GST_ANALYTICS_REL_TYPE_N_TO_N: GstAnalyticsRelTypes = 16;
pub const GST_ANALYTICS_REL_TYPE_ANY: GstAnalyticsRelTypes = 2147483647;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAnalyticsClsMtd {
    pub id: c_uint,
    pub meta: *mut GstAnalyticsRelationMeta,
}

impl ::std::fmt::Debug for GstAnalyticsClsMtd {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAnalyticsClsMtd @ {self:p}"))
            .field("id", &self.id)
            .field("meta", &self.meta)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAnalyticsMtd {
    pub id: c_uint,
    pub meta: *mut GstAnalyticsRelationMeta,
}

impl ::std::fmt::Debug for GstAnalyticsMtd {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAnalyticsMtd @ {self:p}"))
            .field("id", &self.id)
            .field("meta", &self.meta)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAnalyticsMtdImpl {
    pub name: *const c_char,
    pub mtd_meta_transform: Option<
        unsafe extern "C" fn(
            *mut gst::GstBuffer,
            *mut GstAnalyticsMtd,
            *mut gst::GstBuffer,
            glib::GQuark,
            gpointer,
        ) -> gboolean,
    >,
    pub mtd_meta_clear: Option<unsafe extern "C" fn(*mut gst::GstBuffer, *mut GstAnalyticsMtd)>,
    pub _reserved: [gpointer; 19],
}

impl ::std::fmt::Debug for GstAnalyticsMtdImpl {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAnalyticsMtdImpl @ {self:p}"))
            .field("name", &self.name)
            .field("mtd_meta_transform", &self.mtd_meta_transform)
            .field("mtd_meta_clear", &self.mtd_meta_clear)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAnalyticsODMtd {
    pub id: c_uint,
    pub meta: *mut GstAnalyticsRelationMeta,
}

impl ::std::fmt::Debug for GstAnalyticsODMtd {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAnalyticsODMtd @ {self:p}"))
            .field("id", &self.id)
            .field("meta", &self.meta)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstAnalyticsRelationMeta {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstAnalyticsRelationMeta = _GstAnalyticsRelationMeta;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAnalyticsRelationMetaInitParams {
    pub initial_relation_order: size_t,
    pub initial_buf_size: size_t,
}

impl ::std::fmt::Debug for GstAnalyticsRelationMetaInitParams {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAnalyticsRelationMetaInitParams @ {self:p}"))
            .field("initial_relation_order", &self.initial_relation_order)
            .field("initial_buf_size", &self.initial_buf_size)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAnalyticsSegmentationMtd {
    pub id: c_uint,
    pub meta: *mut GstAnalyticsRelationMeta,
}

impl ::std::fmt::Debug for GstAnalyticsSegmentationMtd {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAnalyticsSegmentationMtd @ {self:p}"))
            .field("id", &self.id)
            .field("meta", &self.meta)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAnalyticsTrackingMtd {
    pub id: c_uint,
    pub meta: *mut GstAnalyticsRelationMeta,
}

impl ::std::fmt::Debug for GstAnalyticsTrackingMtd {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAnalyticsTrackingMtd @ {self:p}"))
            .field("id", &self.id)
            .field("meta", &self.meta)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstTensorMeta {
    pub meta: gst::GstMeta,
    pub num_tensors: size_t,
    pub tensors: *mut *mut GstTensor,
}

impl ::std::fmt::Debug for GstTensorMeta {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstTensorMeta @ {self:p}"))
            .field("meta", &self.meta)
            .field("num_tensors", &self.num_tensors)
            .field("tensors", &self.tensors)
            .finish()
    }
}

extern "C" {

    //=========================================================================
    // GstAnalyticsClsMtd
    //=========================================================================
    pub fn gst_analytics_cls_mtd_get_index_by_quark(
        handle: *const GstAnalyticsClsMtd,
        quark: glib::GQuark,
    ) -> c_int;
    pub fn gst_analytics_cls_mtd_get_length(handle: *const GstAnalyticsClsMtd) -> size_t;
    pub fn gst_analytics_cls_mtd_get_level(
        handle: *const GstAnalyticsClsMtd,
        index: size_t,
    ) -> c_float;
    pub fn gst_analytics_cls_mtd_get_quark(
        handle: *const GstAnalyticsClsMtd,
        index: size_t,
    ) -> glib::GQuark;
    pub fn gst_analytics_cls_mtd_get_mtd_type() -> GstAnalyticsMtdType;

    //=========================================================================
    // GstAnalyticsMtd
    //=========================================================================
    pub fn gst_analytics_mtd_get_id(instance: *const GstAnalyticsMtd) -> c_uint;
    pub fn gst_analytics_mtd_get_mtd_type(instance: *const GstAnalyticsMtd) -> GstAnalyticsMtdType;
    pub fn gst_analytics_mtd_get_size(instance: *const GstAnalyticsMtd) -> size_t;
    pub fn gst_analytics_mtd_type_get_name(type_: GstAnalyticsMtdType) -> *const c_char;

    //=========================================================================
    // GstAnalyticsODMtd
    //=========================================================================
    pub fn gst_analytics_od_mtd_get_confidence_lvl(
        instance: *const GstAnalyticsODMtd,
        loc_conf_lvl: *mut c_float,
    ) -> gboolean;
    pub fn gst_analytics_od_mtd_get_location(
        instance: *const GstAnalyticsODMtd,
        x: *mut c_int,
        y: *mut c_int,
        w: *mut c_int,
        h: *mut c_int,
        loc_conf_lvl: *mut c_float,
    ) -> gboolean;
    pub fn gst_analytics_od_mtd_get_obj_type(handle: *const GstAnalyticsODMtd) -> glib::GQuark;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_od_mtd_get_oriented_location(
        instance: *const GstAnalyticsODMtd,
        x: *mut c_int,
        y: *mut c_int,
        w: *mut c_int,
        h: *mut c_int,
        r: *mut c_float,
        loc_conf_lvl: *mut c_float,
    ) -> gboolean;
    pub fn gst_analytics_od_mtd_get_mtd_type() -> GstAnalyticsMtdType;

    //=========================================================================
    // GstAnalyticsRelationMeta
    //=========================================================================
    pub fn gst_analytics_relation_meta_add_cls_mtd(
        instance: *mut GstAnalyticsRelationMeta,
        length: size_t,
        confidence_levels: *mut c_float,
        class_quarks: *mut glib::GQuark,
        cls_mtd: *mut GstAnalyticsClsMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_add_mtd(
        meta: *mut GstAnalyticsRelationMeta,
        impl_: *const GstAnalyticsMtdImpl,
        size: size_t,
        rlt_mtd: *mut GstAnalyticsMtd,
    ) -> gpointer;
    pub fn gst_analytics_relation_meta_add_od_mtd(
        instance: *mut GstAnalyticsRelationMeta,
        type_: glib::GQuark,
        x: c_int,
        y: c_int,
        w: c_int,
        h: c_int,
        loc_conf_lvl: c_float,
        od_mtd: *mut GstAnalyticsODMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_add_one_cls_mtd(
        instance: *mut GstAnalyticsRelationMeta,
        confidence_level: c_float,
        class_quark: glib::GQuark,
        cls_mtd: *mut GstAnalyticsClsMtd,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_relation_meta_add_oriented_od_mtd(
        instance: *mut GstAnalyticsRelationMeta,
        type_: glib::GQuark,
        x: c_int,
        y: c_int,
        w: c_int,
        h: c_int,
        r: c_float,
        loc_conf_lvl: c_float,
        od_mtd: *mut GstAnalyticsODMtd,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_relation_meta_add_segmentation_mtd(
        instance: *mut GstAnalyticsRelationMeta,
        buffer: *mut gst::GstBuffer,
        segmentation_type: GstSegmentationType,
        region_count: size_t,
        region_ids: *mut c_uint,
        masks_loc_x: c_int,
        masks_loc_y: c_int,
        masks_loc_w: c_uint,
        masks_loc_h: c_uint,
        segmentation_mtd: *mut GstAnalyticsSegmentationMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_add_tracking_mtd(
        instance: *mut GstAnalyticsRelationMeta,
        tracking_id: u64,
        tracking_first_seen: gst::GstClockTime,
        trk_mtd: *mut GstAnalyticsTrackingMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_exist(
        rmeta: *const GstAnalyticsRelationMeta,
        an_meta_first_id: c_uint,
        an_meta_second_id: c_uint,
        max_relation_span: c_int,
        cond_types: GstAnalyticsRelTypes,
        relations_path: *mut *mut glib::GArray,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_get_cls_mtd(
        meta: *mut GstAnalyticsRelationMeta,
        an_meta_id: c_uint,
        rlt: *mut GstAnalyticsClsMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_get_direct_related(
        meta: *mut GstAnalyticsRelationMeta,
        an_meta_id: c_uint,
        relation_type: GstAnalyticsRelTypes,
        type_: GstAnalyticsMtdType,
        state: *mut gpointer,
        rlt_mtd: *mut GstAnalyticsMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_get_mtd(
        meta: *mut GstAnalyticsRelationMeta,
        an_meta_id: c_uint,
        type_: GstAnalyticsMtdType,
        rlt: *mut GstAnalyticsMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_get_mtd_data(
        meta: *const GstAnalyticsRelationMeta,
        an_meta_id: c_uint,
    ) -> gpointer;
    pub fn gst_analytics_relation_meta_get_od_mtd(
        meta: *mut GstAnalyticsRelationMeta,
        an_meta_id: c_uint,
        rlt: *mut GstAnalyticsODMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_get_relation(
        meta: *const GstAnalyticsRelationMeta,
        an_meta_first_id: c_uint,
        an_meta_second_id: c_uint,
    ) -> GstAnalyticsRelTypes;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_relation_meta_get_segmentation_mtd(
        meta: *mut GstAnalyticsRelationMeta,
        an_meta_id: c_uint,
        rlt: *mut GstAnalyticsSegmentationMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_get_tracking_mtd(
        meta: *mut GstAnalyticsRelationMeta,
        an_meta_id: c_uint,
        rlt: *mut GstAnalyticsTrackingMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_iterate(
        meta: *mut GstAnalyticsRelationMeta,
        state: *mut gpointer,
        type_: GstAnalyticsMtdType,
        rlt_mtd: *mut GstAnalyticsMtd,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_set_relation(
        meta: *mut GstAnalyticsRelationMeta,
        type_: GstAnalyticsRelTypes,
        an_meta_first_id: c_uint,
        an_meta_second_id: c_uint,
    ) -> gboolean;
    pub fn gst_analytics_relation_meta_get_info() -> *const gst::GstMetaInfo;

    //=========================================================================
    // GstAnalyticsSegmentationMtd
    //=========================================================================
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_segmentation_mtd_get_mask(
        handle: *const GstAnalyticsSegmentationMtd,
        masks_loc_x: *mut c_int,
        masks_loc_y: *mut c_int,
        masks_loc_w: *mut c_uint,
        masks_loc_h: *mut c_uint,
    ) -> *mut gst::GstBuffer;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_segmentation_mtd_get_region_count(
        handle: *const GstAnalyticsSegmentationMtd,
    ) -> size_t;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_segmentation_mtd_get_region_id(
        handle: *const GstAnalyticsSegmentationMtd,
        index: size_t,
    ) -> c_uint;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_segmentation_mtd_get_region_index(
        handle: *const GstAnalyticsSegmentationMtd,
        index: *mut size_t,
        id: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_analytics_segmentation_mtd_get_mtd_type() -> GstAnalyticsMtdType;

    //=========================================================================
    // GstAnalyticsTrackingMtd
    //=========================================================================
    pub fn gst_analytics_tracking_mtd_get_info(
        instance: *const GstAnalyticsTrackingMtd,
        tracking_id: *mut u64,
        tracking_first_seen: *mut gst::GstClockTime,
        tracking_last_seen: *mut gst::GstClockTime,
        tracking_lost: *mut gboolean,
    ) -> gboolean;
    pub fn gst_analytics_tracking_mtd_set_lost(instance: *mut GstAnalyticsTrackingMtd) -> gboolean;
    pub fn gst_analytics_tracking_mtd_update_last_seen(
        instance: *mut GstAnalyticsTrackingMtd,
        last_seen: gst::GstClockTime,
    ) -> gboolean;
    pub fn gst_analytics_tracking_mtd_get_mtd_type() -> GstAnalyticsMtdType;

    //=========================================================================
    // GstTensor
    //=========================================================================
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_get_type() -> GType;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_alloc(num_dims: size_t) -> *mut GstTensor;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_new_simple(
        id: glib::GQuark,
        data_type: GstTensorDataType,
        data: *mut gst::GstBuffer,
        dims_order: GstTensorDimOrder,
        num_dims: size_t,
        dims: *mut size_t,
    ) -> *mut GstTensor;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_copy(tensor: *const GstTensor) -> *mut GstTensor;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_free(tensor: *mut GstTensor);
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_get_dims(tensor: *mut GstTensor, num_dims: *mut size_t) -> *mut size_t;

    //=========================================================================
    // GstTensorMeta
    //=========================================================================
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_meta_get(tmeta: *mut GstTensorMeta, index: size_t) -> *const GstTensor;
    #[cfg(feature = "v1_28")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_28")))]
    pub fn gst_tensor_meta_get_by_id(
        tmeta: *mut GstTensorMeta,
        id: glib::GQuark,
    ) -> *const GstTensor;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_meta_get_index_from_id(meta: *mut GstTensorMeta, id: glib::GQuark) -> c_int;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_meta_set(
        tmeta: *mut GstTensorMeta,
        num_tensors: c_uint,
        tensors: *mut *mut GstTensor,
    );
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_meta_get_info() -> *const gst::GstMetaInfo;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_buffer_add_analytics_relation_meta(
        buffer: *mut gst::GstBuffer,
    ) -> *mut GstAnalyticsRelationMeta;
    pub fn gst_buffer_add_analytics_relation_meta_full(
        buffer: *mut gst::GstBuffer,
        init_params: *mut GstAnalyticsRelationMetaInitParams,
    ) -> *mut GstAnalyticsRelationMeta;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_buffer_add_tensor_meta(buffer: *mut gst::GstBuffer) -> *mut GstTensorMeta;
    pub fn gst_buffer_get_analytics_relation_meta(
        buffer: *mut gst::GstBuffer,
    ) -> *mut GstAnalyticsRelationMeta;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_buffer_get_tensor_meta(buffer: *mut gst::GstBuffer) -> *mut GstTensorMeta;
    #[cfg(feature = "v1_28")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_28")))]
    pub fn gst_analytics_image_util_iou_float(
        bb1_x: c_float,
        bb1_y: c_float,
        bb1_w: c_float,
        bb1_h: c_float,
        bb2_x: c_float,
        bb2_y: c_float,
        bb2_w: c_float,
        bb2_h: c_float,
    ) -> c_float;
    #[cfg(feature = "v1_28")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_28")))]
    pub fn gst_analytics_image_util_iou_int(
        bb1_x: c_int,
        bb1_y: c_int,
        bb1_w: c_int,
        bb1_h: c_int,
        bb2_x: c_int,
        bb2_y: c_int,
        bb2_w: c_int,
        bb2_h: c_int,
    ) -> c_float;
    pub fn gst_analytics_relation_get_length(instance: *const GstAnalyticsRelationMeta) -> size_t;
    pub fn gst_analytics_relation_meta_api_get_type() -> GType;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_tensor_meta_api_get_type() -> GType;

}
