// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StartTextTranslationJob`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_name(impl Into<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::job_name) / [`set_job_name(Option<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_job_name):<br>required: **false**<br><p>The name of the batch translation job to be performed.</p><br>
    ///   - [`input_data_config(InputDataConfig)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_input_data_config):<br>required: **true**<br><p>Specifies the format and location of the input documents for the translation job.</p><br>
    ///   - [`output_data_config(OutputDataConfig)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_output_data_config):<br>required: **true**<br><p>Specifies the S3 folder to which your job output will be saved.</p><br>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_data_access_role_arn):<br>required: **true**<br><p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and access management </a>.</p><br>
    ///   - [`source_language_code(impl Into<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::source_language_code) / [`set_source_language_code(Option<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_source_language_code):<br>required: **true**<br><p>The language code of the input language. Specify the language if all input documents share the same language. If you don't know the language of the source files, or your input documents contains different source languages, select <code>auto</code>. Amazon Translate auto detects the source language for each input document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p><br>
    ///   - [`target_language_codes(impl Into<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::target_language_codes) / [`set_target_language_codes(Option<Vec::<String>>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_target_language_codes):<br>required: **true**<br><p>The target languages of the translation job. Enter up to 10 language codes. Each input file is translated into each target language.</p> <p>Each language code is 2 or 5 characters long. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p><br>
    ///   - [`terminology_names(impl Into<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::terminology_names) / [`set_terminology_names(Option<Vec::<String>>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_terminology_names):<br>required: **false**<br><p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p> <p>This parameter accepts only one custom terminology resource.</p> <p>If you specify multiple target languages for the job, translate uses the designated terminology for each requested target language that has an entry for the source term in the terminology file.</p> <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p><br>
    ///   - [`parallel_data_names(impl Into<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::parallel_data_names) / [`set_parallel_data_names(Option<Vec::<String>>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_parallel_data_names):<br>required: **false**<br><p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. If you specify multiple target languages for the job, the parallel data file must include translations for all the target languages.</p> <p>When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.</p> <p>This parameter accepts only one parallel data resource.</p><note>  <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p> </note> <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html"> Customizing your translations with parallel data</a>.</p><br>
    ///   - [`client_token(impl Into<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::client_token) / [`set_client_token(Option<String>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_client_token):<br>required: **true**<br><p>A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.</p><br>
    ///   - [`settings(TranslationSettings)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::settings) / [`set_settings(Option<TranslationSettings>)`](crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::set_settings):<br>required: **false**<br><p>Settings to configure your translation output. You can configure the following options:</p> <ul>  <li>   <p>Brevity: not supported.</p></li>  <li>   <p>Formality: sets the formality level of the output text.</p></li>  <li>   <p>Profanity: masks profane words and phrases in your translation output.</p></li> </ul><br>
    /// - On success, responds with [`StartTextTranslationJobOutput`](crate::operation::start_text_translation_job::StartTextTranslationJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::operation::start_text_translation_job::StartTextTranslationJobOutput::job_id): <p>The identifier generated for the job. To get the status of a job, use this ID with the <code>DescribeTextTranslationJob</code> operation.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::operation::start_text_translation_job::StartTextTranslationJobOutput::job_status): <p>The status of the job. Possible values include:</p> <ul>  <li>   <p><code>SUBMITTED</code> - The job has been received and is queued for processing.</p></li>  <li>   <p><code>IN_PROGRESS</code> - Amazon Translate is processing the job.</p></li>  <li>   <p><code>COMPLETED</code> - The job was successfully completed and the output is available.</p></li>  <li>   <p><code>COMPLETED_WITH_ERROR</code> - The job was completed with errors. The errors can be analyzed in the job's output.</p></li>  <li>   <p><code>FAILED</code> - The job did not complete. To get details, use the <code>DescribeTextTranslationJob</code> operation.</p></li>  <li>   <p><code>STOP_REQUESTED</code> - The user who started the job has requested that it be stopped.</p></li>  <li>   <p><code>STOPPED</code> - The job has been stopped.</p></li> </ul>
    /// - On failure, responds with [`SdkError<StartTextTranslationJobError>`](crate::operation::start_text_translation_job::StartTextTranslationJobError)
    pub fn start_text_translation_job(&self) -> crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder {
        crate::operation::start_text_translation_job::builders::StartTextTranslationJobFluentBuilder::new(self.handle.clone())
    }
}
