// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An encoded stream of events. The stream is encoded as HTTP/2 data frames.</p>
/// <p>An input stream consists of the following types of events. The first element of the input stream must be the <code>MedicalScribeConfigurationEvent</code> event type.</p>
/// <ul>
/// <li>
/// <p><code>MedicalScribeConfigurationEvent</code></p></li>
/// <li>
/// <p><code>MedicalScribeAudioEvent</code></p></li>
/// <li>
/// <p><code>MedicalScribeSessionControlEvent</code></p></li>
/// </ul>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum MedicalScribeInputStream {
    /// <p>A wrapper for your audio chunks</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html">Event stream encoding</a>.</p>
    AudioEvent(crate::types::MedicalScribeAudioEvent),
    /// <p>Specify additional streaming session configurations beyond those provided in your initial start request headers. For example, specify channel definitions, encryption settings, and post-stream analytics settings.</p>
    /// <p>Whether you are starting a new session or resuming an existing session, your first event must be a <code>MedicalScribeConfigurationEvent</code>.</p>
    ConfigurationEvent(crate::types::MedicalScribeConfigurationEvent),
    /// <p>Specify the lifecycle of your streaming session, such as ending the session.</p>
    SessionControlEvent(crate::types::MedicalScribeSessionControlEvent),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl MedicalScribeInputStream {
    /// Tries to convert the enum instance into [`AudioEvent`](crate::types::MedicalScribeInputStream::AudioEvent), extracting the inner [`MedicalScribeAudioEvent`](crate::types::MedicalScribeAudioEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_audio_event(&self) -> ::std::result::Result<&crate::types::MedicalScribeAudioEvent, &Self> {
        if let MedicalScribeInputStream::AudioEvent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`AudioEvent`](crate::types::MedicalScribeInputStream::AudioEvent).
    pub fn is_audio_event(&self) -> bool {
        self.as_audio_event().is_ok()
    }
    /// Tries to convert the enum instance into [`ConfigurationEvent`](crate::types::MedicalScribeInputStream::ConfigurationEvent), extracting the inner [`MedicalScribeConfigurationEvent`](crate::types::MedicalScribeConfigurationEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_configuration_event(&self) -> ::std::result::Result<&crate::types::MedicalScribeConfigurationEvent, &Self> {
        if let MedicalScribeInputStream::ConfigurationEvent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ConfigurationEvent`](crate::types::MedicalScribeInputStream::ConfigurationEvent).
    pub fn is_configuration_event(&self) -> bool {
        self.as_configuration_event().is_ok()
    }
    /// Tries to convert the enum instance into [`SessionControlEvent`](crate::types::MedicalScribeInputStream::SessionControlEvent), extracting the inner [`MedicalScribeSessionControlEvent`](crate::types::MedicalScribeSessionControlEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_session_control_event(&self) -> ::std::result::Result<&crate::types::MedicalScribeSessionControlEvent, &Self> {
        if let MedicalScribeInputStream::SessionControlEvent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`SessionControlEvent`](crate::types::MedicalScribeInputStream::SessionControlEvent).
    pub fn is_session_control_event(&self) -> bool {
        self.as_session_control_event().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
