// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The details for clinical note generation, including status, and output locations for clinical note and aggregated transcript if the analytics completed, or failure reason if the analytics failed.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ClinicalNoteGenerationResult {
    /// <p>Holds the Amazon S3 URI for the output Clinical Note.</p>
    pub clinical_note_output_location: ::std::option::Option<::std::string::String>,
    /// <p>Holds the Amazon S3 URI for the output Transcript.</p>
    pub transcript_output_location: ::std::option::Option<::std::string::String>,
    /// <p>The status of the clinical note generation.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul>
    /// <p>After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.</p>
    pub status: ::std::option::Option<crate::types::ClinicalNoteGenerationStatus>,
    /// <p>If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.</p>
    pub failure_reason: ::std::option::Option<::std::string::String>,
}
impl ClinicalNoteGenerationResult {
    /// <p>Holds the Amazon S3 URI for the output Clinical Note.</p>
    pub fn clinical_note_output_location(&self) -> ::std::option::Option<&str> {
        self.clinical_note_output_location.as_deref()
    }
    /// <p>Holds the Amazon S3 URI for the output Transcript.</p>
    pub fn transcript_output_location(&self) -> ::std::option::Option<&str> {
        self.transcript_output_location.as_deref()
    }
    /// <p>The status of the clinical note generation.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul>
    /// <p>After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.</p>
    pub fn status(&self) -> ::std::option::Option<&crate::types::ClinicalNoteGenerationStatus> {
        self.status.as_ref()
    }
    /// <p>If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.</p>
    pub fn failure_reason(&self) -> ::std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl ClinicalNoteGenerationResult {
    /// Creates a new builder-style object to manufacture [`ClinicalNoteGenerationResult`](crate::types::ClinicalNoteGenerationResult).
    pub fn builder() -> crate::types::builders::ClinicalNoteGenerationResultBuilder {
        crate::types::builders::ClinicalNoteGenerationResultBuilder::default()
    }
}

/// A builder for [`ClinicalNoteGenerationResult`](crate::types::ClinicalNoteGenerationResult).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ClinicalNoteGenerationResultBuilder {
    pub(crate) clinical_note_output_location: ::std::option::Option<::std::string::String>,
    pub(crate) transcript_output_location: ::std::option::Option<::std::string::String>,
    pub(crate) status: ::std::option::Option<crate::types::ClinicalNoteGenerationStatus>,
    pub(crate) failure_reason: ::std::option::Option<::std::string::String>,
}
impl ClinicalNoteGenerationResultBuilder {
    /// <p>Holds the Amazon S3 URI for the output Clinical Note.</p>
    pub fn clinical_note_output_location(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.clinical_note_output_location = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Holds the Amazon S3 URI for the output Clinical Note.</p>
    pub fn set_clinical_note_output_location(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.clinical_note_output_location = input;
        self
    }
    /// <p>Holds the Amazon S3 URI for the output Clinical Note.</p>
    pub fn get_clinical_note_output_location(&self) -> &::std::option::Option<::std::string::String> {
        &self.clinical_note_output_location
    }
    /// <p>Holds the Amazon S3 URI for the output Transcript.</p>
    pub fn transcript_output_location(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.transcript_output_location = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Holds the Amazon S3 URI for the output Transcript.</p>
    pub fn set_transcript_output_location(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.transcript_output_location = input;
        self
    }
    /// <p>Holds the Amazon S3 URI for the output Transcript.</p>
    pub fn get_transcript_output_location(&self) -> &::std::option::Option<::std::string::String> {
        &self.transcript_output_location
    }
    /// <p>The status of the clinical note generation.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul>
    /// <p>After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.</p>
    pub fn status(mut self, input: crate::types::ClinicalNoteGenerationStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the clinical note generation.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul>
    /// <p>After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::ClinicalNoteGenerationStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status of the clinical note generation.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul>
    /// <p>After audio streaming finishes, and you send a <code>MedicalScribeSessionControlEvent</code> event (with END_OF_SESSION as the Type), the status is set to <code>IN_PROGRESS</code>. If the status is <code>COMPLETED</code>, the analytics completed successfully, and you can find the results at the locations specified in <code>ClinicalNoteOutputLocation</code> and <code>TranscriptOutputLocation</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details about the failure.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::ClinicalNoteGenerationStatus> {
        &self.status
    }
    /// <p>If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.</p>
    pub fn failure_reason(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.failure_reason = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.</p>
    pub fn set_failure_reason(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.failure_reason = input;
        self
    }
    /// <p>If <code>ClinicalNoteGenerationResult</code> is <code>FAILED</code>, information about why it failed.</p>
    pub fn get_failure_reason(&self) -> &::std::option::Option<::std::string::String> {
        &self.failure_reason
    }
    /// Consumes the builder and constructs a [`ClinicalNoteGenerationResult`](crate::types::ClinicalNoteGenerationResult).
    pub fn build(self) -> crate::types::ClinicalNoteGenerationResult {
        crate::types::ClinicalNoteGenerationResult {
            clinical_note_output_location: self.clinical_note_output_location,
            transcript_output_location: self.transcript_output_location,
            status: self.status,
            failure_reason: self.failure_reason,
        }
    }
}
