// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`DeleteObjectTagging`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name containing the objects from which to remove the tags.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>S3 on Outposts</b> - When you use this action with S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts, the destination bucket must be the Outposts access point ARN or the access point alias. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::set_key):<br>required: **true**<br><p>The key that identifies the object in the bucket from which to remove all tags.</p><br>
    ///   - [`version_id(impl Into<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::version_id) / [`set_version_id(Option<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::set_version_id):<br>required: **false**<br><p>The versionId of the object that the tag-set will be removed from.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`DeleteObjectTaggingOutput`](crate::operation::delete_object_tagging::DeleteObjectTaggingOutput) with field(s):
    ///   - [`version_id(Option<String>)`](crate::operation::delete_object_tagging::DeleteObjectTaggingOutput::version_id): <p>The versionId of the object the tag-set was removed from.</p>
    /// - On failure, responds with [`SdkError<DeleteObjectTaggingError>`](crate::operation::delete_object_tagging::DeleteObjectTaggingError)
    pub fn delete_object_tagging(&self) -> crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder {
        crate::operation::delete_object_tagging::builders::DeleteObjectTaggingFluentBuilder::new(self.handle.clone())
    }
}
