// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_speech_synthesis_task::_get_speech_synthesis_task_output::GetSpeechSynthesisTaskOutputBuilder;

pub use crate::operation::get_speech_synthesis_task::_get_speech_synthesis_task_input::GetSpeechSynthesisTaskInputBuilder;

impl crate::operation::get_speech_synthesis_task::builders::GetSpeechSynthesisTaskInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_speech_synthesis_task();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetSpeechSynthesisTask`.
///
/// <p>Retrieves a specific SpeechSynthesisTask object based on its TaskID. This object contains information about the given speech synthesis task, including the status of the task, and a link to the S3 bucket containing the output of the task.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetSpeechSynthesisTaskFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_speech_synthesis_task::builders::GetSpeechSynthesisTaskInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskOutput,
        crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskError,
    > for GetSpeechSynthesisTaskFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskOutput,
            crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetSpeechSynthesisTaskFluentBuilder {
    /// Creates a new `GetSpeechSynthesisTaskFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetSpeechSynthesisTask as a reference.
    pub fn as_input(&self) -> &crate::operation::get_speech_synthesis_task::builders::GetSpeechSynthesisTaskInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTask::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTask::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskOutput,
        crate::operation::get_speech_synthesis_task::GetSpeechSynthesisTaskError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
    pub fn task_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.task_id(input.into());
        self
    }
    /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
    pub fn set_task_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_task_id(input);
        self
    }
    /// <p>The Amazon Polly generated identifier for a speech synthesis task.</p>
    pub fn get_task_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_task_id()
    }
}
