// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>Your request was throttled because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::types::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::types::error::InvalidArgumentException),
    /// <p>The specified client is invalid.</p>
    InvalidClientException(crate::types::error::InvalidClientException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::types::error::NotAuthorizedException),
    /// <p>The specified resource is not found.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>If the client session is expired. Once the client is connected, the session is valid for 45 minutes. Client should reconnect to the channel to continue sending/receiving messages.</p>
    SessionExpiredException(crate::types::error::SessionExpiredException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ClientLimitExceededException(inner) => inner.fmt(f),
            Error::InvalidArgumentException(inner) => inner.fmt(f),
            Error::InvalidClientException(inner) => inner.fmt(f),
            Error::NotAuthorizedException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::SessionExpiredException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::ClientLimitExceededException(inner) => inner.meta(),
            Self::InvalidArgumentException(inner) => inner.meta(),
            Self::InvalidClientException(inner) => inner.meta(),
            Self::NotAuthorizedException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::SessionExpiredException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_ice_server_config::GetIceServerConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_ice_server_config::GetIceServerConfigError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_ice_server_config::GetIceServerConfigError> for Error {
    fn from(err: crate::operation::get_ice_server_config::GetIceServerConfigError) -> Self {
        match err {
            crate::operation::get_ice_server_config::GetIceServerConfigError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::get_ice_server_config::GetIceServerConfigError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::get_ice_server_config::GetIceServerConfigError::InvalidClientException(inner) => Error::InvalidClientException(inner),
            crate::operation::get_ice_server_config::GetIceServerConfigError::NotAuthorizedException(inner) => Error::NotAuthorizedException(inner),
            crate::operation::get_ice_server_config::GetIceServerConfigError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::get_ice_server_config::GetIceServerConfigError::SessionExpiredException(inner) => Error::SessionExpiredException(inner),
            crate::operation::get_ice_server_config::GetIceServerConfigError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError> for Error {
    fn from(err: crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError) -> Self {
        match err {
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError::ClientLimitExceededException(inner) => {
                Error::ClientLimitExceededException(inner)
            }
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError::NotAuthorizedException(inner) => {
                Error::NotAuthorizedException(inner)
            }
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::ClientLimitExceededException(inner) => inner.source(),
            Error::InvalidArgumentException(inner) => inner.source(),
            Error::InvalidClientException(inner) => inner.source(),
            Error::NotAuthorizedException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::SessionExpiredException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::ClientLimitExceededException(e) => e.request_id(),
            Self::InvalidArgumentException(e) => e.request_id(),
            Self::InvalidClientException(e) => e.request_id(),
            Self::NotAuthorizedException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::SessionExpiredException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
