// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The structure that contains the information required to deliver a notification to a customer.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct NotificationDestinationConfig {
    /// <p>The Uniform Resource Identifier (URI) that identifies where the images will be delivered.</p>
    pub uri: ::std::string::String,
}
impl NotificationDestinationConfig {
    /// <p>The Uniform Resource Identifier (URI) that identifies where the images will be delivered.</p>
    pub fn uri(&self) -> &str {
        use std::ops::Deref;
        self.uri.deref()
    }
}
impl NotificationDestinationConfig {
    /// Creates a new builder-style object to manufacture [`NotificationDestinationConfig`](crate::types::NotificationDestinationConfig).
    pub fn builder() -> crate::types::builders::NotificationDestinationConfigBuilder {
        crate::types::builders::NotificationDestinationConfigBuilder::default()
    }
}

/// A builder for [`NotificationDestinationConfig`](crate::types::NotificationDestinationConfig).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct NotificationDestinationConfigBuilder {
    pub(crate) uri: ::std::option::Option<::std::string::String>,
}
impl NotificationDestinationConfigBuilder {
    /// <p>The Uniform Resource Identifier (URI) that identifies where the images will be delivered.</p>
    /// This field is required.
    pub fn uri(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.uri = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Uniform Resource Identifier (URI) that identifies where the images will be delivered.</p>
    pub fn set_uri(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.uri = input;
        self
    }
    /// <p>The Uniform Resource Identifier (URI) that identifies where the images will be delivered.</p>
    pub fn get_uri(&self) -> &::std::option::Option<::std::string::String> {
        &self.uri
    }
    /// Consumes the builder and constructs a [`NotificationDestinationConfig`](crate::types::NotificationDestinationConfig).
    /// This method will fail if any of the following fields are not set:
    /// - [`uri`](crate::types::builders::NotificationDestinationConfigBuilder::uri)
    pub fn build(self) -> ::std::result::Result<crate::types::NotificationDestinationConfig, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::NotificationDestinationConfig {
            uri: self.uri.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "uri",
                    "uri was not specified but it is required when building NotificationDestinationConfig",
                )
            })?,
        })
    }
}
