// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and <code>MediaUriType</code>) to access the media files that are streamed to the camera.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct MediaSourceConfig {
    /// <p>The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media file location.</p>
    pub media_uri_secret_arn: ::std::string::String,
    /// <p>The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media files.</p><note>
    /// <p>Preview only supports the <code>RTSP_URI</code> media source URI format .</p>
    /// </note>
    pub media_uri_type: crate::types::MediaUriType,
}
impl MediaSourceConfig {
    /// <p>The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media file location.</p>
    pub fn media_uri_secret_arn(&self) -> &str {
        use std::ops::Deref;
        self.media_uri_secret_arn.deref()
    }
    /// <p>The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media files.</p><note>
    /// <p>Preview only supports the <code>RTSP_URI</code> media source URI format .</p>
    /// </note>
    pub fn media_uri_type(&self) -> &crate::types::MediaUriType {
        &self.media_uri_type
    }
}
impl ::std::fmt::Debug for MediaSourceConfig {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("MediaSourceConfig");
        formatter.field("media_uri_secret_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("media_uri_type", &self.media_uri_type);
        formatter.finish()
    }
}
impl MediaSourceConfig {
    /// Creates a new builder-style object to manufacture [`MediaSourceConfig`](crate::types::MediaSourceConfig).
    pub fn builder() -> crate::types::builders::MediaSourceConfigBuilder {
        crate::types::builders::MediaSourceConfigBuilder::default()
    }
}

/// A builder for [`MediaSourceConfig`](crate::types::MediaSourceConfig).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct MediaSourceConfigBuilder {
    pub(crate) media_uri_secret_arn: ::std::option::Option<::std::string::String>,
    pub(crate) media_uri_type: ::std::option::Option<crate::types::MediaUriType>,
}
impl MediaSourceConfigBuilder {
    /// <p>The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media file location.</p>
    /// This field is required.
    pub fn media_uri_secret_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.media_uri_secret_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media file location.</p>
    pub fn set_media_uri_secret_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.media_uri_secret_arn = input;
        self
    }
    /// <p>The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media file location.</p>
    pub fn get_media_uri_secret_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.media_uri_secret_arn
    }
    /// <p>The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media files.</p><note>
    /// <p>Preview only supports the <code>RTSP_URI</code> media source URI format .</p>
    /// </note>
    /// This field is required.
    pub fn media_uri_type(mut self, input: crate::types::MediaUriType) -> Self {
        self.media_uri_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media files.</p><note>
    /// <p>Preview only supports the <code>RTSP_URI</code> media source URI format .</p>
    /// </note>
    pub fn set_media_uri_type(mut self, input: ::std::option::Option<crate::types::MediaUriType>) -> Self {
        self.media_uri_type = input;
        self
    }
    /// <p>The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media files.</p><note>
    /// <p>Preview only supports the <code>RTSP_URI</code> media source URI format .</p>
    /// </note>
    pub fn get_media_uri_type(&self) -> &::std::option::Option<crate::types::MediaUriType> {
        &self.media_uri_type
    }
    /// Consumes the builder and constructs a [`MediaSourceConfig`](crate::types::MediaSourceConfig).
    /// This method will fail if any of the following fields are not set:
    /// - [`media_uri_secret_arn`](crate::types::builders::MediaSourceConfigBuilder::media_uri_secret_arn)
    /// - [`media_uri_type`](crate::types::builders::MediaSourceConfigBuilder::media_uri_type)
    pub fn build(self) -> ::std::result::Result<crate::types::MediaSourceConfig, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MediaSourceConfig {
            media_uri_secret_arn: self.media_uri_secret_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "media_uri_secret_arn",
                    "media_uri_secret_arn was not specified but it is required when building MediaSourceConfig",
                )
            })?,
            media_uri_type: self.media_uri_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "media_uri_type",
                    "media_uri_type was not specified but it is required when building MediaSourceConfig",
                )
            })?,
        })
    }
}
impl ::std::fmt::Debug for MediaSourceConfigBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("MediaSourceConfigBuilder");
        formatter.field("media_uri_secret_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("media_uri_type", &self.media_uri_type);
        formatter.finish()
    }
}
