//
//Copyright 2023 Google LLC
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//https://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.23.4
// source: protos/wlmvalidation/wlmvalidation.proto

package wlmvalidation

import (
	configurablemetrics "github.com/GoogleCloudPlatform/workloadagentplatform/sharedprotos/configurablemetrics"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SapValidationType int32

const (
	SapValidationType_SAP_VALIDATION_TYPE_UNSPECIFIED SapValidationType = 0
	SapValidationType_SYSTEM                          SapValidationType = 1
	SapValidationType_COROSYNC                        SapValidationType = 2
	SapValidationType_HANA                            SapValidationType = 3
	SapValidationType_NETWEAVER                       SapValidationType = 4
	SapValidationType_PACEMAKER                       SapValidationType = 5
	SapValidationType_CUSTOM                          SapValidationType = 6
)

// Enum value maps for SapValidationType.
var (
	SapValidationType_name = map[int32]string{
		0: "SAP_VALIDATION_TYPE_UNSPECIFIED",
		1: "SYSTEM",
		2: "COROSYNC",
		3: "HANA",
		4: "NETWEAVER",
		5: "PACEMAKER",
		6: "CUSTOM",
	}
	SapValidationType_value = map[string]int32{
		"SAP_VALIDATION_TYPE_UNSPECIFIED": 0,
		"SYSTEM":                          1,
		"COROSYNC":                        2,
		"HANA":                            3,
		"NETWEAVER":                       4,
		"PACEMAKER":                       5,
		"CUSTOM":                          6,
	}
)

func (x SapValidationType) Enum() *SapValidationType {
	p := new(SapValidationType)
	*p = x
	return p
}

func (x SapValidationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapValidationType) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[0].Descriptor()
}

func (SapValidationType) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[0]
}

func (x SapValidationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapValidationType.Descriptor instead.
func (SapValidationType) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{0}
}

type SystemVariable int32

const (
	SystemVariable_SYSTEM_VARIABLE_UNSPECIFIED SystemVariable = 0
	SystemVariable_INSTANCE_NAME               SystemVariable = 1
	SystemVariable_OS_NAME_VERSION             SystemVariable = 2
	SystemVariable_AGENT_NAME                  SystemVariable = 3
	SystemVariable_AGENT_VERSION               SystemVariable = 4
	SystemVariable_NETWORK_IPS                 SystemVariable = 5
	SystemVariable_COLLECTION_CONFIG_VERSION   SystemVariable = 6
	SystemVariable_OS_SETTINGS                 SystemVariable = 7
	SystemVariable_APP_SERVER_ZONAL_SEPARATION SystemVariable = 8
	SystemVariable_HAS_APP_SERVER              SystemVariable = 9
	SystemVariable_HAS_ASCS                    SystemVariable = 10
	SystemVariable_HAS_ERS                     SystemVariable = 11
	SystemVariable_KERNEL_VERSION              SystemVariable = 12
)

// Enum value maps for SystemVariable.
var (
	SystemVariable_name = map[int32]string{
		0:  "SYSTEM_VARIABLE_UNSPECIFIED",
		1:  "INSTANCE_NAME",
		2:  "OS_NAME_VERSION",
		3:  "AGENT_NAME",
		4:  "AGENT_VERSION",
		5:  "NETWORK_IPS",
		6:  "COLLECTION_CONFIG_VERSION",
		7:  "OS_SETTINGS",
		8:  "APP_SERVER_ZONAL_SEPARATION",
		9:  "HAS_APP_SERVER",
		10: "HAS_ASCS",
		11: "HAS_ERS",
		12: "KERNEL_VERSION",
	}
	SystemVariable_value = map[string]int32{
		"SYSTEM_VARIABLE_UNSPECIFIED": 0,
		"INSTANCE_NAME":               1,
		"OS_NAME_VERSION":             2,
		"AGENT_NAME":                  3,
		"AGENT_VERSION":               4,
		"NETWORK_IPS":                 5,
		"COLLECTION_CONFIG_VERSION":   6,
		"OS_SETTINGS":                 7,
		"APP_SERVER_ZONAL_SEPARATION": 8,
		"HAS_APP_SERVER":              9,
		"HAS_ASCS":                    10,
		"HAS_ERS":                     11,
		"KERNEL_VERSION":              12,
	}
)

func (x SystemVariable) Enum() *SystemVariable {
	p := new(SystemVariable)
	*p = x
	return p
}

func (x SystemVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SystemVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[1].Descriptor()
}

func (SystemVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[1]
}

func (x SystemVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SystemVariable.Descriptor instead.
func (SystemVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{1}
}

type DiskVariable int32

const (
	DiskVariable_DISK_VARIABLE_UNSPECIFIED DiskVariable = 0
	DiskVariable_TYPE                      DiskVariable = 1
	DiskVariable_MOUNT                     DiskVariable = 2
	DiskVariable_SIZE                      DiskVariable = 3
	DiskVariable_PD_SIZE                   DiskVariable = 4
	DiskVariable_BLOCK_DEVICE              DiskVariable = 5
)

// Enum value maps for DiskVariable.
var (
	DiskVariable_name = map[int32]string{
		0: "DISK_VARIABLE_UNSPECIFIED",
		1: "TYPE",
		2: "MOUNT",
		3: "SIZE",
		4: "PD_SIZE",
		5: "BLOCK_DEVICE",
	}
	DiskVariable_value = map[string]int32{
		"DISK_VARIABLE_UNSPECIFIED": 0,
		"TYPE":                      1,
		"MOUNT":                     2,
		"SIZE":                      3,
		"PD_SIZE":                   4,
		"BLOCK_DEVICE":              5,
	}
)

func (x DiskVariable) Enum() *DiskVariable {
	p := new(DiskVariable)
	*p = x
	return p
}

func (x DiskVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[2].Descriptor()
}

func (DiskVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[2]
}

func (x DiskVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskVariable.Descriptor instead.
func (DiskVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{2}
}

type HANABackupVariable int32

const (
	HANABackupVariable_HANA_BACKUP_VARIABLE_UNSPECIFIED HANABackupVariable = 0
	HANABackupVariable_TENANT_NAME                      HANABackupVariable = 1
	HANABackupVariable_LAST_BACKUP_TIMESTAMP            HANABackupVariable = 2
	HANABackupVariable_DELTA_TENANT_NAME                HANABackupVariable = 3
	HANABackupVariable_LAST_DELTA_BACKUP_TIMESTAMP      HANABackupVariable = 4
	HANABackupVariable_SNAPSHOT_TENANT_NAME             HANABackupVariable = 5
	HANABackupVariable_LAST_SNAPSHOT_BACKUP_TIMESTAMP   HANABackupVariable = 6
)

// Enum value maps for HANABackupVariable.
var (
	HANABackupVariable_name = map[int32]string{
		0: "HANA_BACKUP_VARIABLE_UNSPECIFIED",
		1: "TENANT_NAME",
		2: "LAST_BACKUP_TIMESTAMP",
		3: "DELTA_TENANT_NAME",
		4: "LAST_DELTA_BACKUP_TIMESTAMP",
		5: "SNAPSHOT_TENANT_NAME",
		6: "LAST_SNAPSHOT_BACKUP_TIMESTAMP",
	}
	HANABackupVariable_value = map[string]int32{
		"HANA_BACKUP_VARIABLE_UNSPECIFIED": 0,
		"TENANT_NAME":                      1,
		"LAST_BACKUP_TIMESTAMP":            2,
		"DELTA_TENANT_NAME":                3,
		"LAST_DELTA_BACKUP_TIMESTAMP":      4,
		"SNAPSHOT_TENANT_NAME":             5,
		"LAST_SNAPSHOT_BACKUP_TIMESTAMP":   6,
	}
)

func (x HANABackupVariable) Enum() *HANABackupVariable {
	p := new(HANABackupVariable)
	*p = x
	return p
}

func (x HANABackupVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HANABackupVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[3].Descriptor()
}

func (HANABackupVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[3]
}

func (x HANABackupVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HANABackupVariable.Descriptor instead.
func (HANABackupVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{3}
}

type HANAHighAvailabilityVariable int32

const (
	HANAHighAvailabilityVariable_HA_VARIABLE_UNSPECIFIED HANAHighAvailabilityVariable = 0
	HANAHighAvailabilityVariable_HA_IN_SAME_ZONE         HANAHighAvailabilityVariable = 1
)

// Enum value maps for HANAHighAvailabilityVariable.
var (
	HANAHighAvailabilityVariable_name = map[int32]string{
		0: "HA_VARIABLE_UNSPECIFIED",
		1: "HA_IN_SAME_ZONE",
	}
	HANAHighAvailabilityVariable_value = map[string]int32{
		"HA_VARIABLE_UNSPECIFIED": 0,
		"HA_IN_SAME_ZONE":         1,
	}
)

func (x HANAHighAvailabilityVariable) Enum() *HANAHighAvailabilityVariable {
	p := new(HANAHighAvailabilityVariable)
	*p = x
	return p
}

func (x HANAHighAvailabilityVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HANAHighAvailabilityVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[4].Descriptor()
}

func (HANAHighAvailabilityVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[4]
}

func (x HANAHighAvailabilityVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HANAHighAvailabilityVariable.Descriptor instead.
func (HANAHighAvailabilityVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{4}
}

type HANADisasterRecoveryVariable int32

const (
	HANADisasterRecoveryVariable_DR_VARIABLE_UNSPECIFIED HANADisasterRecoveryVariable = 0
	HANADisasterRecoveryVariable_DR_IN_SAME_REGION       HANADisasterRecoveryVariable = 1
)

// Enum value maps for HANADisasterRecoveryVariable.
var (
	HANADisasterRecoveryVariable_name = map[int32]string{
		0: "DR_VARIABLE_UNSPECIFIED",
		1: "DR_IN_SAME_REGION",
	}
	HANADisasterRecoveryVariable_value = map[string]int32{
		"DR_VARIABLE_UNSPECIFIED": 0,
		"DR_IN_SAME_REGION":       1,
	}
)

func (x HANADisasterRecoveryVariable) Enum() *HANADisasterRecoveryVariable {
	p := new(HANADisasterRecoveryVariable)
	*p = x
	return p
}

func (x HANADisasterRecoveryVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HANADisasterRecoveryVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[5].Descriptor()
}

func (HANADisasterRecoveryVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[5]
}

func (x HANADisasterRecoveryVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HANADisasterRecoveryVariable.Descriptor instead.
func (HANADisasterRecoveryVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{5}
}

type PrimitiveVariable int32

const (
	PrimitiveVariable_PRIMITIVE_VARIABLE_UNSPECIFIED    PrimitiveVariable = 0
	PrimitiveVariable_PCMK_DELAY_BASE                   PrimitiveVariable = 1
	PrimitiveVariable_PCMK_DELAY_MAX                    PrimitiveVariable = 2
	PrimitiveVariable_PCMK_MONITOR_RETRIES              PrimitiveVariable = 3
	PrimitiveVariable_PCMK_REBOOT_TIMEOUT               PrimitiveVariable = 4
	PrimitiveVariable_SAPHANA_NOTIFY                    PrimitiveVariable = 5
	PrimitiveVariable_SAPHANA_CLONE_MAX                 PrimitiveVariable = 6
	PrimitiveVariable_SAPHANA_CLONE_NODE_MAX            PrimitiveVariable = 7
	PrimitiveVariable_SAPHANA_INTERLEAVE                PrimitiveVariable = 8
	PrimitiveVariable_SAPHANATOPOLOGY_CLONE_NODE_MAX    PrimitiveVariable = 9
	PrimitiveVariable_SAPHANATOPOLOGY_INTERLEAVE        PrimitiveVariable = 10
	PrimitiveVariable_SAPHANA_AUTOMATED_REGISTER        PrimitiveVariable = 11
	PrimitiveVariable_SAPHANA_DUPLICATE_PRIMARY_TIMEOUT PrimitiveVariable = 12
	PrimitiveVariable_SAPHANA_PREFER_SITE_TAKEOVER      PrimitiveVariable = 13
	PrimitiveVariable_HEALTHCHECK_MONITOR_INTERVAL      PrimitiveVariable = 14
	PrimitiveVariable_HEALTHCHECK_MONITOR_TIMEOUT       PrimitiveVariable = 15
	PrimitiveVariable_ILB_MONITOR_INTERVAL              PrimitiveVariable = 16
	PrimitiveVariable_ILB_MONITOR_TIMEOUT               PrimitiveVariable = 17
	PrimitiveVariable_HAS_ALIAS_IP                      PrimitiveVariable = 18
	PrimitiveVariable_CLUSTER_HEALTHY                   PrimitiveVariable = 19
)

// Enum value maps for PrimitiveVariable.
var (
	PrimitiveVariable_name = map[int32]string{
		0:  "PRIMITIVE_VARIABLE_UNSPECIFIED",
		1:  "PCMK_DELAY_BASE",
		2:  "PCMK_DELAY_MAX",
		3:  "PCMK_MONITOR_RETRIES",
		4:  "PCMK_REBOOT_TIMEOUT",
		5:  "SAPHANA_NOTIFY",
		6:  "SAPHANA_CLONE_MAX",
		7:  "SAPHANA_CLONE_NODE_MAX",
		8:  "SAPHANA_INTERLEAVE",
		9:  "SAPHANATOPOLOGY_CLONE_NODE_MAX",
		10: "SAPHANATOPOLOGY_INTERLEAVE",
		11: "SAPHANA_AUTOMATED_REGISTER",
		12: "SAPHANA_DUPLICATE_PRIMARY_TIMEOUT",
		13: "SAPHANA_PREFER_SITE_TAKEOVER",
		14: "HEALTHCHECK_MONITOR_INTERVAL",
		15: "HEALTHCHECK_MONITOR_TIMEOUT",
		16: "ILB_MONITOR_INTERVAL",
		17: "ILB_MONITOR_TIMEOUT",
		18: "HAS_ALIAS_IP",
		19: "CLUSTER_HEALTHY",
	}
	PrimitiveVariable_value = map[string]int32{
		"PRIMITIVE_VARIABLE_UNSPECIFIED":    0,
		"PCMK_DELAY_BASE":                   1,
		"PCMK_DELAY_MAX":                    2,
		"PCMK_MONITOR_RETRIES":              3,
		"PCMK_REBOOT_TIMEOUT":               4,
		"SAPHANA_NOTIFY":                    5,
		"SAPHANA_CLONE_MAX":                 6,
		"SAPHANA_CLONE_NODE_MAX":            7,
		"SAPHANA_INTERLEAVE":                8,
		"SAPHANATOPOLOGY_CLONE_NODE_MAX":    9,
		"SAPHANATOPOLOGY_INTERLEAVE":        10,
		"SAPHANA_AUTOMATED_REGISTER":        11,
		"SAPHANA_DUPLICATE_PRIMARY_TIMEOUT": 12,
		"SAPHANA_PREFER_SITE_TAKEOVER":      13,
		"HEALTHCHECK_MONITOR_INTERVAL":      14,
		"HEALTHCHECK_MONITOR_TIMEOUT":       15,
		"ILB_MONITOR_INTERVAL":              16,
		"ILB_MONITOR_TIMEOUT":               17,
		"HAS_ALIAS_IP":                      18,
		"CLUSTER_HEALTHY":                   19,
	}
)

func (x PrimitiveVariable) Enum() *PrimitiveVariable {
	p := new(PrimitiveVariable)
	*p = x
	return p
}

func (x PrimitiveVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrimitiveVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[6].Descriptor()
}

func (PrimitiveVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[6]
}

func (x PrimitiveVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrimitiveVariable.Descriptor instead.
func (PrimitiveVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{6}
}

type RSCLocationVariable int32

const (
	RSCLocationVariable_RSC_LOCATION_VARIABLE_UNSPECIFIED RSCLocationVariable = 0
	RSCLocationVariable_LOCATION_PREFERENCE_SET           RSCLocationVariable = 1
)

// Enum value maps for RSCLocationVariable.
var (
	RSCLocationVariable_name = map[int32]string{
		0: "RSC_LOCATION_VARIABLE_UNSPECIFIED",
		1: "LOCATION_PREFERENCE_SET",
	}
	RSCLocationVariable_value = map[string]int32{
		"RSC_LOCATION_VARIABLE_UNSPECIFIED": 0,
		"LOCATION_PREFERENCE_SET":           1,
	}
)

func (x RSCLocationVariable) Enum() *RSCLocationVariable {
	p := new(RSCLocationVariable)
	*p = x
	return p
}

func (x RSCLocationVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RSCLocationVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[7].Descriptor()
}

func (RSCLocationVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[7]
}

func (x RSCLocationVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RSCLocationVariable.Descriptor instead.
func (RSCLocationVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{7}
}

type RSCOptionVariable int32

const (
	RSCOptionVariable_RSC_OPTION_VARIABLE_UNSPECIFIED RSCOptionVariable = 0
	RSCOptionVariable_MIGRATION_THRESHOLD             RSCOptionVariable = 1
	RSCOptionVariable_RESOURCE_STICKINESS             RSCOptionVariable = 2
)

// Enum value maps for RSCOptionVariable.
var (
	RSCOptionVariable_name = map[int32]string{
		0: "RSC_OPTION_VARIABLE_UNSPECIFIED",
		1: "MIGRATION_THRESHOLD",
		2: "RESOURCE_STICKINESS",
	}
	RSCOptionVariable_value = map[string]int32{
		"RSC_OPTION_VARIABLE_UNSPECIFIED": 0,
		"MIGRATION_THRESHOLD":             1,
		"RESOURCE_STICKINESS":             2,
	}
)

func (x RSCOptionVariable) Enum() *RSCOptionVariable {
	p := new(RSCOptionVariable)
	*p = x
	return p
}

func (x RSCOptionVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RSCOptionVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[8].Descriptor()
}

func (RSCOptionVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[8]
}

func (x RSCOptionVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RSCOptionVariable.Descriptor instead.
func (RSCOptionVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{8}
}

type HANAOperationVariable int32

const (
	HANAOperationVariable_HANA_OPERATION_VARIABLE_UNSPECIFIED HANAOperationVariable = 0
	HANAOperationVariable_SAPHANA_START_TIMEOUT               HANAOperationVariable = 1
	HANAOperationVariable_SAPHANA_STOP_TIMEOUT                HANAOperationVariable = 2
	HANAOperationVariable_SAPHANA_PROMOTE_TIMEOUT             HANAOperationVariable = 3
	HANAOperationVariable_SAPHANA_DEMOTE_TIMEOUT              HANAOperationVariable = 4
	HANAOperationVariable_SAPHANATOPOLOGY_MONITOR_INTERVAL    HANAOperationVariable = 5
	HANAOperationVariable_SAPHANATOPOLOGY_MONITOR_TIMEOUT     HANAOperationVariable = 6
	HANAOperationVariable_SAPHANATOPOLOGY_START_TIMEOUT       HANAOperationVariable = 7
	HANAOperationVariable_SAPHANATOPOLOGY_STOP_TIMEOUT        HANAOperationVariable = 8
	HANAOperationVariable_SAPHANA_PRIMARY_MONITOR_INTERVAL    HANAOperationVariable = 9
	HANAOperationVariable_SAPHANA_PRIMARY_MONITOR_TIMEOUT     HANAOperationVariable = 10
	HANAOperationVariable_SAPHANA_SECONDARY_MONITOR_INTERVAL  HANAOperationVariable = 11
	HANAOperationVariable_SAPHANA_SECONDARY_MONITOR_TIMEOUT   HANAOperationVariable = 12
)

// Enum value maps for HANAOperationVariable.
var (
	HANAOperationVariable_name = map[int32]string{
		0:  "HANA_OPERATION_VARIABLE_UNSPECIFIED",
		1:  "SAPHANA_START_TIMEOUT",
		2:  "SAPHANA_STOP_TIMEOUT",
		3:  "SAPHANA_PROMOTE_TIMEOUT",
		4:  "SAPHANA_DEMOTE_TIMEOUT",
		5:  "SAPHANATOPOLOGY_MONITOR_INTERVAL",
		6:  "SAPHANATOPOLOGY_MONITOR_TIMEOUT",
		7:  "SAPHANATOPOLOGY_START_TIMEOUT",
		8:  "SAPHANATOPOLOGY_STOP_TIMEOUT",
		9:  "SAPHANA_PRIMARY_MONITOR_INTERVAL",
		10: "SAPHANA_PRIMARY_MONITOR_TIMEOUT",
		11: "SAPHANA_SECONDARY_MONITOR_INTERVAL",
		12: "SAPHANA_SECONDARY_MONITOR_TIMEOUT",
	}
	HANAOperationVariable_value = map[string]int32{
		"HANA_OPERATION_VARIABLE_UNSPECIFIED": 0,
		"SAPHANA_START_TIMEOUT":               1,
		"SAPHANA_STOP_TIMEOUT":                2,
		"SAPHANA_PROMOTE_TIMEOUT":             3,
		"SAPHANA_DEMOTE_TIMEOUT":              4,
		"SAPHANATOPOLOGY_MONITOR_INTERVAL":    5,
		"SAPHANATOPOLOGY_MONITOR_TIMEOUT":     6,
		"SAPHANATOPOLOGY_START_TIMEOUT":       7,
		"SAPHANATOPOLOGY_STOP_TIMEOUT":        8,
		"SAPHANA_PRIMARY_MONITOR_INTERVAL":    9,
		"SAPHANA_PRIMARY_MONITOR_TIMEOUT":     10,
		"SAPHANA_SECONDARY_MONITOR_INTERVAL":  11,
		"SAPHANA_SECONDARY_MONITOR_TIMEOUT":   12,
	}
)

func (x HANAOperationVariable) Enum() *HANAOperationVariable {
	p := new(HANAOperationVariable)
	*p = x
	return p
}

func (x HANAOperationVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HANAOperationVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[9].Descriptor()
}

func (HANAOperationVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[9]
}

func (x HANAOperationVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HANAOperationVariable.Descriptor instead.
func (HANAOperationVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{9}
}

type FenceAgentVariable int32

const (
	FenceAgentVariable_FENCE_AGENT_VARIABLE_UNSPECIFIED FenceAgentVariable = 0
	FenceAgentVariable_FENCE_AGENT                      FenceAgentVariable = 1
	FenceAgentVariable_COMPUTE_API_ACCESS               FenceAgentVariable = 2
	FenceAgentVariable_LOGGING_API_ACCESS               FenceAgentVariable = 3
)

// Enum value maps for FenceAgentVariable.
var (
	FenceAgentVariable_name = map[int32]string{
		0: "FENCE_AGENT_VARIABLE_UNSPECIFIED",
		1: "FENCE_AGENT",
		2: "COMPUTE_API_ACCESS",
		3: "LOGGING_API_ACCESS",
	}
	FenceAgentVariable_value = map[string]int32{
		"FENCE_AGENT_VARIABLE_UNSPECIFIED": 0,
		"FENCE_AGENT":                      1,
		"COMPUTE_API_ACCESS":               2,
		"LOGGING_API_ACCESS":               3,
	}
)

func (x FenceAgentVariable) Enum() *FenceAgentVariable {
	p := new(FenceAgentVariable)
	*p = x
	return p
}

func (x FenceAgentVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FenceAgentVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[10].Descriptor()
}

func (FenceAgentVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[10]
}

func (x FenceAgentVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FenceAgentVariable.Descriptor instead.
func (FenceAgentVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{10}
}

type ASCSVariable int32

const (
	ASCSVariable_ASCS_VARIABLE_UNSPECIFIED         ASCSVariable = 0
	ASCSVariable_ASCS_FAILURE_TIMEOUT              ASCSVariable = 1
	ASCSVariable_ASCS_MIGRATION_THRESHOLD          ASCSVariable = 2
	ASCSVariable_ASCS_RESOURCE_STICKINESS          ASCSVariable = 3
	ASCSVariable_ASCS_INSTANCE                     ASCSVariable = 4
	ASCSVariable_ENQUEUE_SERVER                    ASCSVariable = 5
	ASCSVariable_ERS_INSTANCE                      ASCSVariable = 6
	ASCSVariable_IS_ERS                            ASCSVariable = 7
	ASCSVariable_ASCS_AUTOMATIC_RECOVER            ASCSVariable = 8
	ASCSVariable_ASCS_MONITOR_INTERVAL             ASCSVariable = 9
	ASCSVariable_ASCS_MONITOR_TIMEOUT              ASCSVariable = 10
	ASCSVariable_ERS_AUTOMATIC_RECOVER             ASCSVariable = 11
	ASCSVariable_ERS_MONITOR_INTERVAL              ASCSVariable = 12
	ASCSVariable_ERS_MONITOR_TIMEOUT               ASCSVariable = 13
	ASCSVariable_ASCS_HEALTHCHECK_MONITOR_INTERVAL ASCSVariable = 14
	ASCSVariable_ASCS_HEALTHCHECK_MONITOR_TIMEOUT  ASCSVariable = 15
	ASCSVariable_ASCS_ILB_MONITOR_INTERVAL         ASCSVariable = 16
	ASCSVariable_ASCS_ILB_MONITOR_TIMEOUT          ASCSVariable = 17
	ASCSVariable_ERS_HEALTHCHECK_MONITOR_INTERVAL  ASCSVariable = 18
	ASCSVariable_ERS_HEALTHCHECK_MONITOR_TIMEOUT   ASCSVariable = 19
	ASCSVariable_ERS_ILB_MONITOR_INTERVAL          ASCSVariable = 20
	ASCSVariable_ERS_ILB_MONITOR_TIMEOUT           ASCSVariable = 21
	ASCSVariable_ENSA2_CAPABLE                     ASCSVariable = 22
	ASCSVariable_ASCS_IP                           ASCSVariable = 23
	ASCSVariable_ERS_IP                            ASCSVariable = 24
	ASCSVariable_ASCS_VIRTUAL_IP                   ASCSVariable = 25
	ASCSVariable_ERS_VIRTUAL_IP                    ASCSVariable = 26
)

// Enum value maps for ASCSVariable.
var (
	ASCSVariable_name = map[int32]string{
		0:  "ASCS_VARIABLE_UNSPECIFIED",
		1:  "ASCS_FAILURE_TIMEOUT",
		2:  "ASCS_MIGRATION_THRESHOLD",
		3:  "ASCS_RESOURCE_STICKINESS",
		4:  "ASCS_INSTANCE",
		5:  "ENQUEUE_SERVER",
		6:  "ERS_INSTANCE",
		7:  "IS_ERS",
		8:  "ASCS_AUTOMATIC_RECOVER",
		9:  "ASCS_MONITOR_INTERVAL",
		10: "ASCS_MONITOR_TIMEOUT",
		11: "ERS_AUTOMATIC_RECOVER",
		12: "ERS_MONITOR_INTERVAL",
		13: "ERS_MONITOR_TIMEOUT",
		14: "ASCS_HEALTHCHECK_MONITOR_INTERVAL",
		15: "ASCS_HEALTHCHECK_MONITOR_TIMEOUT",
		16: "ASCS_ILB_MONITOR_INTERVAL",
		17: "ASCS_ILB_MONITOR_TIMEOUT",
		18: "ERS_HEALTHCHECK_MONITOR_INTERVAL",
		19: "ERS_HEALTHCHECK_MONITOR_TIMEOUT",
		20: "ERS_ILB_MONITOR_INTERVAL",
		21: "ERS_ILB_MONITOR_TIMEOUT",
		22: "ENSA2_CAPABLE",
		23: "ASCS_IP",
		24: "ERS_IP",
		25: "ASCS_VIRTUAL_IP",
		26: "ERS_VIRTUAL_IP",
	}
	ASCSVariable_value = map[string]int32{
		"ASCS_VARIABLE_UNSPECIFIED":         0,
		"ASCS_FAILURE_TIMEOUT":              1,
		"ASCS_MIGRATION_THRESHOLD":          2,
		"ASCS_RESOURCE_STICKINESS":          3,
		"ASCS_INSTANCE":                     4,
		"ENQUEUE_SERVER":                    5,
		"ERS_INSTANCE":                      6,
		"IS_ERS":                            7,
		"ASCS_AUTOMATIC_RECOVER":            8,
		"ASCS_MONITOR_INTERVAL":             9,
		"ASCS_MONITOR_TIMEOUT":              10,
		"ERS_AUTOMATIC_RECOVER":             11,
		"ERS_MONITOR_INTERVAL":              12,
		"ERS_MONITOR_TIMEOUT":               13,
		"ASCS_HEALTHCHECK_MONITOR_INTERVAL": 14,
		"ASCS_HEALTHCHECK_MONITOR_TIMEOUT":  15,
		"ASCS_ILB_MONITOR_INTERVAL":         16,
		"ASCS_ILB_MONITOR_TIMEOUT":          17,
		"ERS_HEALTHCHECK_MONITOR_INTERVAL":  18,
		"ERS_HEALTHCHECK_MONITOR_TIMEOUT":   19,
		"ERS_ILB_MONITOR_INTERVAL":          20,
		"ERS_ILB_MONITOR_TIMEOUT":           21,
		"ENSA2_CAPABLE":                     22,
		"ASCS_IP":                           23,
		"ERS_IP":                            24,
		"ASCS_VIRTUAL_IP":                   25,
		"ERS_VIRTUAL_IP":                    26,
	}
)

func (x ASCSVariable) Enum() *ASCSVariable {
	p := new(ASCSVariable)
	*p = x
	return p
}

func (x ASCSVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ASCSVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[11].Descriptor()
}

func (ASCSVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[11]
}

func (x ASCSVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ASCSVariable.Descriptor instead.
func (ASCSVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{11}
}

type CIBBootstrapOptionVariable int32

const (
	CIBBootstrapOptionVariable_CIB_BOOTSTRAP_OPTION_VARIABLE_UNSPECIFIED CIBBootstrapOptionVariable = 0
	CIBBootstrapOptionVariable_MAINTENANCE_MODE_ACTIVE                   CIBBootstrapOptionVariable = 1
	CIBBootstrapOptionVariable_STONITH_ENABLED                           CIBBootstrapOptionVariable = 2
	CIBBootstrapOptionVariable_STONITH_TIMEOUT                           CIBBootstrapOptionVariable = 3
)

// Enum value maps for CIBBootstrapOptionVariable.
var (
	CIBBootstrapOptionVariable_name = map[int32]string{
		0: "CIB_BOOTSTRAP_OPTION_VARIABLE_UNSPECIFIED",
		1: "MAINTENANCE_MODE_ACTIVE",
		2: "STONITH_ENABLED",
		3: "STONITH_TIMEOUT",
	}
	CIBBootstrapOptionVariable_value = map[string]int32{
		"CIB_BOOTSTRAP_OPTION_VARIABLE_UNSPECIFIED": 0,
		"MAINTENANCE_MODE_ACTIVE":                   1,
		"STONITH_ENABLED":                           2,
		"STONITH_TIMEOUT":                           3,
	}
)

func (x CIBBootstrapOptionVariable) Enum() *CIBBootstrapOptionVariable {
	p := new(CIBBootstrapOptionVariable)
	*p = x
	return p
}

func (x CIBBootstrapOptionVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CIBBootstrapOptionVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[12].Descriptor()
}

func (CIBBootstrapOptionVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[12]
}

func (x CIBBootstrapOptionVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CIBBootstrapOptionVariable.Descriptor instead.
func (CIBBootstrapOptionVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{12}
}

type OPOptionVariable int32

const (
	OPOptionVariable_OP_OPTION_VARIABLE_UNSPECIFIED OPOptionVariable = 0
	OPOptionVariable_OP_TIMEOUT                     OPOptionVariable = 1
)

// Enum value maps for OPOptionVariable.
var (
	OPOptionVariable_name = map[int32]string{
		0: "OP_OPTION_VARIABLE_UNSPECIFIED",
		1: "OP_TIMEOUT",
	}
	OPOptionVariable_value = map[string]int32{
		"OP_OPTION_VARIABLE_UNSPECIFIED": 0,
		"OP_TIMEOUT":                     1,
	}
)

func (x OPOptionVariable) Enum() *OPOptionVariable {
	p := new(OPOptionVariable)
	*p = x
	return p
}

func (x OPOptionVariable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OPOptionVariable) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[13].Descriptor()
}

func (OPOptionVariable) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[13]
}

func (x OPOptionVariable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OPOptionVariable.Descriptor instead.
func (OPOptionVariable) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{13}
}

type HANADiskVolumeMetricSource int32

const (
	HANADiskVolumeMetricSource_HANA_DISK_VOLUME_METRIC_SOURCE_UNSPECIFIED HANADiskVolumeMetricSource = 0
	HANADiskVolumeMetricSource_GLOBAL_INI                                 HANADiskVolumeMetricSource = 1
	HANADiskVolumeMetricSource_HDB_INDEXSERVER_PATH                       HANADiskVolumeMetricSource = 2
	HANADiskVolumeMetricSource_DIR_INSTANCE_ENV                           HANADiskVolumeMetricSource = 3
)

// Enum value maps for HANADiskVolumeMetricSource.
var (
	HANADiskVolumeMetricSource_name = map[int32]string{
		0: "HANA_DISK_VOLUME_METRIC_SOURCE_UNSPECIFIED",
		1: "GLOBAL_INI",
		2: "HDB_INDEXSERVER_PATH",
		3: "DIR_INSTANCE_ENV",
	}
	HANADiskVolumeMetricSource_value = map[string]int32{
		"HANA_DISK_VOLUME_METRIC_SOURCE_UNSPECIFIED": 0,
		"GLOBAL_INI":           1,
		"HDB_INDEXSERVER_PATH": 2,
		"DIR_INSTANCE_ENV":     3,
	}
)

func (x HANADiskVolumeMetricSource) Enum() *HANADiskVolumeMetricSource {
	p := new(HANADiskVolumeMetricSource)
	*p = x
	return p
}

func (x HANADiskVolumeMetricSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HANADiskVolumeMetricSource) Descriptor() protoreflect.EnumDescriptor {
	return file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[14].Descriptor()
}

func (HANADiskVolumeMetricSource) Type() protoreflect.EnumType {
	return &file_protos_wlmvalidation_wlmvalidation_proto_enumTypes[14]
}

func (x HANADiskVolumeMetricSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HANADiskVolumeMetricSource.Descriptor instead.
func (HANADiskVolumeMetricSource) EnumDescriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{14}
}

type WorkloadValidation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ValidationSystem    *ValidationSystem    `protobuf:"bytes,1,opt,name=validation_system,json=validationSystem,proto3" json:"validation_system,omitempty"`
	ValidationCorosync  *ValidationCorosync  `protobuf:"bytes,2,opt,name=validation_corosync,json=validationCorosync,proto3" json:"validation_corosync,omitempty"`
	ValidationHana      *ValidationHANA      `protobuf:"bytes,3,opt,name=validation_hana,json=validationHana,proto3" json:"validation_hana,omitempty"`
	ValidationNetweaver *ValidationNetweaver `protobuf:"bytes,4,opt,name=validation_netweaver,json=validationNetweaver,proto3" json:"validation_netweaver,omitempty"`
	ValidationPacemaker *ValidationPacemaker `protobuf:"bytes,5,opt,name=validation_pacemaker,json=validationPacemaker,proto3" json:"validation_pacemaker,omitempty"`
	ValidationCustom    *ValidationCustom    `protobuf:"bytes,6,opt,name=validation_custom,json=validationCustom,proto3" json:"validation_custom,omitempty"`
	// Track the version of the workload validation config distributed for the
	// Agent for SAP by the SAP Core Eng team. This field is intended for logging
	// and debugging purposes only, and will be ignored if set in a customer
	// defined collection definition config.
	Version int64 `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *WorkloadValidation) Reset() {
	*x = WorkloadValidation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadValidation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadValidation) ProtoMessage() {}

func (x *WorkloadValidation) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadValidation.ProtoReflect.Descriptor instead.
func (*WorkloadValidation) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{0}
}

func (x *WorkloadValidation) GetValidationSystem() *ValidationSystem {
	if x != nil {
		return x.ValidationSystem
	}
	return nil
}

func (x *WorkloadValidation) GetValidationCorosync() *ValidationCorosync {
	if x != nil {
		return x.ValidationCorosync
	}
	return nil
}

func (x *WorkloadValidation) GetValidationHana() *ValidationHANA {
	if x != nil {
		return x.ValidationHana
	}
	return nil
}

func (x *WorkloadValidation) GetValidationNetweaver() *ValidationNetweaver {
	if x != nil {
		return x.ValidationNetweaver
	}
	return nil
}

func (x *WorkloadValidation) GetValidationPacemaker() *ValidationPacemaker {
	if x != nil {
		return x.ValidationPacemaker
	}
	return nil
}

func (x *WorkloadValidation) GetValidationCustom() *ValidationCustom {
	if x != nil {
		return x.ValidationCustom
	}
	return nil
}

func (x *WorkloadValidation) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

type ValidationSystem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SystemMetrics    []*SystemMetric                        `protobuf:"bytes,1,rep,name=system_metrics,json=systemMetrics,proto3" json:"system_metrics,omitempty"`
	OsCommandMetrics []*configurablemetrics.OSCommandMetric `protobuf:"bytes,2,rep,name=os_command_metrics,json=osCommandMetrics,proto3" json:"os_command_metrics,omitempty"`
}

func (x *ValidationSystem) Reset() {
	*x = ValidationSystem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationSystem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationSystem) ProtoMessage() {}

func (x *ValidationSystem) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationSystem.ProtoReflect.Descriptor instead.
func (*ValidationSystem) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{1}
}

func (x *ValidationSystem) GetSystemMetrics() []*SystemMetric {
	if x != nil {
		return x.SystemMetrics
	}
	return nil
}

func (x *ValidationSystem) GetOsCommandMetrics() []*configurablemetrics.OSCommandMetric {
	if x != nil {
		return x.OsCommandMetrics
	}
	return nil
}

type SystemMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      SystemVariable                  `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.SystemVariable" json:"value,omitempty"`
}

func (x *SystemMetric) Reset() {
	*x = SystemMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SystemMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystemMetric) ProtoMessage() {}

func (x *SystemMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystemMetric.ProtoReflect.Descriptor instead.
func (*SystemMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{2}
}

func (x *SystemMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *SystemMetric) GetValue() SystemVariable {
	if x != nil {
		return x.Value
	}
	return SystemVariable_SYSTEM_VARIABLE_UNSPECIFIED
}

type ValidationCorosync struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigPath       string                                 `protobuf:"bytes,1,opt,name=config_path,json=configPath,proto3" json:"config_path,omitempty"`
	ConfigMetrics    []*configurablemetrics.EvalMetric      `protobuf:"bytes,2,rep,name=config_metrics,json=configMetrics,proto3" json:"config_metrics,omitempty"`
	OsCommandMetrics []*configurablemetrics.OSCommandMetric `protobuf:"bytes,3,rep,name=os_command_metrics,json=osCommandMetrics,proto3" json:"os_command_metrics,omitempty"`
}

func (x *ValidationCorosync) Reset() {
	*x = ValidationCorosync{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationCorosync) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationCorosync) ProtoMessage() {}

func (x *ValidationCorosync) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationCorosync.ProtoReflect.Descriptor instead.
func (*ValidationCorosync) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{3}
}

func (x *ValidationCorosync) GetConfigPath() string {
	if x != nil {
		return x.ConfigPath
	}
	return ""
}

func (x *ValidationCorosync) GetConfigMetrics() []*configurablemetrics.EvalMetric {
	if x != nil {
		return x.ConfigMetrics
	}
	return nil
}

func (x *ValidationCorosync) GetOsCommandMetrics() []*configurablemetrics.OSCommandMetric {
	if x != nil {
		return x.OsCommandMetrics
	}
	return nil
}

type ValidationHANA struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GlobalIniMetrics      []*configurablemetrics.EvalMetric      `protobuf:"bytes,1,rep,name=global_ini_metrics,json=globalIniMetrics,proto3" json:"global_ini_metrics,omitempty"`
	HanaDiskVolumeMetrics []*HANADiskVolumeMetric                `protobuf:"bytes,2,rep,name=hana_disk_volume_metrics,json=hanaDiskVolumeMetrics,proto3" json:"hana_disk_volume_metrics,omitempty"`
	OsCommandMetrics      []*configurablemetrics.OSCommandMetric `protobuf:"bytes,3,rep,name=os_command_metrics,json=osCommandMetrics,proto3" json:"os_command_metrics,omitempty"`
	HaMetrics             []*HANAHighAvailabilityMetric          `protobuf:"bytes,4,rep,name=ha_metrics,json=haMetrics,proto3" json:"ha_metrics,omitempty"`
	IndexserverIniMetrics []*configurablemetrics.EvalMetric      `protobuf:"bytes,5,rep,name=indexserver_ini_metrics,json=indexserverIniMetrics,proto3" json:"indexserver_ini_metrics,omitempty"`
	HanaBackupMetrics     []*HANABackupMetric                    `protobuf:"bytes,6,rep,name=hana_backup_metrics,json=hanaBackupMetrics,proto3" json:"hana_backup_metrics,omitempty"`
	DrMetrics             []*HANADisasterRecoveryMetric          `protobuf:"bytes,7,rep,name=dr_metrics,json=drMetrics,proto3" json:"dr_metrics,omitempty"`
}

func (x *ValidationHANA) Reset() {
	*x = ValidationHANA{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationHANA) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationHANA) ProtoMessage() {}

func (x *ValidationHANA) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationHANA.ProtoReflect.Descriptor instead.
func (*ValidationHANA) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{4}
}

func (x *ValidationHANA) GetGlobalIniMetrics() []*configurablemetrics.EvalMetric {
	if x != nil {
		return x.GlobalIniMetrics
	}
	return nil
}

func (x *ValidationHANA) GetHanaDiskVolumeMetrics() []*HANADiskVolumeMetric {
	if x != nil {
		return x.HanaDiskVolumeMetrics
	}
	return nil
}

func (x *ValidationHANA) GetOsCommandMetrics() []*configurablemetrics.OSCommandMetric {
	if x != nil {
		return x.OsCommandMetrics
	}
	return nil
}

func (x *ValidationHANA) GetHaMetrics() []*HANAHighAvailabilityMetric {
	if x != nil {
		return x.HaMetrics
	}
	return nil
}

func (x *ValidationHANA) GetIndexserverIniMetrics() []*configurablemetrics.EvalMetric {
	if x != nil {
		return x.IndexserverIniMetrics
	}
	return nil
}

func (x *ValidationHANA) GetHanaBackupMetrics() []*HANABackupMetric {
	if x != nil {
		return x.HanaBackupMetrics
	}
	return nil
}

func (x *ValidationHANA) GetDrMetrics() []*HANADisasterRecoveryMetric {
	if x != nil {
		return x.DrMetrics
	}
	return nil
}

type HANADiskVolumeMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BasepathVolume string                     `protobuf:"bytes,1,opt,name=basepath_volume,json=basepathVolume,proto3" json:"basepath_volume,omitempty"`
	Metrics        []*HANADiskMetric          `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	MetricSource   HANADiskVolumeMetricSource `protobuf:"varint,3,opt,name=metric_source,json=metricSource,proto3,enum=sapagent.protos.wlmvalidation.HANADiskVolumeMetricSource" json:"metric_source,omitempty"`
}

func (x *HANADiskVolumeMetric) Reset() {
	*x = HANADiskVolumeMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANADiskVolumeMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANADiskVolumeMetric) ProtoMessage() {}

func (x *HANADiskVolumeMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANADiskVolumeMetric.ProtoReflect.Descriptor instead.
func (*HANADiskVolumeMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{5}
}

func (x *HANADiskVolumeMetric) GetBasepathVolume() string {
	if x != nil {
		return x.BasepathVolume
	}
	return ""
}

func (x *HANADiskVolumeMetric) GetMetrics() []*HANADiskMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *HANADiskVolumeMetric) GetMetricSource() HANADiskVolumeMetricSource {
	if x != nil {
		return x.MetricSource
	}
	return HANADiskVolumeMetricSource_HANA_DISK_VOLUME_METRIC_SOURCE_UNSPECIFIED
}

type HANADiskMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      DiskVariable                    `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.DiskVariable" json:"value,omitempty"`
}

func (x *HANADiskMetric) Reset() {
	*x = HANADiskMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANADiskMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANADiskMetric) ProtoMessage() {}

func (x *HANADiskMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANADiskMetric.ProtoReflect.Descriptor instead.
func (*HANADiskMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{6}
}

func (x *HANADiskMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *HANADiskMetric) GetValue() DiskVariable {
	if x != nil {
		return x.Value
	}
	return DiskVariable_DISK_VARIABLE_UNSPECIFIED
}

type HANAHighAvailabilityMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      HANAHighAvailabilityVariable    `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.HANAHighAvailabilityVariable" json:"value,omitempty"`
}

func (x *HANAHighAvailabilityMetric) Reset() {
	*x = HANAHighAvailabilityMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANAHighAvailabilityMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANAHighAvailabilityMetric) ProtoMessage() {}

func (x *HANAHighAvailabilityMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANAHighAvailabilityMetric.ProtoReflect.Descriptor instead.
func (*HANAHighAvailabilityMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{7}
}

func (x *HANAHighAvailabilityMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *HANAHighAvailabilityMetric) GetValue() HANAHighAvailabilityVariable {
	if x != nil {
		return x.Value
	}
	return HANAHighAvailabilityVariable_HA_VARIABLE_UNSPECIFIED
}

type HANADisasterRecoveryMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      HANADisasterRecoveryVariable    `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.HANADisasterRecoveryVariable" json:"value,omitempty"`
}

func (x *HANADisasterRecoveryMetric) Reset() {
	*x = HANADisasterRecoveryMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANADisasterRecoveryMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANADisasterRecoveryMetric) ProtoMessage() {}

func (x *HANADisasterRecoveryMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANADisasterRecoveryMetric.ProtoReflect.Descriptor instead.
func (*HANADisasterRecoveryMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{8}
}

func (x *HANADisasterRecoveryMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *HANADisasterRecoveryMetric) GetValue() HANADisasterRecoveryVariable {
	if x != nil {
		return x.Value
	}
	return HANADisasterRecoveryVariable_DR_VARIABLE_UNSPECIFIED
}

type HANABackupMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      HANABackupVariable              `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.HANABackupVariable" json:"value,omitempty"`
}

func (x *HANABackupMetric) Reset() {
	*x = HANABackupMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HANABackupMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HANABackupMetric) ProtoMessage() {}

func (x *HANABackupMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HANABackupMetric.ProtoReflect.Descriptor instead.
func (*HANABackupMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{9}
}

func (x *HANABackupMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *HANABackupMetric) GetValue() HANABackupVariable {
	if x != nil {
		return x.Value
	}
	return HANABackupVariable_HANA_BACKUP_VARIABLE_UNSPECIFIED
}

type ValidationNetweaver struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OsCommandMetrics []*configurablemetrics.OSCommandMetric `protobuf:"bytes,1,rep,name=os_command_metrics,json=osCommandMetrics,proto3" json:"os_command_metrics,omitempty"`
}

func (x *ValidationNetweaver) Reset() {
	*x = ValidationNetweaver{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationNetweaver) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationNetweaver) ProtoMessage() {}

func (x *ValidationNetweaver) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationNetweaver.ProtoReflect.Descriptor instead.
func (*ValidationNetweaver) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{10}
}

func (x *ValidationNetweaver) GetOsCommandMetrics() []*configurablemetrics.OSCommandMetric {
	if x != nil {
		return x.OsCommandMetrics
	}
	return nil
}

type ValidationPacemaker struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMetrics             *PacemakerConfigMetrics                `protobuf:"bytes,1,opt,name=config_metrics,json=configMetrics,proto3" json:"config_metrics,omitempty"`
	CibBootstrapOptionMetrics []*CIBBootstrapOptionMetric            `protobuf:"bytes,2,rep,name=cib_bootstrap_option_metrics,json=cibBootstrapOptionMetrics,proto3" json:"cib_bootstrap_option_metrics,omitempty"`
	OsCommandMetrics          []*configurablemetrics.OSCommandMetric `protobuf:"bytes,3,rep,name=os_command_metrics,json=osCommandMetrics,proto3" json:"os_command_metrics,omitempty"`
}

func (x *ValidationPacemaker) Reset() {
	*x = ValidationPacemaker{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationPacemaker) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationPacemaker) ProtoMessage() {}

func (x *ValidationPacemaker) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationPacemaker.ProtoReflect.Descriptor instead.
func (*ValidationPacemaker) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{11}
}

func (x *ValidationPacemaker) GetConfigMetrics() *PacemakerConfigMetrics {
	if x != nil {
		return x.ConfigMetrics
	}
	return nil
}

func (x *ValidationPacemaker) GetCibBootstrapOptionMetrics() []*CIBBootstrapOptionMetric {
	if x != nil {
		return x.CibBootstrapOptionMetrics
	}
	return nil
}

func (x *ValidationPacemaker) GetOsCommandMetrics() []*configurablemetrics.OSCommandMetric {
	if x != nil {
		return x.OsCommandMetrics
	}
	return nil
}

type PacemakerConfigMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PrimitiveMetrics     []*PacemakerPrimitiveMetric     `protobuf:"bytes,1,rep,name=primitive_metrics,json=primitiveMetrics,proto3" json:"primitive_metrics,omitempty"`
	RscLocationMetrics   []*PacemakerRSCLocationMetric   `protobuf:"bytes,2,rep,name=rsc_location_metrics,json=rscLocationMetrics,proto3" json:"rsc_location_metrics,omitempty"`
	RscOptionMetrics     []*PacemakerRSCOptionMetric     `protobuf:"bytes,3,rep,name=rsc_option_metrics,json=rscOptionMetrics,proto3" json:"rsc_option_metrics,omitempty"`
	HanaOperationMetrics []*PacemakerHANAOperationMetric `protobuf:"bytes,4,rep,name=hana_operation_metrics,json=hanaOperationMetrics,proto3" json:"hana_operation_metrics,omitempty"`
	FenceAgentMetrics    []*PacemakerFenceAgentMetric    `protobuf:"bytes,5,rep,name=fence_agent_metrics,json=fenceAgentMetrics,proto3" json:"fence_agent_metrics,omitempty"`
	AscsMetrics          []*PacemakerASCSMetric          `protobuf:"bytes,6,rep,name=ascs_metrics,json=ascsMetrics,proto3" json:"ascs_metrics,omitempty"`
	OpOptionMetrics      []*OPOptionMetric               `protobuf:"bytes,7,rep,name=op_option_metrics,json=opOptionMetrics,proto3" json:"op_option_metrics,omitempty"`
}

func (x *PacemakerConfigMetrics) Reset() {
	*x = PacemakerConfigMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacemakerConfigMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacemakerConfigMetrics) ProtoMessage() {}

func (x *PacemakerConfigMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacemakerConfigMetrics.ProtoReflect.Descriptor instead.
func (*PacemakerConfigMetrics) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{12}
}

func (x *PacemakerConfigMetrics) GetPrimitiveMetrics() []*PacemakerPrimitiveMetric {
	if x != nil {
		return x.PrimitiveMetrics
	}
	return nil
}

func (x *PacemakerConfigMetrics) GetRscLocationMetrics() []*PacemakerRSCLocationMetric {
	if x != nil {
		return x.RscLocationMetrics
	}
	return nil
}

func (x *PacemakerConfigMetrics) GetRscOptionMetrics() []*PacemakerRSCOptionMetric {
	if x != nil {
		return x.RscOptionMetrics
	}
	return nil
}

func (x *PacemakerConfigMetrics) GetHanaOperationMetrics() []*PacemakerHANAOperationMetric {
	if x != nil {
		return x.HanaOperationMetrics
	}
	return nil
}

func (x *PacemakerConfigMetrics) GetFenceAgentMetrics() []*PacemakerFenceAgentMetric {
	if x != nil {
		return x.FenceAgentMetrics
	}
	return nil
}

func (x *PacemakerConfigMetrics) GetAscsMetrics() []*PacemakerASCSMetric {
	if x != nil {
		return x.AscsMetrics
	}
	return nil
}

func (x *PacemakerConfigMetrics) GetOpOptionMetrics() []*OPOptionMetric {
	if x != nil {
		return x.OpOptionMetrics
	}
	return nil
}

type PacemakerPrimitiveMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      PrimitiveVariable               `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.PrimitiveVariable" json:"value,omitempty"`
}

func (x *PacemakerPrimitiveMetric) Reset() {
	*x = PacemakerPrimitiveMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacemakerPrimitiveMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacemakerPrimitiveMetric) ProtoMessage() {}

func (x *PacemakerPrimitiveMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacemakerPrimitiveMetric.ProtoReflect.Descriptor instead.
func (*PacemakerPrimitiveMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{13}
}

func (x *PacemakerPrimitiveMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *PacemakerPrimitiveMetric) GetValue() PrimitiveVariable {
	if x != nil {
		return x.Value
	}
	return PrimitiveVariable_PRIMITIVE_VARIABLE_UNSPECIFIED
}

type PacemakerRSCLocationMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      RSCLocationVariable             `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.RSCLocationVariable" json:"value,omitempty"`
}

func (x *PacemakerRSCLocationMetric) Reset() {
	*x = PacemakerRSCLocationMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacemakerRSCLocationMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacemakerRSCLocationMetric) ProtoMessage() {}

func (x *PacemakerRSCLocationMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacemakerRSCLocationMetric.ProtoReflect.Descriptor instead.
func (*PacemakerRSCLocationMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{14}
}

func (x *PacemakerRSCLocationMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *PacemakerRSCLocationMetric) GetValue() RSCLocationVariable {
	if x != nil {
		return x.Value
	}
	return RSCLocationVariable_RSC_LOCATION_VARIABLE_UNSPECIFIED
}

type PacemakerRSCOptionMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      RSCOptionVariable               `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.RSCOptionVariable" json:"value,omitempty"`
}

func (x *PacemakerRSCOptionMetric) Reset() {
	*x = PacemakerRSCOptionMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacemakerRSCOptionMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacemakerRSCOptionMetric) ProtoMessage() {}

func (x *PacemakerRSCOptionMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacemakerRSCOptionMetric.ProtoReflect.Descriptor instead.
func (*PacemakerRSCOptionMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{15}
}

func (x *PacemakerRSCOptionMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *PacemakerRSCOptionMetric) GetValue() RSCOptionVariable {
	if x != nil {
		return x.Value
	}
	return RSCOptionVariable_RSC_OPTION_VARIABLE_UNSPECIFIED
}

type PacemakerHANAOperationMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      HANAOperationVariable           `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.HANAOperationVariable" json:"value,omitempty"`
}

func (x *PacemakerHANAOperationMetric) Reset() {
	*x = PacemakerHANAOperationMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacemakerHANAOperationMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacemakerHANAOperationMetric) ProtoMessage() {}

func (x *PacemakerHANAOperationMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacemakerHANAOperationMetric.ProtoReflect.Descriptor instead.
func (*PacemakerHANAOperationMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{16}
}

func (x *PacemakerHANAOperationMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *PacemakerHANAOperationMetric) GetValue() HANAOperationVariable {
	if x != nil {
		return x.Value
	}
	return HANAOperationVariable_HANA_OPERATION_VARIABLE_UNSPECIFIED
}

type PacemakerFenceAgentMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      FenceAgentVariable              `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.FenceAgentVariable" json:"value,omitempty"`
}

func (x *PacemakerFenceAgentMetric) Reset() {
	*x = PacemakerFenceAgentMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacemakerFenceAgentMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacemakerFenceAgentMetric) ProtoMessage() {}

func (x *PacemakerFenceAgentMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacemakerFenceAgentMetric.ProtoReflect.Descriptor instead.
func (*PacemakerFenceAgentMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{17}
}

func (x *PacemakerFenceAgentMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *PacemakerFenceAgentMetric) GetValue() FenceAgentVariable {
	if x != nil {
		return x.Value
	}
	return FenceAgentVariable_FENCE_AGENT_VARIABLE_UNSPECIFIED
}

type PacemakerASCSMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      ASCSVariable                    `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.ASCSVariable" json:"value,omitempty"`
}

func (x *PacemakerASCSMetric) Reset() {
	*x = PacemakerASCSMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacemakerASCSMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacemakerASCSMetric) ProtoMessage() {}

func (x *PacemakerASCSMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacemakerASCSMetric.ProtoReflect.Descriptor instead.
func (*PacemakerASCSMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{18}
}

func (x *PacemakerASCSMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *PacemakerASCSMetric) GetValue() ASCSVariable {
	if x != nil {
		return x.Value
	}
	return ASCSVariable_ASCS_VARIABLE_UNSPECIFIED
}

type CIBBootstrapOptionMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      CIBBootstrapOptionVariable      `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.CIBBootstrapOptionVariable" json:"value,omitempty"`
}

func (x *CIBBootstrapOptionMetric) Reset() {
	*x = CIBBootstrapOptionMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CIBBootstrapOptionMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CIBBootstrapOptionMetric) ProtoMessage() {}

func (x *CIBBootstrapOptionMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CIBBootstrapOptionMetric.ProtoReflect.Descriptor instead.
func (*CIBBootstrapOptionMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{19}
}

func (x *CIBBootstrapOptionMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *CIBBootstrapOptionMetric) GetValue() CIBBootstrapOptionVariable {
	if x != nil {
		return x.Value
	}
	return CIBBootstrapOptionVariable_CIB_BOOTSTRAP_OPTION_VARIABLE_UNSPECIFIED
}

type OPOptionMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *configurablemetrics.MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	Value      OPOptionVariable                `protobuf:"varint,2,opt,name=value,proto3,enum=sapagent.protos.wlmvalidation.OPOptionVariable" json:"value,omitempty"`
}

func (x *OPOptionMetric) Reset() {
	*x = OPOptionMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OPOptionMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OPOptionMetric) ProtoMessage() {}

func (x *OPOptionMetric) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OPOptionMetric.ProtoReflect.Descriptor instead.
func (*OPOptionMetric) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{20}
}

func (x *OPOptionMetric) GetMetricInfo() *configurablemetrics.MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *OPOptionMetric) GetValue() OPOptionVariable {
	if x != nil {
		return x.Value
	}
	return OPOptionVariable_OP_OPTION_VARIABLE_UNSPECIFIED
}

type ValidationCustom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OsCommandMetrics []*configurablemetrics.OSCommandMetric `protobuf:"bytes,1,rep,name=os_command_metrics,json=osCommandMetrics,proto3" json:"os_command_metrics,omitempty"`
}

func (x *ValidationCustom) Reset() {
	*x = ValidationCustom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationCustom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationCustom) ProtoMessage() {}

func (x *ValidationCustom) ProtoReflect() protoreflect.Message {
	mi := &file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationCustom.ProtoReflect.Descriptor instead.
func (*ValidationCustom) Descriptor() ([]byte, []int) {
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP(), []int{21}
}

func (x *ValidationCustom) GetOsCommandMetrics() []*configurablemetrics.OSCommandMetric {
	if x != nil {
		return x.OsCommandMetrics
	}
	return nil
}

var File_protos_wlmvalidation_wlmvalidation_proto protoreflect.FileDescriptor

var file_protos_wlmvalidation_wlmvalidation_proto_rawDesc = []byte{
	0x0a, 0x28, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x50, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf4, 0x04, 0x0a, 0x12,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x10,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x12, 0x62, 0x0a, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x72, 0x6f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x72, 0x6f, 0x73, 0x79, 0x6e, 0x63,
	0x52, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x72, 0x6f,
	0x73, 0x79, 0x6e, 0x63, 0x12, 0x56, 0x0a, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x68, 0x61, 0x6e, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x41, 0x4e, 0x41, 0x52, 0x0e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x61, 0x6e, 0x61, 0x12, 0x65, 0x0a, 0x14,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x65,
	0x61, 0x76, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x73, 0x61, 0x70,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x65, 0x74, 0x77, 0x65, 0x61, 0x76, 0x65, 0x72, 0x52, 0x13,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x65, 0x74, 0x77, 0x65, 0x61,
	0x76, 0x65, 0x72, 0x12, 0x65, 0x0a, 0x14, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x63, 0x65,
	0x6d, 0x61, 0x6b, 0x65, 0x72, 0x52, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x12, 0x5c, 0x0a, 0x11, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x10, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x52, 0x0a, 0x0e, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x75, 0x0a, 0x12, 0x6f,
	0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x4f, 0x53, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x10, 0x6f, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x22, 0xb8, 0x01, 0x0a, 0x0c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x43, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x97, 0x02,
	0x0a, 0x12, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x72, 0x6f,
	0x73, 0x79, 0x6e, 0x63, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x69, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x75, 0x0a, 0x12, 0x6f, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4f, 0x53, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x10, 0x6f, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xf8, 0x05, 0x0a, 0x0e, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x41, 0x4e, 0x41, 0x12, 0x70, 0x0a, 0x12, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x69, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x10, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x49, 0x6e, 0x69, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x6c, 0x0a, 0x18,
	0x68, 0x61, 0x6e, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48,
	0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x6b, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x15, 0x68, 0x61, 0x6e, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x75, 0x0a, 0x12, 0x6f, 0x73,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x4f, 0x53, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x10, 0x6f, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x58, 0x0a, 0x0a, 0x68, 0x61, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x48, 0x69, 0x67, 0x68, 0x41, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x09, 0x68, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x7a, 0x0a, 0x17, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x69, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x15, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x69,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5f, 0x0a, 0x13, 0x68, 0x61, 0x6e, 0x61, 0x5f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x11, 0x68, 0x61, 0x6e, 0x61, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x58, 0x0a, 0x0a, 0x64, 0x72, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x73,
	0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77,
	0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e,
	0x41, 0x44, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x09, 0x64, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x22, 0xe8, 0x01, 0x0a, 0x14, 0x48, 0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x6b, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x27, 0x0a, 0x0f, 0x62,
	0x61, 0x73, 0x65, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x61, 0x73, 0x65, 0x70, 0x61, 0x74, 0x68, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5e, 0x0a,
	0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x6b, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb8, 0x01,
	0x0a, 0x0e, 0x48, 0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x1a, 0x48, 0x41, 0x4e,
	0x41, 0x48, 0x69, 0x67, 0x68, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x51, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x73, 0x61,
	0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c,
	0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41,
	0x48, 0x69, 0x67, 0x68, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xd4, 0x01, 0x0a, 0x1a, 0x48, 0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63,
	0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x51, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc0, 0x01, 0x0a, 0x10, 0x48, 0x41, 0x4e, 0x41, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x48, 0x41, 0x4e, 0x41, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x13, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x65, 0x74, 0x77, 0x65, 0x61, 0x76, 0x65,
	0x72, 0x12, 0x75, 0x0a, 0x12, 0x6f, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4f, 0x53, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x10, 0x6f, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xe4, 0x02, 0x0a, 0x13, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72,
	0x12, 0x5c, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x78,
	0x0a, 0x1c, 0x63, 0x69, 0x62, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x49, 0x42, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61,
	0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x19, 0x63,
	0x69, 0x62, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x75, 0x0a, 0x12, 0x6f, 0x73, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4f, 0x53,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x10, 0x6f,
	0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22,
	0xe1, 0x05, 0x0a, 0x16, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x64, 0x0a, 0x11, 0x70, 0x72,
	0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x50,
	0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x10,
	0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x6b, 0x0a, 0x14, 0x72, 0x73, 0x63, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50,
	0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x52, 0x53, 0x43, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x12, 0x72, 0x73, 0x63, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x65, 0x0a,
	0x12, 0x72, 0x73, 0x63, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61,
	0x6b, 0x65, 0x72, 0x52, 0x53, 0x43, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x10, 0x72, 0x73, 0x63, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x71, 0x0a, 0x16, 0x68, 0x61, 0x6e, 0x61, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x48, 0x41,
	0x4e, 0x41, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x14, 0x68, 0x61, 0x6e, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x68, 0x0a, 0x13, 0x66, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x46, 0x65,
	0x6e, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x11,
	0x66, 0x65, 0x6e, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x55, 0x0a, 0x0c, 0x61, 0x73, 0x63, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65,
	0x72, 0x41, 0x53, 0x43, 0x53, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0b, 0x61, 0x73, 0x63,
	0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x59, 0x0a, 0x11, 0x6f, 0x70, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x50, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x0f, 0x6f, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x22, 0xc7, 0x01, 0x0a, 0x18, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65,
	0x72, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xcb, 0x01,
	0x0a, 0x1a, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x52, 0x53, 0x43, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x32, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x53, 0x43, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x18,
	0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65, 0x72, 0x52, 0x53, 0x43, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x46, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x73,
	0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77,
	0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x53, 0x43,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xcf, 0x01, 0x0a, 0x1c, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61,
	0x6b, 0x65, 0x72, 0x48, 0x41, 0x4e, 0x41, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4a, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x73, 0x61, 0x70,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x41, 0x4e, 0x41, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x19, 0x50, 0x61, 0x63, 0x65,
	0x6d, 0x61, 0x6b, 0x65, 0x72, 0x46, 0x65, 0x6e, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x65, 0x6e, 0x63, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x13, 0x50, 0x61, 0x63, 0x65, 0x6d, 0x61, 0x6b, 0x65,
	0x72, 0x41, 0x53, 0x43, 0x53, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2b, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x53, 0x43, 0x53, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x18, 0x43, 0x49, 0x42, 0x42, 0x6f, 0x6f, 0x74, 0x73,
	0x74, 0x72, 0x61, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x49, 0x42, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61,
	0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xbc, 0x01, 0x0a, 0x0e, 0x4f, 0x50, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x73, 0x61, 0x70, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x77, 0x6c, 0x6d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x50,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x89, 0x01, 0x0a, 0x10, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x12, 0x75, 0x0a, 0x12, 0x6f, 0x73,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x4f, 0x53, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x10, 0x6f, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2a, 0x86, 0x01, 0x0a, 0x11, 0x53, 0x61, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x41, 0x50, 0x5f, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x52, 0x4f,
	0x53, 0x59, 0x4e, 0x43, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x41, 0x4e, 0x41, 0x10, 0x03,
	0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x45, 0x54, 0x57, 0x45, 0x41, 0x56, 0x45, 0x52, 0x10, 0x04, 0x12,
	0x0d, 0x0a, 0x09, 0x50, 0x41, 0x43, 0x45, 0x4d, 0x41, 0x4b, 0x45, 0x52, 0x10, 0x05, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x06, 0x2a, 0xa1, 0x02, 0x0a, 0x0e, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1f, 0x0a,
	0x1b, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x0d, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10,
	0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4f, 0x53, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x56, 0x45, 0x52,
	0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f,
	0x4e, 0x41, 0x4d, 0x45, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f,
	0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x45, 0x54,
	0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x50, 0x53, 0x10, 0x05, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f,
	0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f,
	0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x53, 0x5f,
	0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x10, 0x07, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x50,
	0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x5a, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x53,
	0x45, 0x50, 0x41, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x12, 0x0a, 0x0e, 0x48,
	0x41, 0x53, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x09, 0x12,
	0x0c, 0x0a, 0x08, 0x48, 0x41, 0x53, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x10, 0x0a, 0x12, 0x0b, 0x0a,
	0x07, 0x48, 0x41, 0x53, 0x5f, 0x45, 0x52, 0x53, 0x10, 0x0b, 0x12, 0x12, 0x0a, 0x0e, 0x4b, 0x45,
	0x52, 0x4e, 0x45, 0x4c, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x2a, 0x6b,
	0x0a, 0x0c, 0x44, 0x69, 0x73, 0x6b, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d,
	0x0a, 0x19, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x54, 0x59, 0x50, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x55, 0x4e, 0x54,
	0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x49, 0x5a, 0x45, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x44, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x42, 0x4c, 0x4f,
	0x43, 0x4b, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x10, 0x05, 0x2a, 0xdc, 0x01, 0x0a, 0x12,
	0x48, 0x41, 0x4e, 0x41, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55,
	0x50, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x45, 0x4e, 0x41,
	0x4e, 0x54, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x41, 0x53,
	0x54, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41,
	0x4d, 0x50, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x4c, 0x54, 0x41, 0x5f, 0x54, 0x45,
	0x4e, 0x41, 0x4e, 0x54, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x03, 0x12, 0x1f, 0x0a, 0x1b, 0x4c,
	0x41, 0x53, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x54, 0x41, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50,
	0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14,
	0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x54, 0x5f,
	0x4e, 0x41, 0x4d, 0x45, 0x10, 0x05, 0x12, 0x22, 0x0a, 0x1e, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x53,
	0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x06, 0x2a, 0x50, 0x0a, 0x1c, 0x48, 0x41,
	0x4e, 0x41, 0x48, 0x69, 0x67, 0x68, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x48, 0x41,
	0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x48, 0x41, 0x5f, 0x49, 0x4e,
	0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x2a, 0x52, 0x0a, 0x1c,
	0x48, 0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x17,
	0x44, 0x52, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x52, 0x5f,
	0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x2a, 0xbc, 0x04, 0x0a, 0x11, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54,
	0x49, 0x56, 0x45, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x43,
	0x4d, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x10, 0x01, 0x12,
	0x12, 0x0a, 0x0e, 0x50, 0x43, 0x4d, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x4d, 0x41,
	0x58, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x43, 0x4d, 0x4b, 0x5f, 0x4d, 0x4f, 0x4e, 0x49,
	0x54, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x53, 0x10, 0x03, 0x12, 0x17, 0x0a,
	0x13, 0x50, 0x43, 0x4d, 0x4b, 0x5f, 0x52, 0x45, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x4f, 0x55, 0x54, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e,
	0x41, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x59, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x41,
	0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x43, 0x4c, 0x4f, 0x4e, 0x45, 0x5f, 0x4d, 0x41, 0x58, 0x10,
	0x06, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x43, 0x4c, 0x4f,
	0x4e, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x4d, 0x41, 0x58, 0x10, 0x07, 0x12, 0x16, 0x0a,
	0x12, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4c, 0x45,
	0x41, 0x56, 0x45, 0x10, 0x08, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41,
	0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x43, 0x4c, 0x4f, 0x4e, 0x45, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x5f, 0x4d, 0x41, 0x58, 0x10, 0x09, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x41, 0x50,
	0x48, 0x41, 0x4e, 0x41, 0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4c, 0x45, 0x41, 0x56, 0x45, 0x10, 0x0a, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x41, 0x50,
	0x48, 0x41, 0x4e, 0x41, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x52,
	0x45, 0x47, 0x49, 0x53, 0x54, 0x45, 0x52, 0x10, 0x0b, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x41, 0x50,
	0x48, 0x41, 0x4e, 0x41, 0x5f, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x50,
	0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x0c,
	0x12, 0x20, 0x0a, 0x1c, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x50, 0x52, 0x45, 0x46,
	0x45, 0x52, 0x5f, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x54, 0x41, 0x4b, 0x45, 0x4f, 0x56, 0x45, 0x52,
	0x10, 0x0d, 0x12, 0x20, 0x0a, 0x1c, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x48, 0x45, 0x43,
	0x4b, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56,
	0x41, 0x4c, 0x10, 0x0e, 0x12, 0x1f, 0x0a, 0x1b, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x48,
	0x45, 0x43, 0x4b, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x4f, 0x55, 0x54, 0x10, 0x0f, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4c, 0x42, 0x5f, 0x4d, 0x4f, 0x4e,
	0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x10, 0x12,
	0x17, 0x0a, 0x13, 0x49, 0x4c, 0x42, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x11, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x41, 0x53, 0x5f,
	0x41, 0x4c, 0x49, 0x41, 0x53, 0x5f, 0x49, 0x50, 0x10, 0x12, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x4c,
	0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x13, 0x2a,
	0x59, 0x0a, 0x13, 0x52, 0x53, 0x43, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x53, 0x43, 0x5f, 0x4c, 0x4f,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a,
	0x17, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52,
	0x45, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x10, 0x01, 0x2a, 0x6a, 0x0a, 0x11, 0x52, 0x53,
	0x43, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x23, 0x0a, 0x1f, 0x52, 0x53, 0x43, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x41,
	0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a,
	0x13, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x49, 0x43, 0x4b, 0x49,
	0x4e, 0x45, 0x53, 0x53, 0x10, 0x02, 0x2a, 0xd8, 0x03, 0x0a, 0x15, 0x48, 0x41, 0x4e, 0x41, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x27, 0x0a, 0x23, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x41, 0x50,
	0x48, 0x41, 0x4e, 0x41, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f,
	0x55, 0x54, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f,
	0x53, 0x54, 0x4f, 0x50, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x02, 0x12, 0x1b,
	0x0a, 0x17, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54,
	0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x53,
	0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x44, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x54, 0x49,
	0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x04, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x41, 0x50, 0x48, 0x41,
	0x4e, 0x41, 0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54,
	0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x05, 0x12, 0x23, 0x0a,
	0x1f, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47, 0x59,
	0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54,
	0x10, 0x06, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x54, 0x4f, 0x50,
	0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x4f, 0x55, 0x54, 0x10, 0x07, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41,
	0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x5f, 0x54, 0x49,
	0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x08, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x41, 0x50, 0x48, 0x41,
	0x4e, 0x41, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54,
	0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x09, 0x12, 0x23, 0x0a,
	0x1f, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59,
	0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54,
	0x10, 0x0a, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x41, 0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x53, 0x45,
	0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x0b, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x41,
	0x50, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x5f,
	0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10,
	0x0c, 0x2a, 0x7b, 0x0a, 0x12, 0x46, 0x65, 0x6e, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x46, 0x45, 0x4e, 0x43, 0x45,
	0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x46, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x41, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x4f, 0x47, 0x47, 0x49, 0x4e,
	0x47, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x03, 0x2a, 0xcc,
	0x05, 0x0a, 0x0c, 0x41, 0x53, 0x43, 0x53, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18,
	0x0a, 0x14, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x53, 0x43, 0x53,
	0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x53,
	0x48, 0x4f, 0x4c, 0x44, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x49, 0x43, 0x4b, 0x49, 0x4e, 0x45,
	0x53, 0x53, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x4e, 0x51, 0x55, 0x45,
	0x55, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x45,
	0x52, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x06, 0x12, 0x0a, 0x0a,
	0x06, 0x49, 0x53, 0x5f, 0x45, 0x52, 0x53, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x53, 0x43,
	0x53, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x43, 0x4f,
	0x56, 0x45, 0x52, 0x10, 0x08, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x4d, 0x4f,
	0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x09,
	0x12, 0x18, 0x0a, 0x14, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52,
	0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x0a, 0x12, 0x19, 0x0a, 0x15, 0x45, 0x52,
	0x53, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x43, 0x4f,
	0x56, 0x45, 0x52, 0x10, 0x0b, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x52, 0x53, 0x5f, 0x4d, 0x4f, 0x4e,
	0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x0c, 0x12,
	0x17, 0x0a, 0x13, 0x45, 0x52, 0x53, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x0d, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x53, 0x43, 0x53,
	0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x4d, 0x4f, 0x4e,
	0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x0e, 0x12,
	0x24, 0x0a, 0x20, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x48,
	0x45, 0x43, 0x4b, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x4f, 0x55, 0x54, 0x10, 0x0f, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x49, 0x4c,
	0x42, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56,
	0x41, 0x4c, 0x10, 0x10, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x49, 0x4c, 0x42,
	0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54,
	0x10, 0x11, 0x12, 0x24, 0x0a, 0x20, 0x45, 0x52, 0x53, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48,
	0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x12, 0x12, 0x23, 0x0a, 0x1f, 0x45, 0x52, 0x53, 0x5f,
	0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x4d, 0x4f, 0x4e, 0x49,
	0x54, 0x4f, 0x52, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x13, 0x12, 0x1c, 0x0a,
	0x18, 0x45, 0x52, 0x53, 0x5f, 0x49, 0x4c, 0x42, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52,
	0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x14, 0x12, 0x1b, 0x0a, 0x17, 0x45,
	0x52, 0x53, 0x5f, 0x49, 0x4c, 0x42, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x15, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x4e, 0x53, 0x41,
	0x32, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x16, 0x12, 0x0b, 0x0a, 0x07, 0x41,
	0x53, 0x43, 0x53, 0x5f, 0x49, 0x50, 0x10, 0x17, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x52, 0x53, 0x5f,
	0x49, 0x50, 0x10, 0x18, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x56, 0x49, 0x52,
	0x54, 0x55, 0x41, 0x4c, 0x5f, 0x49, 0x50, 0x10, 0x19, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x52, 0x53,
	0x5f, 0x56, 0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x5f, 0x49, 0x50, 0x10, 0x1a, 0x2a, 0x92, 0x01,
	0x0a, 0x1a, 0x43, 0x49, 0x42, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2d, 0x0a, 0x29,
	0x43, 0x49, 0x42, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x53, 0x54, 0x52, 0x41, 0x50, 0x5f, 0x4f, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x4d,
	0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x4f, 0x4e,
	0x49, 0x54, 0x48, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x13, 0x0a,
	0x0f, 0x53, 0x54, 0x4f, 0x4e, 0x49, 0x54, 0x48, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54,
	0x10, 0x03, 0x2a, 0x46, 0x0a, 0x10, 0x4f, 0x50, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4f, 0x50, 0x5f, 0x4f, 0x50, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4f, 0x50,
	0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x01, 0x2a, 0x8c, 0x01, 0x0a, 0x1a, 0x48,
	0x41, 0x4e, 0x41, 0x44, 0x69, 0x73, 0x6b, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2e, 0x0a, 0x2a, 0x48, 0x41, 0x4e,
	0x41, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x4d, 0x45,
	0x54, 0x52, 0x49, 0x43, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x4c, 0x4f,
	0x42, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x49, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x48, 0x44, 0x42,
	0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x50, 0x41, 0x54,
	0x48, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x49, 0x52, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4e, 0x43, 0x45, 0x5f, 0x45, 0x4e, 0x56, 0x10, 0x03, 0x42, 0x3e, 0x5a, 0x3c, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x73, 0x61, 0x70, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x77, 0x6c, 0x6d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_protos_wlmvalidation_wlmvalidation_proto_rawDescOnce sync.Once
	file_protos_wlmvalidation_wlmvalidation_proto_rawDescData = file_protos_wlmvalidation_wlmvalidation_proto_rawDesc
)

func file_protos_wlmvalidation_wlmvalidation_proto_rawDescGZIP() []byte {
	file_protos_wlmvalidation_wlmvalidation_proto_rawDescOnce.Do(func() {
		file_protos_wlmvalidation_wlmvalidation_proto_rawDescData = protoimpl.X.CompressGZIP(file_protos_wlmvalidation_wlmvalidation_proto_rawDescData)
	})
	return file_protos_wlmvalidation_wlmvalidation_proto_rawDescData
}

var file_protos_wlmvalidation_wlmvalidation_proto_enumTypes = make([]protoimpl.EnumInfo, 15)
var file_protos_wlmvalidation_wlmvalidation_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_protos_wlmvalidation_wlmvalidation_proto_goTypes = []interface{}{
	(SapValidationType)(0),                      // 0: sapagent.protos.wlmvalidation.SapValidationType
	(SystemVariable)(0),                         // 1: sapagent.protos.wlmvalidation.SystemVariable
	(DiskVariable)(0),                           // 2: sapagent.protos.wlmvalidation.DiskVariable
	(HANABackupVariable)(0),                     // 3: sapagent.protos.wlmvalidation.HANABackupVariable
	(HANAHighAvailabilityVariable)(0),           // 4: sapagent.protos.wlmvalidation.HANAHighAvailabilityVariable
	(HANADisasterRecoveryVariable)(0),           // 5: sapagent.protos.wlmvalidation.HANADisasterRecoveryVariable
	(PrimitiveVariable)(0),                      // 6: sapagent.protos.wlmvalidation.PrimitiveVariable
	(RSCLocationVariable)(0),                    // 7: sapagent.protos.wlmvalidation.RSCLocationVariable
	(RSCOptionVariable)(0),                      // 8: sapagent.protos.wlmvalidation.RSCOptionVariable
	(HANAOperationVariable)(0),                  // 9: sapagent.protos.wlmvalidation.HANAOperationVariable
	(FenceAgentVariable)(0),                     // 10: sapagent.protos.wlmvalidation.FenceAgentVariable
	(ASCSVariable)(0),                           // 11: sapagent.protos.wlmvalidation.ASCSVariable
	(CIBBootstrapOptionVariable)(0),             // 12: sapagent.protos.wlmvalidation.CIBBootstrapOptionVariable
	(OPOptionVariable)(0),                       // 13: sapagent.protos.wlmvalidation.OPOptionVariable
	(HANADiskVolumeMetricSource)(0),             // 14: sapagent.protos.wlmvalidation.HANADiskVolumeMetricSource
	(*WorkloadValidation)(nil),                  // 15: sapagent.protos.wlmvalidation.WorkloadValidation
	(*ValidationSystem)(nil),                    // 16: sapagent.protos.wlmvalidation.ValidationSystem
	(*SystemMetric)(nil),                        // 17: sapagent.protos.wlmvalidation.SystemMetric
	(*ValidationCorosync)(nil),                  // 18: sapagent.protos.wlmvalidation.ValidationCorosync
	(*ValidationHANA)(nil),                      // 19: sapagent.protos.wlmvalidation.ValidationHANA
	(*HANADiskVolumeMetric)(nil),                // 20: sapagent.protos.wlmvalidation.HANADiskVolumeMetric
	(*HANADiskMetric)(nil),                      // 21: sapagent.protos.wlmvalidation.HANADiskMetric
	(*HANAHighAvailabilityMetric)(nil),          // 22: sapagent.protos.wlmvalidation.HANAHighAvailabilityMetric
	(*HANADisasterRecoveryMetric)(nil),          // 23: sapagent.protos.wlmvalidation.HANADisasterRecoveryMetric
	(*HANABackupMetric)(nil),                    // 24: sapagent.protos.wlmvalidation.HANABackupMetric
	(*ValidationNetweaver)(nil),                 // 25: sapagent.protos.wlmvalidation.ValidationNetweaver
	(*ValidationPacemaker)(nil),                 // 26: sapagent.protos.wlmvalidation.ValidationPacemaker
	(*PacemakerConfigMetrics)(nil),              // 27: sapagent.protos.wlmvalidation.PacemakerConfigMetrics
	(*PacemakerPrimitiveMetric)(nil),            // 28: sapagent.protos.wlmvalidation.PacemakerPrimitiveMetric
	(*PacemakerRSCLocationMetric)(nil),          // 29: sapagent.protos.wlmvalidation.PacemakerRSCLocationMetric
	(*PacemakerRSCOptionMetric)(nil),            // 30: sapagent.protos.wlmvalidation.PacemakerRSCOptionMetric
	(*PacemakerHANAOperationMetric)(nil),        // 31: sapagent.protos.wlmvalidation.PacemakerHANAOperationMetric
	(*PacemakerFenceAgentMetric)(nil),           // 32: sapagent.protos.wlmvalidation.PacemakerFenceAgentMetric
	(*PacemakerASCSMetric)(nil),                 // 33: sapagent.protos.wlmvalidation.PacemakerASCSMetric
	(*CIBBootstrapOptionMetric)(nil),            // 34: sapagent.protos.wlmvalidation.CIBBootstrapOptionMetric
	(*OPOptionMetric)(nil),                      // 35: sapagent.protos.wlmvalidation.OPOptionMetric
	(*ValidationCustom)(nil),                    // 36: sapagent.protos.wlmvalidation.ValidationCustom
	(*configurablemetrics.OSCommandMetric)(nil), // 37: workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	(*configurablemetrics.MetricInfo)(nil),      // 38: workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	(*configurablemetrics.EvalMetric)(nil),      // 39: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric
}
var file_protos_wlmvalidation_wlmvalidation_proto_depIdxs = []int32{
	16, // 0: sapagent.protos.wlmvalidation.WorkloadValidation.validation_system:type_name -> sapagent.protos.wlmvalidation.ValidationSystem
	18, // 1: sapagent.protos.wlmvalidation.WorkloadValidation.validation_corosync:type_name -> sapagent.protos.wlmvalidation.ValidationCorosync
	19, // 2: sapagent.protos.wlmvalidation.WorkloadValidation.validation_hana:type_name -> sapagent.protos.wlmvalidation.ValidationHANA
	25, // 3: sapagent.protos.wlmvalidation.WorkloadValidation.validation_netweaver:type_name -> sapagent.protos.wlmvalidation.ValidationNetweaver
	26, // 4: sapagent.protos.wlmvalidation.WorkloadValidation.validation_pacemaker:type_name -> sapagent.protos.wlmvalidation.ValidationPacemaker
	36, // 5: sapagent.protos.wlmvalidation.WorkloadValidation.validation_custom:type_name -> sapagent.protos.wlmvalidation.ValidationCustom
	17, // 6: sapagent.protos.wlmvalidation.ValidationSystem.system_metrics:type_name -> sapagent.protos.wlmvalidation.SystemMetric
	37, // 7: sapagent.protos.wlmvalidation.ValidationSystem.os_command_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	38, // 8: sapagent.protos.wlmvalidation.SystemMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	1,  // 9: sapagent.protos.wlmvalidation.SystemMetric.value:type_name -> sapagent.protos.wlmvalidation.SystemVariable
	39, // 10: sapagent.protos.wlmvalidation.ValidationCorosync.config_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric
	37, // 11: sapagent.protos.wlmvalidation.ValidationCorosync.os_command_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	39, // 12: sapagent.protos.wlmvalidation.ValidationHANA.global_ini_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric
	20, // 13: sapagent.protos.wlmvalidation.ValidationHANA.hana_disk_volume_metrics:type_name -> sapagent.protos.wlmvalidation.HANADiskVolumeMetric
	37, // 14: sapagent.protos.wlmvalidation.ValidationHANA.os_command_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	22, // 15: sapagent.protos.wlmvalidation.ValidationHANA.ha_metrics:type_name -> sapagent.protos.wlmvalidation.HANAHighAvailabilityMetric
	39, // 16: sapagent.protos.wlmvalidation.ValidationHANA.indexserver_ini_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric
	24, // 17: sapagent.protos.wlmvalidation.ValidationHANA.hana_backup_metrics:type_name -> sapagent.protos.wlmvalidation.HANABackupMetric
	23, // 18: sapagent.protos.wlmvalidation.ValidationHANA.dr_metrics:type_name -> sapagent.protos.wlmvalidation.HANADisasterRecoveryMetric
	21, // 19: sapagent.protos.wlmvalidation.HANADiskVolumeMetric.metrics:type_name -> sapagent.protos.wlmvalidation.HANADiskMetric
	14, // 20: sapagent.protos.wlmvalidation.HANADiskVolumeMetric.metric_source:type_name -> sapagent.protos.wlmvalidation.HANADiskVolumeMetricSource
	38, // 21: sapagent.protos.wlmvalidation.HANADiskMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	2,  // 22: sapagent.protos.wlmvalidation.HANADiskMetric.value:type_name -> sapagent.protos.wlmvalidation.DiskVariable
	38, // 23: sapagent.protos.wlmvalidation.HANAHighAvailabilityMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	4,  // 24: sapagent.protos.wlmvalidation.HANAHighAvailabilityMetric.value:type_name -> sapagent.protos.wlmvalidation.HANAHighAvailabilityVariable
	38, // 25: sapagent.protos.wlmvalidation.HANADisasterRecoveryMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	5,  // 26: sapagent.protos.wlmvalidation.HANADisasterRecoveryMetric.value:type_name -> sapagent.protos.wlmvalidation.HANADisasterRecoveryVariable
	38, // 27: sapagent.protos.wlmvalidation.HANABackupMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	3,  // 28: sapagent.protos.wlmvalidation.HANABackupMetric.value:type_name -> sapagent.protos.wlmvalidation.HANABackupVariable
	37, // 29: sapagent.protos.wlmvalidation.ValidationNetweaver.os_command_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	27, // 30: sapagent.protos.wlmvalidation.ValidationPacemaker.config_metrics:type_name -> sapagent.protos.wlmvalidation.PacemakerConfigMetrics
	34, // 31: sapagent.protos.wlmvalidation.ValidationPacemaker.cib_bootstrap_option_metrics:type_name -> sapagent.protos.wlmvalidation.CIBBootstrapOptionMetric
	37, // 32: sapagent.protos.wlmvalidation.ValidationPacemaker.os_command_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	28, // 33: sapagent.protos.wlmvalidation.PacemakerConfigMetrics.primitive_metrics:type_name -> sapagent.protos.wlmvalidation.PacemakerPrimitiveMetric
	29, // 34: sapagent.protos.wlmvalidation.PacemakerConfigMetrics.rsc_location_metrics:type_name -> sapagent.protos.wlmvalidation.PacemakerRSCLocationMetric
	30, // 35: sapagent.protos.wlmvalidation.PacemakerConfigMetrics.rsc_option_metrics:type_name -> sapagent.protos.wlmvalidation.PacemakerRSCOptionMetric
	31, // 36: sapagent.protos.wlmvalidation.PacemakerConfigMetrics.hana_operation_metrics:type_name -> sapagent.protos.wlmvalidation.PacemakerHANAOperationMetric
	32, // 37: sapagent.protos.wlmvalidation.PacemakerConfigMetrics.fence_agent_metrics:type_name -> sapagent.protos.wlmvalidation.PacemakerFenceAgentMetric
	33, // 38: sapagent.protos.wlmvalidation.PacemakerConfigMetrics.ascs_metrics:type_name -> sapagent.protos.wlmvalidation.PacemakerASCSMetric
	35, // 39: sapagent.protos.wlmvalidation.PacemakerConfigMetrics.op_option_metrics:type_name -> sapagent.protos.wlmvalidation.OPOptionMetric
	38, // 40: sapagent.protos.wlmvalidation.PacemakerPrimitiveMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	6,  // 41: sapagent.protos.wlmvalidation.PacemakerPrimitiveMetric.value:type_name -> sapagent.protos.wlmvalidation.PrimitiveVariable
	38, // 42: sapagent.protos.wlmvalidation.PacemakerRSCLocationMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	7,  // 43: sapagent.protos.wlmvalidation.PacemakerRSCLocationMetric.value:type_name -> sapagent.protos.wlmvalidation.RSCLocationVariable
	38, // 44: sapagent.protos.wlmvalidation.PacemakerRSCOptionMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	8,  // 45: sapagent.protos.wlmvalidation.PacemakerRSCOptionMetric.value:type_name -> sapagent.protos.wlmvalidation.RSCOptionVariable
	38, // 46: sapagent.protos.wlmvalidation.PacemakerHANAOperationMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	9,  // 47: sapagent.protos.wlmvalidation.PacemakerHANAOperationMetric.value:type_name -> sapagent.protos.wlmvalidation.HANAOperationVariable
	38, // 48: sapagent.protos.wlmvalidation.PacemakerFenceAgentMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	10, // 49: sapagent.protos.wlmvalidation.PacemakerFenceAgentMetric.value:type_name -> sapagent.protos.wlmvalidation.FenceAgentVariable
	38, // 50: sapagent.protos.wlmvalidation.PacemakerASCSMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	11, // 51: sapagent.protos.wlmvalidation.PacemakerASCSMetric.value:type_name -> sapagent.protos.wlmvalidation.ASCSVariable
	38, // 52: sapagent.protos.wlmvalidation.CIBBootstrapOptionMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	12, // 53: sapagent.protos.wlmvalidation.CIBBootstrapOptionMetric.value:type_name -> sapagent.protos.wlmvalidation.CIBBootstrapOptionVariable
	38, // 54: sapagent.protos.wlmvalidation.OPOptionMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	13, // 55: sapagent.protos.wlmvalidation.OPOptionMetric.value:type_name -> sapagent.protos.wlmvalidation.OPOptionVariable
	37, // 56: sapagent.protos.wlmvalidation.ValidationCustom.os_command_metrics:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	57, // [57:57] is the sub-list for method output_type
	57, // [57:57] is the sub-list for method input_type
	57, // [57:57] is the sub-list for extension type_name
	57, // [57:57] is the sub-list for extension extendee
	0,  // [0:57] is the sub-list for field type_name
}

func init() { file_protos_wlmvalidation_wlmvalidation_proto_init() }
func file_protos_wlmvalidation_wlmvalidation_proto_init() {
	if File_protos_wlmvalidation_wlmvalidation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadValidation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationSystem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SystemMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationCorosync); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationHANA); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANADiskVolumeMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANADiskMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANAHighAvailabilityMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANADisasterRecoveryMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HANABackupMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationNetweaver); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationPacemaker); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacemakerConfigMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacemakerPrimitiveMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacemakerRSCLocationMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacemakerRSCOptionMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacemakerHANAOperationMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacemakerFenceAgentMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacemakerASCSMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CIBBootstrapOptionMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OPOptionMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_protos_wlmvalidation_wlmvalidation_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationCustom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_protos_wlmvalidation_wlmvalidation_proto_rawDesc,
			NumEnums:      15,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_protos_wlmvalidation_wlmvalidation_proto_goTypes,
		DependencyIndexes: file_protos_wlmvalidation_wlmvalidation_proto_depIdxs,
		EnumInfos:         file_protos_wlmvalidation_wlmvalidation_proto_enumTypes,
		MessageInfos:      file_protos_wlmvalidation_wlmvalidation_proto_msgTypes,
	}.Build()
	File_protos_wlmvalidation_wlmvalidation_proto = out.File
	file_protos_wlmvalidation_wlmvalidation_proto_rawDesc = nil
	file_protos_wlmvalidation_wlmvalidation_proto_goTypes = nil
	file_protos_wlmvalidation_wlmvalidation_proto_depIdxs = nil
}
