```toml
[advisory]
id = "RUSTSEC-2021-0022"
package = "yottadb"
aliases = ["CVE-2021-27377", "GHSA-9658-c26v-7qvf"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-02-09"
url = "https://gitlab.com/YottaDB/Lang/YDBRust/-/issues/40"
categories = ["memory-corruption"]
keywords = ["use-after-free"]

[versions]
patched = [">= 1.2.0"]

[affected.functions]
"yottadb::Key::sub_next_self_st" = ["< 1.2.0"]
"yottadb::Key::sub_prev_self_st" = ["< 1.2.0"]
"yottadb::KeyContext::sub_next_self_st" = ["< 1.2.0"]
"yottadb::KeyContext::sub_prev_self_st" = ["< 1.2.0"]
```

# Use-after-free in `subscript_next` and `subscript_prev` wrappers

Affected versions of this crate had an unsound implementation which could pass
a pointer to freed memory to `ydb_subscript_next_st` and
`ydb_subscript_prev_st` if the variable and subscripts did not have enough
memory allocated on the first call to hold the next variable in the database.

For example, the following code had undefined behavior:

```rust
let mut key = Key::variable(String::from("a"));
Key::variable("averylongkeywithlotsofletters")
    .set_st(YDB_NOTTP, Vec::new(), b"some val")
    .unwrap();
key.sub_next_self_st(YDB_NOTTP, Vec::new()).unwrap();
```

`yottadb` has no reverse-dependencies on crates.io and there are no known
instances of this API being used incorrectly in practice. The fix is backwards
compatible.

The flaw was corrected by recalculating the pointer each time it was reallocated.
