```toml
[advisory]
id = "RUSTSEC-2024-0431"
package = "xous"
date = "2024-12-23"
url = "https://github.com/betrusted-io/xous-core/issues/410"
references = ["https://github.com/betrusted-io/xous-core/pull/411"]
categories = []
keywords = []
informational = "unsound"

[versions]
patched = [">= 0.9.51"]

[affected]
functions = {"xous::definitions::MemoryRange::as_slice" = ["< 0.9.51"], "xous::definitions::MemoryRange::as_slice_mut" = ["< 0.9.51"]}
```

# Unsound usages of `core::slice::from_raw_parts` 

We consider `as_slice` and `as_slice_mut` unsound because: the pointer with any bit patterns could be cast to the slice of arbitrary types. The pointer could be created by unsafe new and deprecated `from_parts`. We consider that `from_parts` should be removed in latest version because it will help trigger unsoundness in `as_slice`. With new declared as unsafe, `as_slice` should also declared as unsafe.  

This was patched in by marking two functions as `unsafe`.
