```toml
[advisory]
id = "RUSTSEC-2024-0020"
package = "whoami"
date = "2024-02-28"
url = "https://github.com/ardaku/whoami/issues/91"
categories = ["denial-of-service", "memory-corruption"]
keywords = ["buffer-overflow", "stack-buffer-overflow", "cwe-121"]
aliases = ["GHSA-w5w5-8vfh-xcjq"]

[affected]
# Other Unix OSes that aren't Linux or macOS are affected as well.
# bitrig is also vulnerable, but not available as a platform with
# RustSec (and appears to be a dead platform anyway).
os = ["illumos", "solaris", "dragonfly", "freebsd", "netbsd", "openbsd"]

[affected.functions]
"whoami::username" = ["< 1.5.0"]
"whoami::realname" = ["< 1.5.0"]
"whoami::username_os" = ["< 1.5.0"]
"whoami::realname_os" = ["< 1.5.0"]

[versions]
patched = [">= 1.5.0"]
unaffected = ["< 0.5.3"]
```

# Stack buffer overflow with whoami on several Unix platforms

With versions of the whoami crate >= 0.5.3 and < 1.5.0, calling any of these functions leads to an
immediate stack buffer overflow on illumos and Solaris:

- `whoami::username`
- `whoami::realname`
- `whoami::username_os`
- `whoami::realname_os`

With versions of the whoami crate >= 0.5.3 and < 1.0.1, calling any of the above functions also
leads to a stack buffer overflow on these platforms:

- Bitrig
- DragonFlyBSD
- FreeBSD
- NetBSD
- OpenBSD

This occurs because of an incorrect definition of the `passwd` struct on those platforms.

As a result of this issue, denial of service and data corruption have both been observed in the
wild. The issue is possibly exploitable as well.

This vulnerability also affects other Unix platforms that aren't Linux or macOS.

This issue has been addressed in whoami 1.5.0.

For more information, see [this GitHub issue](https://github.com/ardaku/whoami/issues/91).
