```toml
[advisory]
id = "RUSTSEC-2022-0018"
package = "totp-rs"
date = "2022-05-09"
url = "https://github.com/constantoine/totp-rs/security/advisories/GHSA-8vxv-2g8p-2249"
categories = ["crypto-failure"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:N/A:N"
keywords = ["side-channel", "timing-attack"]
aliases = ["CVE-2022-29185", "GHSA-8vxv-2g8p-2249"]

[affected.functions]
"totp_rs::TOTP::check" = ["< 1.1.0"]

[versions]
patched = [">= 1.1.0"]
```

# Timing attack

Affecting versions did not compare tokens in constant time, which could make it possible for an attacker to guess the 2fa token of a user.

This has been fixed by using using the crate constant_time_eq for comparison.
