```toml
[advisory]
id = "RUSTSEC-2024-0376"
package = "tonic"
date = "2024-10-01"
url = "https://github.com/hyperium/tonic/security/advisories/GHSA-4jwc-w2hc-78qv"
categories = ["denial-of-service"]
keywords = ["dos"]
aliases = ["CVE-2024-47609", "GHSA-4jwc-w2hc-78qv"]

[versions]
patched = [">= 0.12.3"]
unaffected = ["<= 0.11.0"]
```

# Remotely exploitable Denial of Service in Tonic

## Impact

When using `tonic::transport::Server` there is a remote DoS attack that can cause the server to exit cleanly on accepting a tcp/tls stream. This can be triggered via causing the accept call to error out with errors there were not covered correctly causing the accept loop to exit. 

More information can be found [here](https://github.com/hyperium/tonic/issues/1897)

## Patches

Upgrading to tonic `0.12.3` and above contains the fix. 

## Workarounds

A custom accept loop is a possible workaround.

