```toml
[advisory]
id = "RUSTSEC-2020-0118"
package = "tiny_future"
date = "2020-12-08"
url = "https://github.com/KizzyCode/tiny_future/issues/1"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]
aliases = ["CVE-2020-36438", "GHSA-fg42-vwxx-xx5j", "GHSA-m296-j53x-xv95"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.4.0"]
```

# Future<T> lacks bounds on Send and Sync.

`tiny_future` contains a light-weight implementation of `Future`s. The `Future`
type it has lacked bound on its `Send` and `Sync` traits.

This allows for a bug where non-thread safe types such as `Cell` can be used in
`Future`s and cause data races in concurrent programs.

The flaw was corrected in commit `c791919` by adding trait bounds to `Future`'s
`Send` and `Sync`.
