```toml
[advisory]
id = "RUSTSEC-2020-0071"
package = "time"
date = "2020-11-18"
url = "https://github.com/time-rs/time/issues/293"
categories = ["code-execution", "memory-corruption"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
keywords = ["segfault"]
aliases = ["CVE-2020-26235", "GHSA-wcg3-cvx6-7396"]

[affected]
# any Unix-like OS
os = [
    "linux",
    "redox",
    "solaris",
    "android",
    "ios",
    "macos",
    "netbsd",
    "openbsd",
    "freebsd",
]
[affected.functions]
"time::at" = ["^0.1"]
"time::at_utc" = ["^0.1"]
"time::now" = ["^0.1"]
"time::UtcOffset::local_offset_at" = ["< 0.2.23"]
"time::UtcOffset::try_local_offset_at" = ["< 0.2.23"]
"time::UtcOffset::current_local_offset" = ["< 0.2.23"]
"time::UtcOffset::try_current_local_offset" = ["< 0.2.23"]
"time::OffsetDateTime::now_local" = ["< 0.2.23"]
"time::OffsetDateTime::try_now_local" = ["< 0.2.23"]

[versions]
patched = [">= 0.2.23"]
unaffected = ["=0.2.0", "=0.2.1", "=0.2.2", "=0.2.3", "=0.2.4", "=0.2.5", "=0.2.6"]
```

# Potential segfault in the time crate

### Impact

The affected functions set environment variables without synchronization. On Unix-like operating systems, this can crash in multithreaded programs. Programs may segfault due to dereferencing a dangling pointer if an environment variable is read in a different thread than the affected functions. This may occur without the user's knowledge, notably in the Rust standard library or third-party libraries.

The affected functions from time 0.2.7 through 0.2.22 are:

- `time::UtcOffset::local_offset_at`
- `time::UtcOffset::try_local_offset_at`
- `time::UtcOffset::current_local_offset`
- `time::UtcOffset::try_current_local_offset`
- `time::OffsetDateTime::now_local`
- `time::OffsetDateTime::try_now_local`

The affected functions in time 0.1 (all versions) are:

- `time::at_utc`
- `time::at`
- `time::now`
- `time::tzset`

Non-Unix targets (including Windows and wasm) are unaffected.

### Patches

Pending a proper fix, the internal method that determines the local offset has been modified to always return `None` on the affected operating systems. This has the effect of returning an `Err` on the `try_*` methods and `UTC` on the non-`try_*` methods.

Users and library authors with time in their dependency tree should perform `cargo update`, which will pull in the updated, unaffected code.

Users of time 0.1 do not have a patch and should upgrade to an unaffected version: time 0.2.23 or greater or the 0.3 series.

### Workarounds

A possible workaround for crates affected through the transitive dependency in `chrono`, is to avoid using the default `oldtime` feature dependency of the `chrono` crate by disabling its `default-features` and manually specifying the required features instead.

#### Examples:

`Cargo.toml`:  

```toml
chrono = { version = "0.4", default-features = false, features = ["serde"] }
```

```toml
chrono = { version = "0.4.22", default-features = false, features = ["clock"] }
```

Commandline:  

```bash
cargo add chrono --no-default-features -F clock
```

Sources:  
 - [chronotope/chrono#602 (comment)](https://github.com/chronotope/chrono/issues/602#issuecomment-1242149249)  
 - [vityafx/serde-aux#21](https://github.com/vityafx/serde-aux/issues/21)  
