```toml
[advisory]
id = "RUSTSEC-2023-0069"

package = "sudo-rs"
date = "2023-11-01"
url = "https://github.com/advisories/GHSA-2r3c-m6v7-9354"
references = ["https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-42456"]
categories = ["file-disclosure"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:N/I:L/A:L"
keywords = ["directory traversal", "http"]
aliases = ["CVE-2023-42456", "GHSA-2r3c-m6v7-9354"]

[versions]
patched = [">= 0.2.1"]
```

# sudo-rs: Path Traversal vulnerability

## Impact
An issue was discovered where usernames containing the . and / characters could result in the corruption of specific files on the filesystem. As usernames are generally not limited by the characters they can contain, a username appearing to be a relative path can be constructed. For example we could add a user to the system containing the username ../../../../bin/cp. When logged in as a user with that name, that user could run sudo -K to clear their session record file. The session code then constructs the path to the session file by concatenating the username to the session file storage directory, resulting in a resolved path of /bin/cp. The code then clears that file, resulting in the cp binary effectively being removed from the system.

An attacker needs to be able to login as a user with a constructed username. Given that such a username is unlikely to exist on an existing system, they will also need to be able to create the users with the constructed usernames.

## Patches
The bug is fixed in version 0.2.1 of sudo-rs. Sudo-rs now uses the uid for the user instead of their username for determining the filename. Note that an upgrade to this version will result in existing session files being ignored and users will be forced to re-authenticate. It also fully eliminates any possibility of path traversal, given that uids are always integer values.

The issue was corrected in commit `bfdbda22968e3de43fa8246cab1681cfd5d5493d`.
