```toml
[advisory]
id = "RUSTSEC-2021-0048"
package = "stackvector"
aliases = ["CVE-2021-29939", "GHSA-9frf-r7c7-j2vg"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L"
date = "2021-02-19"
url = "https://github.com/Alexhuszagh/rust-stackvector/issues/2"
categories = ["memory-corruption"]

[versions]
patched = [">= 1.0.9"]
```

# StackVec::extend can write out of bounds when size_hint is incorrect

`StackVec::extend` used the lower and upper bounds from an Iterator's
`size_hint` to determine how many items to push into the stack based vector.

If the `size_hint` implementation returned a lower bound that was larger than
the upper bound, `StackVec` would write out of bounds and overwrite memory
on the stack. As mentioned by the [size_hint](https://doc.rust-lang.org/std/iter/trait.Iterator.html#provided-methods)
documentation, `size_hint` is mainly for optimization and incorrect
implementations should not lead to memory safety issues.
