```toml
[advisory]
id = "RUSTSEC-2020-0126"
package = "signal-simple"
date = "2020-11-15"
url = "https://github.com/kitsuneninetails/signal-rust/issues/2"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36446", "GHSA-36cg-4jff-5863", "GHSA-8892-84wf-cg8f"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# SyncChannel<T> can move 'T: !Send' to other threads

Affected versions of this crate unconditionally implement Send/Sync for `SyncChannel<T>`.
`SyncChannel<T>` doesn't provide access to `&T` but merely serves as a channel that consumes and returns owned `T`.

Users can create UB in safe Rust by sending `T: !Send` to other threads with `SyncChannel::send/recv` APIs. Using `T = Arc<Cell<_>` allows to create data races (which can lead to memory corruption), and using `T = MutexGuard<T>` allows to unlock a mutex from a thread that didn't lock the mutex.
