```toml
[advisory]
id = "RUSTSEC-2023-0053"
package = "rustls-webpki"
date = "2023-08-22"
categories = ["denial-of-service"]
keywords = ["certificate", "path building", "x509"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
related = ["CVE-2018-16875"]
aliases = ["GHSA-fh2r-99q2-6mmg"]

[versions]
patched = [">= 0.100.2, < 0.101.0", ">= 0.101.4"]
```

# rustls-webpki: CPU denial of service in certificate path building

When this crate is given a pathological certificate chain to validate, it will
spend CPU time exponential with the number of candidate certificates at each
step of path building.

Both TLS clients and TLS servers that accept client certificate are affected.

We now give each path building operation a budget of 100 signature verifications.

The original `webpki` crate is also affected.

This was previously reported in the original crate
<https://github.com/briansmith/webpki/issues/69> and re-reported to us
recently by Luke Malinowski.

