```toml
[advisory]
id = "RUSTSEC-2021-0128"
package = "rusqlite"
date = "2021-12-07"
url = "https://github.com/rusqlite/rusqlite/issues/1048"
categories = ["memory-corruption"]
keywords = ["use-after-free", "incorrect-lifetime"]
aliases = ["CVE-2021-45713", "CVE-2021-45714", "CVE-2021-45715", "CVE-2021-45716", "CVE-2021-45717", "CVE-2021-45718", "CVE-2021-45719", "GHSA-4qr3-m7ww-hh9g", "GHSA-87xh-9q6h-r5cc", "GHSA-92cx-4xm7-jr9m", "GHSA-cm8g-544f-p9x9", "GHSA-f6f2-3w33-54r9", "GHSA-g4g4-3pqw-8m7f", "GHSA-g87r-23vw-7f87", "GHSA-q89g-4vhh-mvvm"]

[affected.functions]

# Under `cfg(feature = "functions")`
"rusqlite::Connection::create_scalar_function" = [">= 0.25.0, < 0.25.4", ">= 0.26.0, < 0.26.2"]
"rusqlite::Connection::create_aggregate_function" = [">= 0.25.0, < 0.25.4", ">= 0.26.0, < 0.26.2"]
"rusqlite::Connection::create_window_function" = [">= 0.25.0, < 0.25.4", ">= 0.26.0, < 0.26.2"]

# Under `cfg(feature = "collation")`
"rusqlite::Connection::create_collation" = [">= 0.25.0, < 0.25.4", ">= 0.26.0, < 0.26.2"]

# Under `cfg(feature = "hooks")`
"rusqlite::Connection::commit_hook" = [">= 0.25.0, < 0.25.4", ">= 0.26.0, < 0.26.2"]
"rusqlite::Connection::rollback_hook" = [">= 0.25.0, < 0.25.4", ">= 0.26.0, < 0.26.2"]
"rusqlite::Connection::update_hook" = [">= 0.25.0, < 0.25.4", ">= 0.26.0, < 0.26.2"]

[versions]
patched = [">= 0.26.2", "0.25.4"]
unaffected = ["< 0.25.0"]
```

# Incorrect Lifetime Bounds on Closures in `rusqlite`

The lifetime bound on several closure-accepting `rusqlite` functions (specifically, functions which register a callback to be later invoked by SQLite) was too relaxed. If a closure referencing borrowed values on the stack is was passed to one of these functions, it could allow Rust code to access objects on the stack after they have been dropped.

The impacted functions are:

- Under `cfg(feature = "functions")`: `Connection::create_scalar_function`, `Connection::create_aggregate_function` and `Connection::create_window_function`.
- Under `cfg(feature = "hooks")`: `Connection::commit_hook`, `Connection::rollback_hook` and `Connection::update_hook`.
- Under `cfg(feature = "collation")`: `Connection::create_collation`.

The issue exists in all `0.25.*` versions prior to `0.25.4`, and all `0.26.*` versions prior to 0.26.2 (specifically: `0.25.0`, `0.25.1`, `0.25.2`, `0.25.3`, `0.26.0`, and `0.26.1`).

The fix is available in versions `0.26.2` and newer, and also has been back-ported to `0.25.4`. As it does not exist in `0.24.*`, all affected versions should have an upgrade path to a semver-compatible release.
