```toml
[advisory]
id = "RUSTSEC-2020-0115"
package = "ruspiro-singleton"
date = "2020-11-16"
url = "https://github.com/RusPiRo/ruspiro-singleton/issues/10"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]
aliases = ["CVE-2020-36435", "GHSA-fqq2-xp7m-xvm8"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.4.1"]
```

# Singleton lacks bounds on Send and Sync.

`Singleton<T>` is meant to be a static object that can be initialized lazily. In
order to satisfy the requirement that `static` items must implement `Sync`,
`Singleton` implemented both `Sync` and `Send` unconditionally.

This allows for a bug where non-`Sync` types such as `Cell` can be used in
singletons and cause data races in concurrent programs.

The flaw was corrected in commit `b0d2bd20e` by adding trait bounds, requiring
the contaiend type to implement `Sync`.
