```toml
[advisory]
id = "RUSTSEC-2022-0031"
package = "rulex"
date = "2022-05-21"
url = "https://github.com/rulex-rs/rulex/security/advisories/GHSA-8v9w-p43c-r885"
categories = ["denial-of-service"]
aliases = ["CVE-2022-31100", "GHSA-8v9w-p43c-r885"]
[versions]
patched = [">= 0.4.3"]
```

# Panic due to improper UTF-8 indexing

When parsing untrusted rulex expressions, rulex may panic, possibly enabling
a Denial of Service attack. This happens when the expression contains a multi-
byte UTF-8 code point in a string literal or after a backslash, because rulex
tries to slice into the code point and panics as a result.

The flaw was corrected in commits `fac6d58b25` and `330b3534e7` by using
`len_utf8()` to derive character width in bytes instead of assuming ASCII
encoding of 1 byte per char.
