```toml
[advisory]
id = "RUSTSEC-2021-0044"
package = "rocket"
aliases = ["CVE-2021-29935", "GHSA-vcw4-8ph6-7vw8"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L"
date = "2021-02-09"
url = "https://github.com/SergioBenitez/Rocket/issues/1534"
informational = "unsound"
categories = ["memory-corruption"]
keywords = ["memory-safety", "use-after-free"]

[versions]
patched = [">= 0.4.7"]
```

# Use after free possible in `uri::Formatter` on panic

Affected versions of this crate transmuted a `&str` to a `&'static str` before
pushing it into a `StackVec`, this value was then popped later in the same
function.

This was assumed to be safe because the reference would be valid while the
method's stack was active. In between the push and the pop, however, a function
`f` was called that could invoke a user provided function.

If the user provided panicked, then the assumption used by the function was no
longer true and the transmute to `&'static` would create an illegal static
reference to the string. This could result in a freed string being used during
(such as in a `Drop` implementation) or after (e.g through `catch_unwind`) the
panic unwinding.

This flaw was corrected in commit [e325e2f](https://github.com/SergioBenitez/Rocket/commit/e325e2fce4d9f9f392761e9fb58b418a48cef8bb)
by using a guard object to ensure that the `&'static str` was dropped inside
the function.
