```toml
[advisory]
id = "RUSTSEC-2020-0094"
package = "reffers"
aliases = ["CVE-2020-36203", "GHSA-39xg-8p43-h76x"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-12-01"
url = "https://github.com/diwic/reffers-rs/issues/7"
informational = "unsound"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]

[versions]
# Versions which include fixes for this vulnerability
patched = [">= 0.6.1"]
```

# Unsound: can make `ARefss` contain a !Send, !Sync object.

`ARefss<'a, V>` is a type that is assumed to contain objects that are `Send + Sync`.

In the affected versions of this crate,
`Send`/`Sync` traits are unconditionally implemented for `ARefss<'a, V>`.

By using the `ARefss::map()` API, we can insert a `!Send` or `!Sync` object into `ARefss<'a, V>`. After that, it is possible to create a data race to the inner object of `ARefss<'a, V>`, which can lead to undefined behavior & memory corruption.

The flaw was corrected in commit 6dd7ca0 (https://github.com/diwic/reffers-rs/commit/6dd7ca0d50f2464df708975cdafcfaeeb6d41c66) by adding trait bound `V: Send + Sync` to `ARefss::map()` API.
