```toml
[advisory]
id = "RUSTSEC-2021-0035"
package = "quinn"
aliases = ["CVE-2021-28036", "GHSA-fhv4-fx3v-77w6"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N"
date = "2021-03-04"
url = "https://github.com/quinn-rs/quinn/issues/968"
keywords = ["memory", "layout", "cast"]
informational = "unsound"

[versions]
patched = ["^0.5.4", "^0.6.2", ">= 0.7.0"]
```

# `quinn` invalidly assumes the memory layout of std::net::SocketAddr

The [`quinn`](https://crates.io/crates/quinn) crate has assumed `std::net::SocketAddrV4`
and `std::net::SocketAddrV6` have the same memory layout as the system C representation
`sockaddr`. It has simply casted the pointers to convert the socket addresses to the
system representation. The standard library does not say anything about the memory
layout, and this will cause invalid memory access if the standard library
changes the implementation. No warnings or errors will be emitted once the
change happens.
