```toml
[advisory]
id = "RUSTSEC-2024-0369"

package = "phonenumber"
date = "2024-07-07"
url = "https://github.com/whisperfish/rust-phonenumber/security/advisories/GHSA-mjw4-jj88-v687"
references = ["https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-39697"]
categories = ["denial-of-service"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H"
keywords = ["panic", "untrusted input", "parsing"]
aliases = ["CVE-2024-39697", "GHSA-mjw4-jj88-v687"]

[affected]
functions = { "phonenumber::parse" = ["*"] }

[versions]
patched = [">=0.3.6"]
unaffected = ["< 0.3.3"]
```

# phonenumber:  panic on parsing crafted phonenumber inputs

### Impact

The phonenumber parsing code may panic due to a reachable `assert!` guard on the phonenumber string.

In a typical deployment of rust-phonenumber, this may get triggered by feeding a maliciously crafted phonenumber, e.g. over the network, specifically strings of the form `+dwPAA;phone-context=AA`, where the "number" part potentially parses as a number larger than 2^56.

Since f69abee1/0.3.4/#52.

0.2.x series is not affected.

### Patches
Patches have been published as version `0.3.6+8.13.36`.
