```toml
[advisory]
id = "RUSTSEC-2023-0082"

package = "phonenumber"
date = "2023-09-19"
url = "https://github.com/whisperfish/rust-phonenumber/security/advisories/GHSA-whhr-7f2w-qqj2"
references = ["https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-42444"]
categories = ["denial-of-service"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H"
keywords = ["panic", "untrusted input", "parsing"]
aliases = ["CVE-2023-42444", "whhr-7f2w-qqj2"]

[affected]
functions = { "phonenumber::parse" = ["*"] }

[versions]
patched = [">= 0.2.5, <0.3.0", ">=0.3.3"]
```

# phonenumber:  panic on parsing crafted RF3966 phonenumber inputs 

### Impact
The phonenumber parsing code may panic due to a panic-guarded out-of-bounds access on the phonenumber string.

In a typical deployment of `rust-phonenumber`, this may get triggered by feeding a maliciously crafted phonenumber over the network, specifically the string `.;phone-context=`.

### Patches
Patches will be published as version `0.3.3+8.13.9` and backported as `0.2.5+8.11.3`.
