```toml
[advisory]
id = "RUSTSEC-2022-0040"
package = "owning_ref"
date = "2022-01-26"
url = "https://github.com/noamtashma/owning-ref-unsoundness"
references = ["https://github.com/Kimundi/owning-ref-rs/issues/49", "https://github.com/Kimundi/owning-ref-rs/issues/61", "https://github.com/Kimundi/owning-ref-rs/issues/71", "https://github.com/Kimundi/owning-ref-rs/issues/77"]
categories = ["memory-corruption"]
aliases = ["GHSA-9qxh-258v-666c"]

[versions]
patched = []
```

# Multiple soundness issues in `owning_ref`

- `OwningRef::map_with_owner` is [unsound](https://github.com/Kimundi/owning-ref-rs/issues/77) and may result in a use-after-free.
- `OwningRef::map` is [unsound](https://github.com/Kimundi/owning-ref-rs/issues/71) and may result in a use-after-free.
- `OwningRefMut::as_owner` and `OwningRefMut::as_owner_mut` are [unsound](https://github.com/Kimundi/owning-ref-rs/issues/61) and may result in a use-after-free.
- The crate [violates Rust's aliasing rules](https://github.com/Kimundi/owning-ref-rs/issues/49), which may cause miscompilations on recent compilers that emit the LLVM `noalias` attribute.

`safer_owning_ref` is a replacement crate which fixes these issues.
No patched versions of the original crate are available, and the maintainer is unresponsive.
