```toml
[advisory]
id = "RUSTSEC-2016-0001"
package = "openssl"
aliases = ["CVE-2016-10931", "GHSA-34p9-f4q3-c4r7"]
cvss = "CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2016-11-05"
keywords = ["ssl", "mitm"]
url = "https://github.com/sfackler/rust-openssl/releases/tag/v0.9.0"
[versions]
patched = [">= 0.9.0"]
```

# SSL/TLS MitM vulnerability due to insecure defaults

All versions of rust-openssl prior to 0.9.0 contained numerous insecure defaults
including off-by-default certificate verification and no API to perform hostname
verification.

Unless configured correctly by a developer, these defaults could allow an attacker
to perform man-in-the-middle attacks.

The problem was addressed in newer versions by enabling certificate verification
by default and exposing APIs to perform hostname verification. Use the
`SslConnector` and `SslAcceptor` types to take advantage of these new features
(as opposed to the lower-level `SslContext` type).
