```toml
[advisory]
id = "RUSTSEC-2022-0059"
package = "openssl-src"
aliases = ["CVE-2022-3358", "GHSA-4f63-89w9-3jjv"]
categories = ["crypto-failure"]
date = "2022-10-11"
url = "https://www.openssl.org/news/secadv/20221011.txt"

[versions]
patched = [">= 300.0.10"]
unaffected = ["< 300.0.0"]
```

# Using a Custom Cipher with `NID_undef` may lead to NULL encryption

OpenSSL supports creating a custom cipher via the legacy `EVP_CIPHER_meth_new()`
function and associated function calls. This function was deprecated in OpenSSL
3.0 and application authors are instead encouraged to use the new provider
mechanism in order to implement custom ciphers.

OpenSSL versions 3.0.0 to 3.0.5 incorrectly handle legacy custom ciphers passed
to the `EVP_EncryptInit_ex2()`, `EVP_DecryptInit_ex2()` and `EVP_CipherInit_ex2()`
functions (as well as other similarly named encryption and decryption
initialisation functions). Instead of using the custom cipher directly it
incorrectly tries to fetch an equivalent cipher from the available providers.
An equivalent cipher is found based on the NID passed to `EVP_CIPHER_meth_new()`.
This NID is supposed to represent the unique NID for a given cipher. However it
is possible for an application to incorrectly pass `NID_undef` as this value in
the call to `EVP_CIPHER_meth_new()`. When `NID_undef` is used in this way the
OpenSSL encryption/decryption initialisation function will match the NULL cipher
as being equivalent and will fetch this from the available providers. This will
succeed if the default provider has been loaded (or if a third party provider
has been loaded that offers this cipher). Using the NULL cipher means that the
plaintext is emitted as the ciphertext.

Applications are only affected by this issue if they call `EVP_CIPHER_meth_new()`
using `NID_undef` and subsequently use it in a call to an encryption/decryption
initialisation function. Applications that only use SSL/TLS are not impacted by
this issue.
