```toml
[advisory]
id = "RUSTSEC-2021-0021"
package = "nb-connect"
aliases = ["CVE-2021-27376", "GHSA-rm4w-6696-r77p"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-02-14"
url = "https://github.com/smol-rs/nb-connect/issues/1"
keywords = ["memory", "layout", "cast"]
informational = "unsound"

[versions]
patched = [">= 1.0.3"]
```

# `nb-connect` invalidly assumes the memory layout of std::net::SocketAddr

The [`nb-connect`](https://crates.io/crates/nb-connect) crate has assumed `std::net::SocketAddrV4`
and `std::net::SocketAddrV6` have the same memory layout as the system C representation
`sockaddr`. It has simply casted the pointers to convert the socket addresses to the
system representation. The standard library does not say anything about the memory
layout, and this will cause invalid memory access if the standard library
changes the implementation. No warnings or errors will be emitted once the
change happens.
