```toml
[advisory]
id = "RUSTSEC-2021-0092"
package = "messagepack-rs"
date = "2021-01-26"
url = "https://github.com/otake84/messagepack-rs/issues/2"
categories = ["memory-exposure"]
aliases = ["CVE-2021-45690", "CVE-2021-45691", "CVE-2021-45692", "CVE-2021-45693", "GHSA-hr52-f9vp-582c", "GHSA-jqjj-r4qp-x2gh", "GHSA-jwfh-j623-m97h", "GHSA-m325-rxjv-pwph", "GHSA-vw5m-qw2r-m923"]

[versions]
patched = []
```

# Deserialization functions pass uninitialized memory to user-provided Read

Affected versions of this crate passed an uninitialized buffer to a
user-provided `Read` instance in:

* `deserialize_binary`
* `deserialize_string`
* `deserialize_extension_others`
* `deserialize_string_primitive`

This can result in safe `Read` implementations reading from the uninitialized
buffer leading to undefined behavior.

