```toml
[advisory]
id = "RUSTSEC-2020-0111"
package = "may_queue"
aliases = ["CVE-2020-36217", "GHSA-pphf-f93w-gc84"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-10"
url = "https://github.com/Xudong-Huang/may/issues/88"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]

[versions]
patched = [">= 0.1.8"]
```

# may_queue's Queue lacks Send/Sync bound for its Send/Sync trait.

Affected versions of `may_queue` implements `Send`/`Sync` for its `Queue` type without restricting it to `Send`able types and `Sync`able types.

This allows non-`Sync` types such as `Cell` to be shared across threads leading to undefined behavior and memory corruption in concurrent programs.
