```toml
[advisory]
id = "RUSTSEC-2021-0130"
package = "lru"
date = "2021-12-21"
url = "https://github.com/jeromefroe/lru-rs/issues/120"
categories = ["memory-corruption"]
keywords = ["use-after-free"]
aliases = ["CVE-2021-45720", "GHSA-qqmc-hwqp-8g2w", "GHSA-v362-2895-h9r2"]

[affected.functions]
"lru::LruCache::iter" = ["< 0.7.1"]
"lru::LruCache::iter_mut" = ["< 0.7.1"]

[versions]
patched = [">= 0.7.1"]
```

# Use after free in lru crate

Lru crate has use after free vulnerability.

Lru crate has two functions for getting an iterator. Both iterators give
references to key and value. Calling specific functions, like pop(), will remove
and free the value, and but it's still possible to access the reference of value
which is already dropped causing use after free.
