```toml
[advisory]
id = "RUSTSEC-2020-0138"
package = "lexer"
date = "2020-11-10"
url = "https://gitlab.com/nathanfaucett/rs-lexer/-/issues/2"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36458", "GHSA-f997-8gxg-r354"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# ReaderResult should be bounded by Sync

Affected versions of this crate implements `Sync` for `ReaderResult<T, E>` with the trait bound `T: Send, E: Send`.

Since matching on the public enum `ReaderResult<T, E>` provides access to `&T` & `&E`,
allowing data race to a non-Sync type `T` or `E`.
This can result in a memory corruption when multiple threads concurrently access `&T` or `&E`.

Suggested fix for the bug is change the trait bounds imposed on `T` & `E` to be `T: Sync, E: Sync`.
